/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.steelstructure.finance.bean.ReceiptRegisterEntity;
import com.ejianc.business.steelstructure.finance.service.IReceiptRegisterService;
import com.ejianc.business.steelstructure.finance.vo.ReceiptRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"receiptRegister"})
public class ReceiptRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "RECEIPT_REGISTER";
    @Autowired
    private IReceiptRegisterService service;
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReceiptRegisterVO> saveOrUpdate(@RequestBody ReceiptRegisterVO saveOrUpdateVO) {
        ReceiptRegisterEntity entity = (ReceiptRegisterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ReceiptRegisterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiptRegisterEntity::getContractId, (Object)entity.getContractId());
        lambda.in(ReceiptRegisterEntity::getBillState, Arrays.asList(1, 3));
        if (entity.getId() != null) {
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
        }
        List list = this.service.list((Wrapper)lambda);
        BigDecimal sum = list.stream().map(ReceiptRegisterEntity::getSumReceivedMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setTotalReceiptMny(sum);
        this.service.saveOrUpdate((Object)entity, false);
        ReceiptRegisterVO vo = (ReceiptRegisterVO)BeanMapper.map((Object)((Object)entity), ReceiptRegisterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiptRegisterVO> queryDetail(Long id) {
        ReceiptRegisterEntity entity = (ReceiptRegisterEntity)((Object)this.service.selectById(id));
        ReceiptRegisterVO vo = (ReceiptRegisterVO)BeanMapper.map((Object)((Object)entity), ReceiptRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiptRegisterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ReceiptRegisterVO receiptRegisterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ReceiptRegisterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                Page emptyPageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), 0L);
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)emptyPageData);
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List vos = BeanMapper.mapList((Iterable)page.getRecords(), ReceiptRegisterVO.class);
        vos.forEach(item -> item.setReceiptContractFlagName(item.getReceiptContractFlag() == 1 ? "\u65e0\u5408\u540c\u6536\u6b3e" : "\u6709\u5408\u540c\u6536\u6b3e"));
        pageData.setRecords(vos);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, ReceiptRegisterVO.class);
        vos.forEach(item -> {
            item.setReceiptContractFlagName(item.getReceiptContractFlag() == 1 ? "\u65e0\u5408\u540c\u6536\u6b3e" : "\u6709\u5408\u540c\u6536\u6b3e");
            if (item.getReceiptContractFlag() == 1) {
                item.setContractName(null);
            } else {
                item.setFeeName(null);
            }
            item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().export("receipt-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refReceiptRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ReceiptRegisterVO>> refReceiptRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ReceiptRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"receipt-import.xlsx", (String)"\u6536\u6b3e\u767b\u8bb0-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(HttpServletRequest request, @RequestBody List<ReceiptRegisterVO> importVOS) {
        return CommonResponse.success((String)this.service.saveImportExcel(request, importVOS));
    }

    @GetMapping(value={"/queryReceiptMny"})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> queryReceiptMny(@RequestParam Long contractId, @RequestParam(value="projectId", required=false) Long projectId) {
        Map<String, BigDecimal> receiptMnyMap = this.service.queryReceiptMny(contractId, projectId);
        return CommonResponse.success(receiptMnyMap);
    }

    @GetMapping(value={"/validateContract"})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="id", required=false) Long id) {
        String msg = this.service.validateContract(contractId, id);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f", (Object)msg);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BigDecimal> getTotalColumnInfo(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter("eq", (Object)orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            param.getParams().put("parentOrgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getOrderMap().put("createTime", "desc");
        String projectRange = null != param.getParams().get("projectRange") ? ((Parameter)param.getParams().get("projectRange")).getValue().toString() : null;
        String dateIn = null != param.getParams().get("dateIn") ? ((Parameter)param.getParams().get("dateIn")).getValue().toString() : null;
        param.getParams().remove("dateIn");
        param.getParams().remove("projectRange");
        if (StringUtils.isNotBlank((CharSequence)projectRange) || StringUtils.isNotBlank((CharSequence)dateIn)) {
            CommonResponse projectIdsResp = this.projectPoolApi.queryProjectIdsByorgId(InvocationInfoProxy.getOrgId(), projectRange, dateIn);
            if (!projectIdsResp.isSuccess()) {
                this.logger.error("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u5931\u8d25, {}", (Object)JSONObject.toJSONString((Object)projectIdsResp));
                return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u9879\u76ee\u4fe1\u606f\u5931\u8d25\uff01");
            }
            if (CollectionUtils.isNotEmpty((Collection)((Collection)projectIdsResp.getData()))) {
                param.getParams().put("projectId", new Parameter("in", projectIdsResp.getData()));
                param.getParams().remove("projectRange");
            } else {
                this.logger.info("\u6839\u636e\u7ec4\u7ec7Id-{}\u67e5\u8be2\u5176\u4e0b\u5728\u5efa\u9879\u76ee\u5217\u8868\u4e3a\u7a7a, \u5219\u8fd4\u56de\u7a7a\u7684\u6570\u636e\u5217\u8868\uff01");
                return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)BigDecimal.ZERO);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.service.getTotalColumnInfo(param, false));
    }

    @PostMapping(value={"/PMReceipt"})
    @ResponseBody
    public CommonResponse<String> PMReceipt() {
        this.service.autoPMReceipt();
        return CommonResponse.success((String)"\u6536\u6b3e\u6210\u529f\uff01");
    }
}

