/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMPayApplyApi;
import com.ejianc.business.financeintegration.PMPayApply.vo.PMPayApplyVO;
import com.ejianc.business.steelstructure.finance.bean.PaymentApplyEntity;
import com.ejianc.business.steelstructure.finance.service.IPaymentApplyService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="paymentApply")
public class PaymentApplyBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IPaymentApplyService service;
    @Autowired
    private IPMPayApplyApi pmPayApplyApi;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7-\u63d0\u4ea4\u524d\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u7533\u8bf7\u7ec8\u5ba1\u56de\u8c03\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return null;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return null;
    }

    private CommonResponse<PMPayApplyVO> takeEffectApply(Long id) {
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---takeEffectApply\u65b9\u6cd5---begin\uff0c\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}", (Object)id);
        PaymentApplyEntity sourceEntity = (PaymentApplyEntity)((Object)this.service.selectById(id));
        if (sourceEntity == null) {
            this.logger.error("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3", (Object)id);
            return CommonResponse.error((String)("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-\u3010" + id + "\u3011\u67e5\u8be2\u4e0d\u5230\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3"));
        }
        this.logger.info("\u6839\u636e\u672c\u4ed8\u6b3e\u7533\u8bf7ID-{}\uff0c\u67e5\u8be2\u5230\u7684\u672c\u4ed8\u6b3e\u7533\u8bf7\u6570\u636e-{}", (Object)id, (Object)JSONObject.toJSONString((Object)((Object)sourceEntity), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        PMPayApplyVO paramVO = new PMPayApplyVO();
        Long projectId = sourceEntity.getProjectId();
        paramVO.setProjectId(null);
        if (projectId != null) {
            paramVO.setProjectId(projectId.toString());
        }
        Long supplierId = sourceEntity.getSupplierId();
        paramVO.setSupplierId(null);
        if (supplierId != null) {
            paramVO.setSupplierId(supplierId.toString());
        }
        Long payeeId = sourceEntity.getPayeeId();
        paramVO.setPayeeId(null);
        if (payeeId != null) {
            paramVO.setPayeeId(payeeId.toString());
        }
        Integer paymentContractFlag = sourceEntity.getPaymentContractFlag();
        Long contractId = sourceEntity.getContractId();
        paramVO.setIsContract(null);
        paramVO.setContractRegisterId(null);
        if (paymentContractFlag != null) {
            if (paymentContractFlag == 0) {
                paramVO.setIsContract(Integer.valueOf(1));
                if (contractId != null) {
                    paramVO.setContractRegisterId(contractId.toString());
                }
            } else {
                paramVO.setIsContract(Integer.valueOf(0));
                paramVO.setContractRegisterId("-1");
            }
        }
        paramVO.setCurApplyMny(sourceEntity.getApprovalMny());
        this.logger.info("\u5f00\u59cb\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u751f\u6548\u63a5\u53e3\uff0c\u63a5\u53e3\u53c2\u6570VO-{}", (Object)paramVO.toString());
        CommonResponse res = this.pmPayApplyApi.takeEffect(paramVO);
        this.logger.info("\u8c03\u7528PM\u4ed8\u6b3e\u7533\u8bf7\u7684\u751f\u6548\u63a5\u53e3---ejc-profinance\u9879\u76ee---PaymentApplyBpmServiceImpl\u7c7b---takeEffectApply\u65b9\u6cd5---end\uff0c\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c-{}", (Object)JSONObject.toJSONString((Object)res, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u4ed8\u6b3e\u7533\u8bf7\u63a8\u9001\u4e2d\u95f4\u8868\u5931\u8d25");
        }
        return res;
    }
}

