/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.mapper.ContractRegisterMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.service.impl.ContractRegisterBpmServiceImpl;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.steelstructure.income.vo.ContractReviewVO;
import com.ejianc.business.steelstructure.income.vo.RegisterResVO;
import com.ejianc.business.steelstructure.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractRegister"})
public class ContractRegisterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IContractRegisterService service;
    @Autowired
    private ContractRegisterBpmServiceImpl bpmService;
    @Autowired
    private IPMContractApi contractApi;
    @Autowired
    private IContractReviewService contractReviewService;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ContractRegisterMapper mapper;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> saveOrUpdate(@RequestBody ContractRegisterVO saveorUpdateVO) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrUpdate(saveorUpdateVO));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryDetail(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.service.selectById(id));
        ContractRegisterVO vo = (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryRegisterVO"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RegisterResVO> queryRegisterVO(Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        lambda.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)lambda);
        RegisterResVO registerResVO = new RegisterResVO();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            registerResVO = (RegisterResVO)BeanMapper.map(list.get(0), RegisterResVO.class);
            registerResVO.setContractBaseMny(((ContractRegisterEntity)((Object)list.get(0))).getBaseMoney());
            registerResVO.setContractBaseTaxMny(((ContractRegisterEntity)((Object)list.get(0))).getBaseTaxMoney());
            registerResVO.setContractId(((ContractRegisterEntity)((Object)list.get(0))).getId());
        }
        LambdaQueryWrapper lambda2 = Wrappers.lambdaQuery();
        lambda2.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda2.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        lambda2.in(ContractReviewEntity::getBillState, new Object[]{1, 3});
        List list2 = this.contractReviewService.list((Wrapper)lambda2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            ContractReviewEntity contractReviewEntity = (ContractReviewEntity)((Object)list2.get(0));
            registerResVO.setEngineeringTypeId(contractReviewEntity.getEngineeringTypeId());
            registerResVO.setEngineeringTypeName(contractReviewEntity.getEngineeringTypeName());
            registerResVO.setBuiltArea(contractReviewEntity.getBuiltArea());
            registerResVO.setContractualModel(contractReviewEntity.getContractualModel());
            registerResVO.setStartDate(contractReviewEntity.getStartDate());
            registerResVO.setEndDate(contractReviewEntity.getEndDate());
            registerResVO.setFundsSourceId(contractReviewEntity.getFundsSourceId());
            registerResVO.setFundsSource(contractReviewEntity.getFundsSource());
            registerResVO.setAddress(contractReviewEntity.getAddress());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)registerResVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractRegisterVO> vos) {
        this.service.removeByIds(vos.stream().map(ContractRegisterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.service.pageList(param));
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<ContractRegisterVO> list = this.service.excelExport(param);
        HashMap<String, List<ContractRegisterVO>> beans = new HashMap<String, List<ContractRegisterVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("contract-register-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractRegisterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractRegisterVO>> refContractRegisterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        param.getParams().put("supplementFlag", new Parameter("eq", (Object)0));
        param.getParams().put("isRelieve", new Parameter("eq", (Object)0));
        param.getParams().put("isSuspend", new Parameter("eq", (Object)0));
        ArrayList<String> changeStatusList = new ArrayList<String>();
        changeStatusList.add("1");
        changeStatusList.add("3");
        param.getParams().put("changeStatus", new Parameter("in", changeStatusList));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            boolean isBudget;
            boolean isRelieve;
            boolean isFinish;
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
            if (null != conditionMap.get("isFinish") && !(isFinish = Boolean.parseBoolean(conditionMap.get("isFinish").toString()))) {
                param.getParams().remove("isFinish");
            }
            if (!Objects.equals(conditionMap.get("isRelieve"), null) && !(isRelieve = Boolean.parseBoolean(conditionMap.get("isRelieve").toString()))) {
                param.getParams().remove("isRelieve");
            }
            if (!Objects.equals(conditionMap.get("isBudget"), null) && !(isBudget = Boolean.parseBoolean(conditionMap.get("isBudget").toString()))) {
                param.getParams().remove("changeStatus");
            }
            if (null != conditionMap.get("isEstimation")) {
                Integer isEstimation = Integer.valueOf(conditionMap.get("isEstimation").toString());
                param.getParams().put("isEstimation", new Parameter("eq", (Object)isEstimation));
            }
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        param.getParams().put("billState", new Parameter("in", billStatus));
        param.getOrderMap().put("createTime", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractRegisterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/addRegisterByRevId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addRegisterByRevId(Long reviewId) {
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)this.service.addRegisterByRevId(reviewId));
    }

    @RequestMapping(value={"/addSupplementByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> addSupplementByConId(Long mainContractId) {
        ContractRegisterVO vo = this.service.addSupplementByConId(mainContractId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySupplementRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RegisterSupplementHistoryVO> querySupplementRecord(@RequestParam Long id) {
        RegisterSupplementHistoryVO vo = this.service.querySupplementRecord(id);
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryRegisterByReviewId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractRegisterEntity>> queryRegisterByReviewId(@RequestParam Long reviewId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f", this.service.queryRegisterByReviewId(reviewId));
    }

    @GetMapping(value={"/syncPushContract"})
    @ResponseBody
    public CommonResponse<Boolean> syncPushContract(@RequestParam(value="id") Long id) {
        ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)this.service.selectById(id));
        ContractRegisterVO vo = (ContractRegisterVO)BeanMapper.map((Object)((Object)registerEntity), ContractRegisterVO.class);
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.pushContract(vo, false));
    }

    @GetMapping(value={"/queryReviewByProject"})
    @ResponseBody
    public CommonResponse<ContractReviewVO> queryReviewByProject(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u540c\u6b65\u5408\u540c\u6c60\u6210\u529f\uff01", (Object)this.service.queryReviewByProject(projectId));
    }

    @GetMapping(value={"/pushToCw"})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> pushToCw(@RequestParam(value="contractId") Long contractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.service.getById(contractId));
        CommonResponse listCommonResponse = this.contractApi.queryDetail(String.valueOf(contractId), entity.getIsEstimation());
        if (listCommonResponse.getCode() == 0) {
            if (((List)listCommonResponse.getData()).size() > 0) {
                throw new BusinessException("\u6b64\u5408\u540c\u8d22\u52a1\u4e2d\u95f4\u5e93\u4e2d\u5df2\u5b58\u5728\uff01");
            }
            return this.service.pushToCw(entity);
        }
        return CommonResponse.error((String)listCommonResponse.getMsg());
    }

    @GetMapping(value={"/queryEstimationByProject"})
    @ResponseBody
    public CommonResponse<Boolean> queryEstimationByProject(@RequestParam(value="projectId") Long projectId) {
        List list = this.service.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ContractRegisterEntity::getProjectId, (Object)projectId)).eq(ContractRegisterEntity::getIsEstimation, (Object)1)).eq(BaseEntity::getDr, (Object)0));
        boolean flag = false;
        if (list.size() != 0) {
            flag = true;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)flag);
    }

    @RequestMapping(value={"/queryDetailByCustomerId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryDetailByCustomerId(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.pageList(param));
    }

    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("constructionPartner");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        IPage pageData = this.service.queryPage(param, false);
        List records = pageData.getRecords();
        for (ContractRegisterEntity record : records) {
            CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(record.getProjectId());
            if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
                ProjectPoolSetVO data = (ProjectPoolSetVO)projectPoolSetVO.getData();
                record.setOrgName("\u672a\u77e5");
                if (data.getBusinessStatus() != null) {
                    switch (data.getBusinessStatus()) {
                        case "1": {
                            record.setOrgName("\u5728\u65bd");
                            break;
                        }
                        case "2": {
                            record.setOrgName("\u505c\u5de5");
                            break;
                        }
                        case "3": {
                            record.setOrgName("\u5728\u65bd");
                            break;
                        }
                        case "4": {
                            record.setOrgName("\u5f85\u7ae3\u5de5");
                            break;
                        }
                        case "5": {
                            record.setOrgName("\u9879\u76ee\u4e2d\u6b62");
                            break;
                        }
                        case "6": {
                            record.setOrgName("\u7ae3\u5de5");
                            break;
                        }
                        case "7": {
                            record.setOrgName("\u672a\u51b3\u7b97");
                            break;
                        }
                        case "8": {
                            record.setOrgName("\u51b3\u7b97\u4e2d");
                            break;
                        }
                        case "9": {
                            record.setOrgName("\u5df2\u51b3\u7b97");
                            break;
                        }
                        case "10": {
                            record.setOrgName("\u8d44\u6599\u672a\u5f52\u6863");
                            break;
                        }
                        case "11": {
                            record.setOrgName("\u8d44\u6599\u5df2\u5f52\u6863");
                            break;
                        }
                        case "12": {
                            record.setOrgName("\u7f3a\u9677\u8d23\u4efb\u671f");
                            break;
                        }
                        case "13": {
                            record.setOrgName("\u7f3a\u9677\u8d23\u4efb\u671f\u7ed3\u675f");
                            break;
                        }
                        case "14": {
                            record.setOrgName("\u5f00\u8d26\u6b63\u5e38");
                            break;
                        }
                        case "15": {
                            record.setOrgName("\u8d44\u91d1\u51bb\u7ed3");
                            break;
                        }
                        case "16": {
                            record.setOrgName("\u6210\u672c\u5173\u95e8");
                            break;
                        }
                        case "17": {
                            record.setOrgName("\u5df2\u9500\u8d26");
                            break;
                        }
                        case "0": {
                            record.setOrgName("\u672a\u5f00\u5de5");
                            break;
                        }
                        default: {
                            record.setOrgName("\u672a\u77e5");
                        }
                    }
                }
            }
            if (record.getReviewId() == null) continue;
            ContractReviewVO contractReviewVO = this.contractReviewService.queryDetail(record.getReviewId());
            record.setChangeReason(contractReviewVO.getManagerName());
        }
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        return page;
    }

    @RequestMapping(value={"/queryRegisterVOByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractRegisterVO> queryRegisterVOByProjectId(Long projectId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ContractRegisterEntity::getProjectId, (Object)projectId);
        lambda.in(ContractRegisterEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)lambda);
        ContractRegisterVO registerResVO = new ContractRegisterVO();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            registerResVO = (ContractRegisterVO)BeanMapper.map(list.get(0), ContractRegisterVO.class);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)registerResVO);
    }

    @RequestMapping(value={"/queryDesktopFinance"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryDesktopFinance() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("BaseTaxMoney", (Object)this.mapper.queryBaseTaxMoney());
        jsonObject.put("IncomeContractTaxMny", (Object)this.mapper.queryIncomeContractTaxMny());
        jsonObject.put("IncomeContractNum", (Object)this.mapper.queryIncomeContractNum());
        jsonObject.put("YearSum", (Object)this.mapper.queryYearSum());
        jsonObject.put("LastMonthSum", (Object)this.mapper.queryLastMonthSum());
        jsonObject.put("SumReceivedMnyYear", (Object)this.mapper.querySumReceivedMnyYear());
        jsonObject.put("ContractTaxMny", (Object)this.mapper.queryContractTaxMny());
        jsonObject.put("ContractNum", (Object)this.mapper.queryContractNum());
        jsonObject.put("SettlementTaxMnyYear", (Object)this.mapper.querySettlementTaxMnyYear());
        jsonObject.put("SettlementTaxMny", (Object)this.mapper.querySettlementTaxMny());
        jsonObject.put("ApplyMny", (Object)this.mapper.queryApplyMny());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }

    @RequestMapping(value={"/queryFinanceUseLeader"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(@RequestParam String dateIn, @RequestParam(value="orgId", required=false) Long orgId) {
        return this.service.queryFinanceUseLeader(dateIn, orgId);
    }
}

