/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.steelstructure.income.bean.MonthlyStatisticsEntity;
import com.ejianc.business.steelstructure.income.mapper.TaskMapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/outputValue/"})
public class OutputValueApi {
    @Autowired
    private TaskMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"getSumByOrgIdUnder"}, method={RequestMethod.GET})
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value="orgId") Long orgId, @RequestParam(value="year") Integer year) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (!year.equals(0)) {
            param.getParams().put("statDate", new Parameter("between", (Object)(year + "-1-1," + year + "-12-31")));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)sum);
    }
}

