/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.bid.vo.DeptOrderApiVO;
import com.ejianc.business.contractbase.home.consts.ProjectSurveyEnum;
import com.ejianc.business.contractbase.home.util.EJCDateUtil;
import com.ejianc.business.contractbase.home.vo.FinanceUseResSubVO;
import com.ejianc.business.contractbase.home.vo.FinanceUseResVO;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.cwdataexchange.PMContractPush.api.IPMContractApi;
import com.ejianc.business.cwdataexchange.PMContractPush.vo.PMContractVO;
import com.ejianc.business.steelstructure.finance.vo.MnyDTO;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractReviewEntity;
import com.ejianc.business.steelstructure.income.enums.BillStateEnum;
import com.ejianc.business.steelstructure.income.enums.ContractStatusEnum;
import com.ejianc.business.steelstructure.income.mapper.ContractRegisterMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractReviewService;
import com.ejianc.business.steelstructure.income.utils.BillTypeCodeEnum;
import com.ejianc.business.steelstructure.income.utils.ValidateUtil;
import com.ejianc.business.steelstructure.income.vo.ContractRegisterVO;
import com.ejianc.business.steelstructure.income.vo.ContractReviewVO;
import com.ejianc.business.steelstructure.income.vo.CustomerCountWithYearVO;
import com.ejianc.business.steelstructure.income.vo.RegisterSupplementHistoryVO;
import com.ejianc.business.steelstructure.warn.SqlParam;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.ICustomerProApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.CustomerIncomeInfoVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="contractRegisterService")
public class ContractRegisterServiceImpl
extends BaseServiceImpl<ContractRegisterMapper, ContractRegisterEntity>
implements IContractRegisterService {
    private static final String INCOME_CONTRACT_REGISTER = "\u94a2\u6784\u5408\u540c\u767b\u8bb0";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ValidateUtil validateUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractReviewService reviewService;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    public ContractRegisterMapper mapper;
    @Autowired
    private IProjectSetApi projectSetApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPMContractApi contractApi;
    @Autowired
    private ICustomerProApi customerProApi;

    @Override
    public ContractRegisterVO saveOrUpdate(ContractRegisterVO saveorUpdateVO) {
        List entityList;
        LambdaQueryWrapper lambda;
        if (saveorUpdateVO.getConjoinedManageType() != null) {
            if (saveorUpdateVO.getConjoinedManageType().equals(1) && saveorUpdateVO.getBaseTaxMoney() != null && saveorUpdateVO.getContractBaseTaxMnyNoConjoined() != null && saveorUpdateVO.getBaseTaxMoney().compareTo(saveorUpdateVO.getContractBaseTaxMnyNoConjoined()) != 0) {
                throw new BusinessException("\u5e76\u5217\u5173\u7cfb\u65f6\uff0c\u2018\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u2019\u4e0e\u2018\u542b\u7a0e\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\uff08\u4e0d\u542b\u8054\u5408\u4f53\uff09\u2019\u5e94\u76f8\u7b49\uff01");
            }
            if (saveorUpdateVO.getConjoinedManageType().equals(2) && saveorUpdateVO.getBaseTaxMoney() != null && saveorUpdateVO.getContractBaseTaxMny() != null && saveorUpdateVO.getBaseTaxMoney().compareTo(saveorUpdateVO.getContractBaseTaxMny()) != 0) {
                throw new BusinessException("\u5408\u5e76\u5173\u7cfb\u65f6\uff0c\u2018\u5408\u540c\u7b7e\u8ba2\u91d1\u989d\u2019\u4e0e\u2018\u542b\u7a0e\u5408\u540c\u7b7e\u8ba2\u603b\u91d1\u989d\u2019\u5e94\u76f8\u7b49\uff01");
            }
        }
        if (!Objects.equals(null, saveorUpdateVO.getReviewId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveorUpdateVO.getReviewId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c\u8bc4\u5ba1.getCode(), saveorUpdateVO.getReviewVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, ContractRegisterEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (entity.getId() == null || entity.getId() == 0L) {
            if (StringUtils.isBlank((CharSequence)entity.getBillCode())) {
                String billCode = null;
                if (Objects.equals(entity.getSupplementFlag(), ContractRegisterVO.CONTRACT_TYPE_SUPPLEMENT)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)entity.getMainContractId());
                    wrapper.in(ContractRegisterEntity::getBillState, Arrays.asList(1, 3));
                    List list = this.list((Wrapper)wrapper);
                    String supplementNum = "";
                    supplementNum = list.size() < 10 ? supplementNum + "0" + (list.size() + 1) : supplementNum + (list.size() + 1);
                    billCode = entity.getMainContractCode() + "-2-" + supplementNum;
                } else {
                    BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_CONTRACT_REGISTER, (Long)tenantId, (BaseVO)saveorUpdateVO);
                    CommonResponse response = this.billCodeApi.generateBillCode(billCodeParam);
                    if (response.isSuccess()) {
                        billCode = (String)response.getData();
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                entity.setBillCode(billCode);
            }
            lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            entity.setIsFinish(0);
            entity.setIsRelieve(0);
            entity.setIsSuspend(0);
            entity.setContractStatus(ContractStatusEnum.\u672a\u7b7e\u8ba2.getCode());
            entity.setChangeStatus("1");
        } else {
            if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
                throw new BusinessException("\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            lambda = new LambdaQueryWrapper();
            lambda.eq(ContractRegisterEntity::getBillCode, (Object)entity.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)entity.getId());
            entityList = super.list((Wrapper)lambda);
            if (ListUtil.isNotEmpty((List)entityList)) {
                throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
            }
            if (null == entity.getBillState()) {
                entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            }
        }
        if (entity.getIsConjioned() == 0) {
            entity.setContractTaxMny(entity.getBaseTaxMoney());
            entity.setContractMny(entity.getBaseMoney());
            entity.setTaxMny(entity.getBaseTax());
            entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTaxMoney(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
            entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseMoney(), (BigDecimal)entity.getTotalCostAdjustMny()));
            entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTax(), (BigDecimal)entity.getTotalCostAdjustTax()));
            entity.setNicContractMny(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeSub((BigDecimal)entity.getBaseMoney(), (BigDecimal)entity.getProvisionalMny()), (BigDecimal[])new BigDecimal[]{ComputeUtil.safeAdd((BigDecimal)entity.getTaxRate(), (BigDecimal)new BigDecimal(100)), new BigDecimal(0.01)}));
        } else {
            BigDecimal taxMonty;
            BigDecimal contractMny = entity.getContractBaseMnyConjoined().add(entity.getContractBaseMnyNoConjoined());
            entity.setContractMny(entity.getBaseMoney());
            entity.setContractTaxMny(entity.getBaseTaxMoney());
            if (entity.getConjoinedManageType() == 1) {
                taxMonty = entity.getContractBaseTaxMnyNoConjoined().subtract(entity.getContractBaseMnyNoConjoined());
                entity.setTaxMny(taxMonty);
                entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getContractBaseTaxMnyNoConjoined(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
                entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)entity.getContractBaseMnyNoConjoined(), (BigDecimal)entity.getTotalCostAdjustMny()));
                entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)taxMonty, (BigDecimal)entity.getTotalCostAdjustTax()));
                entity.setNicContractMny(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeSub((BigDecimal)entity.getContractBaseMnyNoConjoined(), (BigDecimal)entity.getProvisionalMny()), (BigDecimal[])new BigDecimal[]{ComputeUtil.safeAdd((BigDecimal)entity.getNoConjoinedTax(), (BigDecimal)new BigDecimal(100)), new BigDecimal(0.01)}));
            }
            if (entity.getConjoinedManageType() == 2) {
                taxMonty = entity.getContractBaseTaxMny().subtract(entity.getContractMny());
                entity.setTaxMny(taxMonty);
                entity.setTotalAfterCostAdjustTaxMny(ComputeUtil.safeAdd((BigDecimal)entity.getBaseTaxMoney(), (BigDecimal)entity.getTotalCostAdjustTaxMny()));
                entity.setTotalAfterCostAdjustMny(ComputeUtil.safeAdd((BigDecimal)entity.getContractMny(), (BigDecimal)entity.getTotalCostAdjustMny()));
                entity.setTotalAfterCostAdjustTax(ComputeUtil.safeAdd((BigDecimal)taxMonty, (BigDecimal)entity.getTotalCostAdjustTax()));
                entity.setNicContractMny(ComputeUtil.safeAdd((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeSub((BigDecimal)entity.getContractBaseMnyNoConjoined(), (BigDecimal)entity.getProvisionalMny()), (BigDecimal[])new BigDecimal[]{ComputeUtil.safeAdd((BigDecimal)entity.getNoConjoinedTax(), (BigDecimal)new BigDecimal(100)), new BigDecimal(0.01)}), (BigDecimal)entity.getContractBaseTaxMnyConjoined()));
            }
        }
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny());
        super.saveOrUpdate((Object)entity, false);
        return (ContractRegisterVO)BeanMapper.map((Object)((Object)entity), ContractRegisterVO.class);
    }

    @Override
    public JSONObject pageList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("constructionPartner");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage pageData = this.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractRegisterVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("contractCount", contractAmountMap);
        return page;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractRegisterServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"round(sum(base_tax_money),2) as originalAmount, round(sum(contract_tax_mny),2) as curAmount"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public List<ContractRegisterVO> excelExport(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List entityList = this.queryList(param);
        List voList = BeanMapper.mapList((Iterable)entityList, ContractRegisterVO.class);
        for (ContractRegisterVO vo : voList) {
            String contractStatus = vo.getContractStatus();
            if (StringUtils.isNotBlank((CharSequence)contractStatus)) {
                if (Objects.equals(contractStatus, "1")) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                }
                if (Objects.equals(contractStatus, "2")) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
                if (Objects.equals(contractStatus, "3")) {
                    vo.setContractStatusName("\u5df2\u89e3\u9664");
                }
            } else {
                vo.setContractStatusName("");
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        }
        return voList;
    }

    @Override
    public ContractRegisterVO addRegisterByRevId(Long reviewId) {
        ContractReviewEntity entity = (ContractReviewEntity)((Object)this.reviewService.selectById(reviewId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setReviewId(reviewId);
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractName(entity.getContractName());
        vo.setSignDate(new Date());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setBaseTaxMoney(entity.getContractTaxMny());
        vo.setBaseMoney(entity.getContractMny());
        vo.setBaseTax(entity.getTaxMny());
        vo.setStartDate(entity.getStartDate());
        vo.setEndDate(entity.getEndDate());
        vo.setSchedule(entity.getSchedule());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setSignDate(new Date());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)entity.getMainContractId());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isNotEmpty((List)list)) {
            ContractRegisterEntity registerEntity = (ContractRegisterEntity)((Object)list.get(0));
            vo.setMainContractId(registerEntity.getId());
            vo.setMainContractCode(registerEntity.getBillCode());
            vo.setMainContractName(registerEntity.getContractName());
        }
        return vo;
    }

    @Override
    public ContractRegisterVO addSupplementByConId(Long mainContractId) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(mainContractId));
        ContractRegisterVO vo = new ContractRegisterVO();
        vo.setProjectId(entity.getProjectId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgCode(entity.getOrgCode());
        vo.setOrgName(entity.getOrgName());
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode());
        vo.setParentOrgName(entity.getParentOrgName());
        vo.setContractType(entity.getContractType());
        vo.setCustomerId(entity.getCustomerId());
        vo.setCustomerName(entity.getCustomerName());
        vo.setSupplierId(entity.getSupplierId());
        vo.setSupplierName(entity.getSupplierName());
        vo.setConstructionPartner(entity.getConstructionPartner());
        vo.setTaxRate(entity.getTaxRate());
        vo.setContractPartyc(entity.getContractPartyc());
        vo.setConjoinedContractTotalMny(entity.getConjoinedContractTotalMny());
        vo.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        vo.setEmployeeName(this.sessionManager.getUserContext().getUserName());
        vo.setDeptId(this.sessionManager.getUserContext().getDeptId());
        vo.setDeptName(this.sessionManager.getUserContext().getDeptName());
        vo.setMainContractId(mainContractId);
        vo.setMainContractName(entity.getContractName());
        vo.setMainContractCode(entity.getBillCode());
        vo.setContractBaseTaxMnyNoConjoined(entity.getContractBaseTaxMnyNoConjoined());
        vo.setContractBaseTaxMny(entity.getContractBaseTaxMny());
        vo.setContractBaseMnyNoConjoined(entity.getContractBaseMnyNoConjoined());
        vo.setContractBaseMnyConjoined(entity.getContractBaseMnyConjoined());
        vo.setContractBaseMny(entity.getContractBaseMny());
        vo.setConjoinedManageType(entity.getConjoinedManageType());
        vo.setContractTypeName(entity.getContractTypeName());
        vo.setEstimationTaxMny(entity.getEstimationTaxMny());
        vo.setCostAccounting(entity.getCostAccounting());
        vo.setAccountingProjectId(entity.getAccountingProjectId());
        vo.setAccountingProject(entity.getAccountingProject());
        vo.setRegisterPursuant(entity.getRegisterPursuant());
        vo.setCwProjectId(entity.getCwProjectId());
        vo.setCwProjectCode(entity.getCwProjectCode());
        vo.setCwProjectName(entity.getCwProjectName());
        vo.setCwAccountCode(entity.getCwAccountCode());
        vo.setCwProjectTypeId(entity.getCwProjectTypeId());
        vo.setCwProjectType(entity.getCwProjectType());
        vo.setCwNatureAccounting(entity.getCwNatureAccounting());
        vo.setContractBaseTaxMnyConjoined(entity.getContractBaseTaxMnyConjoined());
        vo.setEngineeringTypeId(entity.getEngineeringTypeId());
        vo.setEngineeringType(entity.getEngineeringType());
        return vo;
    }

    @Override
    public RegisterSupplementHistoryVO querySupplementRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.selectById(id));
        RegisterSupplementHistoryVO vo = new RegisterSupplementHistoryVO();
        vo.setId(id);
        vo.setMainContractId(id);
        vo.setContractTaxMny(entity.getContractTaxMny());
        vo.setContractMny(entity.getContractMny());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getMainContractId, (Object)id);
        wrapper.orderByDesc(ContractRegisterEntity::getSignDate);
        List supplementList = super.list((Wrapper)wrapper);
        vo.setSupplementToalTaxMny(supplementList.stream().map(ContractRegisterEntity::getContractTaxMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setSupplementToalMny(supplementList.stream().map(ContractRegisterEntity::getContractMny).filter(x -> x != null).reduce(BigDecimal.ZERO, BigDecimal::add));
        vo.setDetailList(BeanMapper.mapList((Iterable)supplementList, ContractRegisterVO.class));
        return vo;
    }

    @Override
    public List<ContractRegisterEntity> queryRegisterByReviewId(Long reviewId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractRegisterEntity::getReviewId, (Object)reviewId);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<ContractRegisterEntity>();
        }
        return list;
    }

    @Override
    public boolean pushContract(ContractRegisterVO vo, Boolean updateLevel) {
        return true;
    }

    @Override
    public boolean delContractFromPool(Long id) {
        return true;
    }

    @Override
    public List<Map<String, Object>> queryBudgetWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryBudgetWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryCostWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryCostWarnContract(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> queryContractRegisterWarnContract(List<SqlParam> sqlParamList) {
        return this.mapper.queryContractRegisterWarnContract(sqlParamList);
    }

    @Override
    public ContractReviewVO queryReviewByProject(Long projectId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractReviewEntity::getProjectId, (Object)projectId);
        wrapper.eq(ContractReviewEntity::getSupplementFlag, (Object)0);
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.reviewService.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ContractReviewVO();
        }
        return (ContractReviewVO)BeanMapper.map(list.get(0), ContractReviewVO.class);
    }

    @Override
    public CommonResponse<ContractRegisterVO> pushToCw(ContractRegisterEntity contractEntity) {
        CommonResponse defDocBy;
        this.logger.info("\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868  ------------------------\u5f00\u59cb");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Integer supplementFlag = contractEntity.getSupplementFlag();
        Integer isEstimation = contractEntity.getIsEstimation();
        CommonResponse projectPoolSetVO = this.projectSetApi.getProjectId(contractEntity.getProjectId());
        PMContractVO pmContractVO = (PMContractVO)BeanMapper.map((Object)((Object)contractEntity), PMContractVO.class);
        if (isEstimation != null && isEstimation.equals(1)) {
            pmContractVO.setZgbz(Integer.valueOf(1));
            pmContractVO.setBslx("\u6682\u4f30\u5408\u540c");
            pmContractVO.setContractStatus(Integer.valueOf(0));
        } else {
            pmContractVO.setZgbz(Integer.valueOf(0));
            if (supplementFlag.equals(0)) {
                pmContractVO.setBslx("\u6b63\u5f0f\u5408\u540c");
            } else {
                pmContractVO.setBslx("\u8865\u5145\u534f\u8bae");
            }
        }
        pmContractVO.setContractId(String.valueOf(contractEntity.getId()));
        if (contractEntity.getSignDate() != null) {
            pmContractVO.setDjrq(sdf.format(contractEntity.getSignDate()));
            pmContractVO.setSignDate(sdf.format(contractEntity.getSignDate()));
        }
        pmContractVO.setContractCode(contractEntity.getBillCode());
        if (contractEntity.getBaseTaxMoney() != null) {
            pmContractVO.setHtljhsje(contractEntity.getBaseTaxMoney());
        }
        if (contractEntity.getContractType() != null && (defDocBy = this.defdocApi.getDefDocById(contractEntity.getContractType())).getCode() == 0 && defDocBy.getData() != null) {
            pmContractVO.setContractType(((DefdocDetailVO)defDocBy.getData()).getName());
        }
        pmContractVO.setContractTypeName("\u65bd\u5de5\u5408\u540c");
        if (projectPoolSetVO != null && projectPoolSetVO.getData() != null) {
            CommonResponse defDocById;
            ProjectPoolSetVO data = (ProjectPoolSetVO)projectPoolSetVO.getData();
            if (data.getAreaName() != null) {
                pmContractVO.setSzs(data.getAreaName());
            }
            if (data.getAddress() != null) {
                pmContractVO.setXxdz(data.getAddress());
            }
            if (data.getEngineeringType() != null && (defDocById = this.defdocApi.getDefDocById(data.getEngineeringType())).getCode() == 0 && defDocById.getData() != null) {
                pmContractVO.setGclb(((DefdocDetailVO)defDocById.getData()).getName());
            }
            if (data.getMeasureType() != null && data.getMeasureType().equals(1506803511994617857L) && data.getMeasureValue() != null) {
                pmContractVO.setJzmj(data.getMeasureValue());
            }
            if (data.getPlanStartDate() != null) {
                pmContractVO.setKgrq(sdf.format(data.getPlanStartDate()));
            }
            if (data.getPlanEndDate() != null) {
                pmContractVO.setJgrq(sdf.format(data.getPlanEndDate()));
            }
            if (data.getProjectManagementName() != null) {
                pmContractVO.setXmfzr(data.getProjectManagementName());
            }
            if (data.getProjectManagementPhone() != null) {
                pmContractVO.setXmfzedh(data.getProjectManagementPhone());
            }
        }
        CommonResponse pmContractVOCommonResponse = this.contractApi.saveContract(pmContractVO);
        this.logger.info("\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868  ------------------------\u7ed3\u675f" + JSON.toJSONString((Object)pmContractVOCommonResponse));
        return CommonResponse.success((String)"\u63a8\u9001\u8d22\u52a1\u4e2d\u95f4\u8868\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)contractEntity), ContractRegisterVO.class));
    }

    @Override
    public CustomerIncomeInfoVO queryCustomerInfo(Long customerId) {
        return this.mapper.queryCustomerInfo(customerId);
    }

    @Override
    public List<CustomerCountWithYearVO> queryCountByCustomerId(Long customerId, String dateIn) {
        CommonResponse listCommonResponse;
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(customerId);
        if ("all".equals(dateIn) && (listCommonResponse = this.customerProApi.queryChildrenId(customerId)).getCode() == 0) {
            List data = (List)listCommonResponse.getData();
            longs.addAll(data);
        }
        List<CustomerCountWithYearVO> customerCountWithYearVOS = this.mapper.queryCountByCustomerId(longs);
        for (CustomerCountWithYearVO customerCountWithYearVO : customerCountWithYearVOS) {
            BigDecimal bigDecimal = customerCountWithYearVO.getSum().divide(new BigDecimal(10000)).setScale(2, 4);
            customerCountWithYearVO.setSum(bigDecimal);
        }
        return customerCountWithYearVOS;
    }

    @Override
    public CommonResponse<FinanceUseResVO> queryFinanceUseLeader(String dateIn, Long orgId) {
        String startMonth = null;
        String endMonth = null;
        if (ProjectSurveyEnum.THISYEAR.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getYear() + "-01-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR3MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-2) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else if (ProjectSurveyEnum.NEAR6MON.getCode().equals(dateIn)) {
            startMonth = EJCDateUtil.getMonth((int)-5) + "-01";
            endMonth = EJCDateUtil.getMonth((int)0) + "-31";
        } else {
            startMonth = EJCDateUtil.getLastYear() + "-01-01";
            endMonth = EJCDateUtil.getLastYear() + "-12-31";
        }
        LocalDate startDate = LocalDate.parse(startMonth, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate endDate = LocalDate.parse(endMonth, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        List<String> yearMonthList = ContractRegisterServiceImpl.getYearMonthList(startDate, endDate);
        List<MnyDTO> financeContract = this.mapper.queryFinanceContract(startMonth, endMonth);
        List<MnyDTO> financeSettle = this.mapper.queryFinanceSettle(startMonth, endMonth);
        List<MnyDTO> financePay = this.mapper.queryFinancePay(startMonth, endMonth);
        Map<String, BigDecimal> collect = financeContract.stream().collect(Collectors.toMap(MnyDTO::getBillDate, MnyDTO::getMny));
        Map<String, BigDecimal> collect1 = financeSettle.stream().collect(Collectors.toMap(MnyDTO::getBillDate, MnyDTO::getMny));
        Map<String, BigDecimal> collect2 = financePay.stream().collect(Collectors.toMap(MnyDTO::getBillDate, MnyDTO::getMny));
        FinanceUseResSubVO financeUseResSubVO = new FinanceUseResSubVO();
        FinanceUseResSubVO financeUseResSubVO1 = new FinanceUseResSubVO();
        FinanceUseResSubVO financeUseResSubVO2 = new FinanceUseResSubVO();
        ArrayList<BigDecimal> contractDecimals = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> settleDecimals = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> payDecimals = new ArrayList<BigDecimal>();
        for (String s : yearMonthList) {
            if (collect.containsKey(s)) {
                contractDecimals.add(collect.get(s));
            } else {
                contractDecimals.add(BigDecimal.ZERO);
            }
            if (collect1.containsKey(s)) {
                settleDecimals.add(collect1.get(s));
            } else {
                settleDecimals.add(BigDecimal.ZERO);
            }
            if (collect2.containsKey(s)) {
                payDecimals.add(collect2.get(s));
                continue;
            }
            payDecimals.add(BigDecimal.ZERO);
        }
        FinanceUseResVO resVO = new FinanceUseResVO();
        financeUseResSubVO.setMonthData(contractDecimals);
        financeUseResSubVO1.setMonthData(settleDecimals);
        financeUseResSubVO2.setMonthData(payDecimals);
        resVO.setMonthData(yearMonthList);
        resVO.setSettleMoney(financeUseResSubVO1);
        resVO.setPayMoney(financeUseResSubVO2);
        resVO.setContract(financeUseResSubVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8d44\u91d1\u4f7f\u7528\u6570\u636e\u6210\u529f\uff01", (Object)resVO);
    }

    @Override
    public List<DeptOrderApiVO> queryDeptOrderList(QueryWrapper wrapper) {
        return this.mapper.queryDeptOrderList(wrapper);
    }

    public static List<String> getYearMonthList(LocalDate startDate, LocalDate endDate) {
        ArrayList<YearMonth> yearMonths = new ArrayList<YearMonth>();
        LocalDate current = startDate;
        while (current.isBefore(endDate.plusDays(1L)) || current.isEqual(endDate)) {
            yearMonths.add(YearMonth.from(current));
            current = current.plusMonths(1L);
        }
        List<String> stringList = yearMonths.stream().map(YearMonth::toString).collect(Collectors.toList());
        return stringList;
    }
}

