/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.income.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.steelstructure.income.bean.ContractRegisterEntity;
import com.ejianc.business.steelstructure.income.bean.ContractSuspendEntity;
import com.ejianc.business.steelstructure.income.mapper.ContractSuspendMapper;
import com.ejianc.business.steelstructure.income.service.IContractRegisterService;
import com.ejianc.business.steelstructure.income.service.IContractSuspendService;
import com.ejianc.business.steelstructure.income.utils.BillTypeCodeEnum;
import com.ejianc.business.steelstructure.income.utils.ValidateUtil;
import com.ejianc.business.steelstructure.income.vo.ContractSuspendVO;
import com.ejianc.business.steelstructure.income.vo.RegisterSuspendHistoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="contractSuspendService")
public class ContractSuspendServiceImpl
extends BaseServiceImpl<ContractSuspendMapper, ContractSuspendEntity>
implements IContractSuspendService {
    private static final String INCOME_SUSPEND_RELIEVE = "INCOME_SUSPEND_RELIEVE";
    @Autowired
    private IContractRegisterService registerService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ValidateUtil validateUtil;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ContractSuspendVO saveOrUpdate(ContractSuspendVO saveOrUpdateVO) {
        if (!Objects.equals(null, saveOrUpdateVO.getContractId()) && !this.validateUtil.validateUpStreamVersion(String.valueOf(saveOrUpdateVO.getContractId()), BillTypeCodeEnum.\u65bd\u5de5\u5408\u540c.getCode(), saveOrUpdateVO.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        ContractSuspendEntity entity = (ContractSuspendEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractSuspendEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            this.validateContract(entity.getContractId(), entity.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)INCOME_SUSPEND_RELIEVE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
        } else {
            this.validateContract(entity.getContractId(), entity.getId());
        }
        this.saveOrUpdate((Object)entity, false);
        return (ContractSuspendVO)BeanMapper.map((Object)((Object)entity), ContractSuspendVO.class);
    }

    @Override
    public ContractSuspendVO queryLastSuspend(Long contractId) {
        List<ContractSuspendEntity> list = this.querySuspendByContractId(contractId);
        if (ListUtil.isEmpty(list)) {
            return new ContractSuspendVO();
        }
        return (ContractSuspendVO)BeanMapper.map((Object)((Object)list.get(0)), ContractSuspendVO.class);
    }

    @Override
    public RegisterSuspendHistoryVO querySuspendRecord(Long id) {
        ContractRegisterEntity entity = (ContractRegisterEntity)((Object)this.registerService.selectById(id));
        RegisterSuspendHistoryVO vo = new RegisterSuspendHistoryVO();
        vo.setContractId(entity.getId());
        vo.setChangeStatus(entity.getChangeStatus());
        vo.setIsFinish(entity.getIsFinish());
        vo.setIsRelieve(entity.getIsRelieve());
        vo.setIsSuspend(entity.getIsSuspend());
        vo.setContractStartDate(entity.getStartDate());
        vo.setContractEndDate(entity.getEndDate());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractSuspendEntity::getContractId, (Object)id);
        wrapper.orderByDesc(ContractSuspendEntity::getSuspendRelieveDate);
        List list = super.list((Wrapper)wrapper);
        vo.setDetailList(BeanMapper.mapList((Iterable)list, ContractSuspendVO.class));
        return vo;
    }

    @Override
    public List<ContractSuspendEntity> querySuspendByContractId(Long contractId) {
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(1);
        billStateList.add(3);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(ContractSuspendEntity::getContractId, (Object)contractId);
        wrapper.in(ContractSuspendEntity::getBillState, billStateList);
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<ContractSuspendEntity>();
        }
        return list;
    }

    @Override
    public Boolean validateContract(Long contractId, Long id) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (!Objects.equals(null, id)) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)id));
        }
        if (ListUtil.isNotEmpty((List)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u7684\u5408\u540c\u4e2d\u6b62/\u4e2d\u6b62\u89e3\u9664\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return true;
    }
}

