/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.proother.contract.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherChangeEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractEntity;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherChangeService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractService;
import com.ejianc.business.steelstructure.proother.contract.vo.ChangeVO;
import com.ejianc.business.steelstructure.proother.contract.vo.ContractVO;
import com.ejianc.business.steelstructure.proother.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.proother.enums.SignatureStatusEnum;
import com.ejianc.business.steelstructure.proother.util.ParamCtrlUtil;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"prootherchange"})
public class ProotherChangeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProotherChangeService service;
    @Autowired
    private IProotherContractService contractService;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IExecutionApi executionApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ChangeVO> saveOrUpdate(@RequestBody ChangeVO saveorUpdateVO) {
        ChangeVO vo = this.service.insertOrUpdate(saveorUpdateVO, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetail(Long id) {
        ChangeVO vo = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ChangeVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            ArrayList totalExecutionVOList = new ArrayList();
            ArrayList prootherContractEntityList = new ArrayList();
            for (ChangeVO ChangeVO2 : vos) {
                ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)this.service.selectById(ChangeVO2.getId()));
            }
            ContractVO tmp = null;
            for (ProotherContractEntity prootherContractEntity : prootherContractEntityList) {
                tmp = (ContractVO)BeanMapper.map((Object)((Object)prootherContractEntity), ContractVO.class);
            }
        }
        return this.service.deleteById(vos.get(0).getId());
    }

    public String getLinkUrl(ContractVO cv) {
        String linkUrl = 0 == cv.getSupplementFlag() ? (0 == cv.getAddType() ? this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubCard" : this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/card?id=" + cv.getId() + "&cardType=otherSubDirectCard") : (0 == cv.getAddType() ? this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubCard" : this.BaseHost + "ejc-steelstructure-frontend/#/otherSubList/supplementCard?id=" + cv.getId() + "&supplementFlag=" + cv.getSupplementFlag() + "&performanceStatus=" + cv.getPerformanceStatus() + "&cardType=otherSubDirectCard");
        return linkUrl;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ChangeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        CommonResponse orgResp = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!orgResp.isSuccess()) {
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        param.getParams().put("orgId", new Parameter("in", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ChangeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryDetailRecord(Long id) {
        ChangeVO vo = this.service.queryDetailRecord(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/addConvertByConId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> addConvertByConId(Long contractId, Long changeId) {
        ChangeVO vo = this.service.addConvertByConId(contractId, changeId);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryChangeCompare"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map> queryChangeCompare(Long id) {
        Map<String, Object> returnMap = this.service.queryChangeCompare(id);
        return CommonResponse.success((String)"\u65b0\u589e\u8f6c\u6362\u6570\u636e\u6210\u529f\uff01", returnMap);
    }

    @RequestMapping(value={"/queryChangeRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ChangeVO> queryChangeRecord(Long contractId, Long changeId) {
        ChangeVO vo = this.service.queryChangeRecord(contractId, changeId);
        return CommonResponse.success((String)"\u53d8\u66f4\u8bb0\u5f55\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/changeSignatureProcess"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeSignatureProcess(Long id) {
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)this.service.selectById(id));
        if (prootherChangeEntity != null) {
            prootherChangeEntity.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
            prootherChangeEntity.setEffectiveDate(new Date());
            prootherChangeEntity.setPerformanceStatus(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode());
            prootherChangeEntity.setChangeFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
            this.service.saveOrUpdate((Object)prootherChangeEntity);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)prootherChangeEntity.getContractId());
            updateWrapper.set(ProotherContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(prootherChangeEntity.getSignatureStatus()));
            updateWrapper.set(ProotherContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
            this.contractService.update(this.contractService.selectById(prootherChangeEntity.getContractId()), (Wrapper)updateWrapper, false);
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/targetCostCtrl"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody ChangeVO changeVO) {
        ChangeVO cv = this.service.insertOrUpdate(changeVO, true);
        String linkUrl = this.service.getLinkUrl(cv);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", null);
    }

    @GetMapping(value={"/viewTargetCostCtrlInfo"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value="id") Long id) {
        ChangeVO cv = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", null);
    }

    private ParamsCheckVO paramCheck(@RequestBody ChangeVO changeVO, CommonResponse<ParamsCheckVO> response, boolean flag) {
        ParamsCheckVO responseData = (ParamsCheckVO)response.getData();
        ParamsCheckVO resp = new ParamsCheckVO();
        List<ParamsCheckVO> checkVOList = this.service.changeMnyCtrl(changeVO, flag);
        checkVOList.addAll(this.service.checkParamsConstruction(changeVO));
        Map<String, List<ParamsCheckVO>> checkListMap = checkVOList.stream().filter(e -> e.getDataSource().size() > 0).collect(Collectors.groupingBy(ParamsCheckVO::getWarnType));
        List<Object> result = new ArrayList();
        if (null != checkListMap.get("alert")) {
            result = checkListMap.get("alert");
            resp.setWarnType("alert");
        } else if (null != checkListMap.get("warn")) {
            result = checkListMap.get("warn");
            resp.setWarnType("warn");
        } else {
            resp.setWarnType("none");
        }
        if (null == responseData.getWarnType() || ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) < ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else if (ParamCtrlUtil.getWarnTypeInt(responseData.getWarnType(), 1) == ParamCtrlUtil.getWarnTypeInt(resp.getWarnType(), 1)) {
            if (CollectionUtils.isNotEmpty((Collection)responseData.getDataSource())) {
                resp.getDataSource().addAll(responseData.getDataSource());
            }
            for (ParamsCheckVO paramsCheckVO : result) {
                resp.getDataSource().addAll(paramsCheckVO.getDataSource());
            }
        } else {
            return responseData;
        }
        return resp;
    }
}

