/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.proother.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.enums.ContractPerformanceStateEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherChangeEntity;
import com.ejianc.business.steelstructure.proother.contract.bean.ProotherContractEntity;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherChangeService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractAsyncService;
import com.ejianc.business.steelstructure.proother.contract.service.IProotherContractService;
import com.ejianc.business.steelstructure.proother.enums.ChangeStatusEnum;
import com.ejianc.business.steelstructure.proother.enums.DraftTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.ProotherBillTypeEnum;
import com.ejianc.business.steelstructure.proother.enums.SignatureStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="prootherChange")
public class ProotherChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IProotherChangeService changeService;
    @Autowired
    private IProotherContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IProotherContractAsyncService contractAsyncService;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProotherChangeEntity e = (ProotherChangeEntity)((Object)this.changeService.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.changeService.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u53d8\u66f4\u56de\u8c03\u5904\u7406\u5b8c\u6210\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)this.changeService.selectById(billId));
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(prootherChangeEntity.getContractId()));
        if (null != prootherContractEntity && !prootherContractEntity.getPerformanceStatus().equals(ContractPerformanceStateEnum.\u5c65\u7ea6\u4e2d.getStateCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u53d8\u66f4\u5408\u540c\u6240\u5c5e\u7684\u4e3b\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5c65\u7ea6\u4e2d\uff0c\u8be5\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\uff01");
        }
        this.checkContractFile(prootherChangeEntity);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(prootherChangeEntity.getChangeFileId(), prootherChangeEntity.getId(), prootherChangeEntity.getBillCode(), ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode(), "proOtherContractChange");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            prootherChangeEntity.setCommitDate(new Date());
            prootherChangeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            prootherChangeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(prootherChangeEntity.getChangeDraftType())) {
            return this.changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
        }
        if (commitState.booleanValue()) {
            this.changeService.saveOrUpdate((Object)prootherChangeEntity);
        }
        prootherContractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
        this.contractService.saveOrUpdate((Object)prootherContractEntity, false);
        this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherContractEntity)));
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBpmBack(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
        Object resp = null;
        ProotherChangeEntity prootherChangeEntity = (ProotherChangeEntity)((Object)this.changeService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        this.logger.info("\u8fdb\u5165\u53d8\u66f4\u64a4\u56de\uff01");
        this.logger.info("\u53d8\u66f4\u5408\u540c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)prootherChangeEntity)));
        if ((BillStateEnum.COMMITED_STATE.getBillStateCode().equals(prootherChangeEntity.getBillState()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(prootherChangeEntity.getBillState())) && (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().equals(prootherChangeEntity.getChangeDraftType()) || DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().equals(prootherChangeEntity.getChangeDraftType()) && !statusList.contains(prootherChangeEntity.getSignatureStatus()))) {
            return CommonResponse.error((String)"\u5df2\u751f\u6548\u6216\u5df2\u53d1\u8d77\u7b7e\u7ae0\u7684\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u64a4\u56de/\u5f03\u5ba1\uff01");
        }
        prootherChangeEntity.setSignatureStatus(SignatureStatusEnum.\u5f85\u7b7e\u7ae0.getCode());
        prootherChangeEntity.setCommitDate(null);
        prootherChangeEntity.setCommitUserCode(null);
        prootherChangeEntity.setCommitUserName(null);
        this.changeService.saveOrUpdate((Object)prootherChangeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherChangeEntity)));
        ProotherContractEntity prootherContractEntity = (ProotherContractEntity)((Object)this.contractService.selectById(prootherChangeEntity.getContractId()));
        prootherContractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)prootherContractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)prootherContractEntity)));
        return CommonResponse.success((String)"\u6267\u884c\u53d8\u66f4\u5355\u64a4\u56de\u56de\u8c03\u903b\u8f91\u6210\u529f\uff01");
    }

    private void checkContractFile(ProotherChangeEntity prootherChangeEntity) {
        CommonResponse attachResp = this.attachmentApi.queryDetail(prootherChangeEntity.getChangeFileId().toString());
        if (!attachResp.isSuccess() || null == attachResp.getData()) {
            this.logger.info("\u5408\u540c\u5b58\u50a8\u53d8\u66f4\u6587\u4ef6Id-{}\u5728\u6587\u4ef6\u4e2d\u5fc3\u4e0d\u5b58\u5728\uff0c\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u6587\u4ef6\u4fe1\u606f", new Object[]{prootherChangeEntity.getChangeFileId(), prootherChangeEntity.getId(), "contractChangeFile", ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode()});
            CommonResponse attachListResp = this.attachmentApi.queryListBySourceId(prootherChangeEntity.getId(), ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode(), "contractChangeFile", "desc");
            this.logger.info("\u6839\u636e\u53c2\u6570sourceId-{}, sourceType-{}, billType-{} \u67e5\u8be2\u5bf9\u5e94\u53d8\u66f4\u6587\u4ef6\u4fe1\u606f\u7ed3\u679c\uff1a{}", new Object[]{prootherChangeEntity.getId(), "contractChangeFile", ProotherBillTypeEnum.\u5176\u4ed6\u5408\u540c\u53d8\u66f4.getBillTypeCode(), JSONObject.toJSONString((Object)attachListResp)});
            if (attachListResp.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)attachListResp.getData()))) {
                AttachmentVO attachmentVO = (AttachmentVO)((List)attachListResp.getData()).get(0);
                this.logger.info("\u5c06\u5408\u540cid-{}\u5bf9\u5e94\u5408\u540c\u53d8\u66f4\u6587\u4ef6Id-{}\u6539\u4e3a{}", new Object[]{prootherChangeEntity.getId(), prootherChangeEntity.getChangeFileId(), attachmentVO.getId()});
                prootherChangeEntity.setChangeFileId(attachmentVO.getId());
                prootherChangeEntity.setChangeFilePath(attachmentVO.getTruePath());
            } else {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u83b7\u53d6\u5408\u540c\u53d8\u66f4\u6587\u4ef6\u4fe1\u606f\u5931\u8d25, \u8bf7\u68c0\u67e5\u5408\u540c\u53d8\u66f4\u6587\u4ef6\uff01");
            }
        }
    }
}

