/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.util;

import com.ejianc.business.prosub.utils.ITreeNodeB;
import com.ejianc.business.prosub.vo.ChangeDetailVO;
import com.ejianc.business.prosub.vo.ContractDetailVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ParamCtrlUtil {
    public static <T extends ITreeNodeB> void treeToConDetailVOList(List<ContractDetailVO> voList, List<T> treeList) {
        if (CollectionUtils.isEmpty(treeList)) {
            return;
        }
        for (ITreeNodeB treeNode : treeList) {
            ContractDetailVO vo = (ContractDetailVO)treeNode;
            List child = vo.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)child)) {
                ParamCtrlUtil.treeToConDetailVOList(voList, child);
            }
            voList.add(vo);
        }
    }

    public static <T extends ITreeNodeB> void treeToChanDetailVOList(List<ChangeDetailVO> voList, List<T> treeList) {
        if (CollectionUtils.isEmpty(treeList)) {
            return;
        }
        for (ITreeNodeB treeNode : treeList) {
            ChangeDetailVO vo = (ChangeDetailVO)treeNode;
            List child = vo.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)child)) {
                ParamCtrlUtil.treeToChanDetailVOList(voList, child);
            }
            voList.add(vo);
        }
    }

    public static void setAlertData(ParamsCheckVO checkOld, ParamsCheckVO checkNow) {
        if (checkNow == null || checkOld == null) {
            return;
        }
        String warnTypeOld = checkOld.getWarnType();
        int warnTypeOldInt = ParamCtrlUtil.getWarnTypeInt(warnTypeOld, 2);
        String warnTypeNow = checkNow.getWarnType();
        if (StringUtils.isNotBlank((String)warnTypeNow) && !"none".equals(warnTypeNow)) {
            List dataSource;
            int warnTypeNowInt = ParamCtrlUtil.getWarnTypeInt(warnTypeNow, 2);
            if (warnTypeNowInt > warnTypeOldInt) {
                checkOld.setWarnType(warnTypeNow);
            }
            if (CollectionUtils.isNotEmpty((Collection)(dataSource = checkNow.getDataSource()))) {
                checkOld.getDataSource().addAll(dataSource);
            }
        }
    }

    public static int getWarnTypeInt(String warnTypeStr, int defaultTypeInt) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)warnTypeStr)) {
            return 1;
        }
        switch (warnTypeStr) {
            case "none": {
                defaultTypeInt = 1;
                break;
            }
            case "warn": {
                defaultTypeInt = 2;
                break;
            }
            case "alert": {
                defaultTypeInt = 3;
                break;
            }
        }
        return defaultTypeInt;
    }

    public static String getWarnTypeStr(int warnTypeInt, String defaultTypeStr) {
        switch (warnTypeInt) {
            case 1: {
                defaultTypeStr = "none";
                break;
            }
            case 2: {
                defaultTypeStr = "warn";
                break;
            }
            case 3: {
                defaultTypeStr = "alert";
                break;
            }
        }
        return defaultTypeStr;
    }
}

