/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.steelstructure.prosub.prosub.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.settle.vo.SettleVO;
import com.ejianc.business.steelstructure.prosub.prosub.mapper.ContractMapper;
import com.ejianc.business.steelstructure.prosub.prosub.subSalary.vo.SubSalaryVO;
import com.ejianc.business.steelstructure.prosub.settle.service.IProcessSettleService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/prosubWarn/"})
public class ProsubWarnController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PC_URL = "/ejc-prosub-frontend/#/processSettle/prosub?id=";
    private static final String PC_A_URL = "/ejc-prosub-frontend/#/application/card?id=";
    @Autowired
    private IWarnCenterApi warnCenterApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectPoolApi projectSetApi;
    @Autowired
    private IProcessSettleService processSettleService;
    @Autowired
    private ContractMapper contractMapper;

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, Long warnId) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenter(warnList, warnId);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }

    private List<EarlyWarnTransVO> transToWarnVO(List<Map<String, Object>> result, JSONObject defaultWarnInfo) {
        ArrayList<EarlyWarnTransVO> resp = new ArrayList<EarlyWarnTransVO>();
        String tmpContent = null;
        DecimalFormat df = new DecimalFormat("###,##0.00");
        for (Map<String, Object> m : result) {
            EarlyWarnTransVO vo = new EarlyWarnTransVO();
            vo.setBillName((null != defaultWarnInfo.get((Object)"categoryName") ? defaultWarnInfo.get((Object)"categoryName").toString() + " - " : "") + m.get("contractCode").toString());
            vo.setPcTitle("\u65bd\u5de5\u5408\u540c");
            vo.setPcUrl(PC_URL + m.get("contractId").toString());
            vo.setOrgId(Long.valueOf(m.get("orgId").toString()));
            vo.setOrgName(m.get("orgName").toString());
            vo.setSourceId(m.get("contractId").toString());
            vo.setTenantId(Long.valueOf(m.get("tenantId").toString()));
            vo.setWarnLevel(m.get("warnLevel").toString());
            vo.setWarnSetId(defaultWarnInfo.getLong("warnSetId"));
            vo.setEarlywarnName(defaultWarnInfo.getString("earlywarnName"));
            tmpContent = defaultWarnInfo.getString("earlywarnContent");
            vo.setEarlywarnContent(tmpContent.replaceAll("#contractName#", m.get("contractName").toString()).replaceAll("#signDate#", m.get("signDate").toString()));
            resp.add(vo);
        }
        this.logger.info("\u53d1\u9001\u9884\u8b66\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(resp));
        return resp;
    }

    @PostMapping(value={"processSettleWarnExecute"})
    public CommonResponse<String> processSettleWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        List proList = new ArrayList();
        CommonResponse resp = this.projectSetApi.queryProjectPoolList(null, null, null);
        if (resp.isSuccess()) {
            proList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), ProjectPoolSetVO.class);
        } else {
            this.logger.error(resp.getMsg());
        }
        if (CollectionUtils.isEmpty(proList)) {
            return CommonResponse.success();
        }
        Map<Long, List<ProjectPoolSetVO>> projectMap = proList.stream().collect(Collectors.groupingBy(BaseVO::getTenantId));
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            calendar.add(2, -1);
            calendar.set(5, 1);
            String berforeFirstDay = df1.format(calendar.getTime());
            Calendar calendar1 = Calendar.getInstance();
            calendar1.set(5, 1);
            calendar1.add(5, -1);
            String berforeLastDay = df1.format(calendar1.getTime());
            if (!projectMap.containsKey(tenantId)) continue;
            List<ProjectPoolSetVO> projectList = projectMap.get(tenantId);
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("settleDate", new Parameter("between", (Object)(berforeFirstDay + "," + berforeLastDay)));
            List settleEntities = this.processSettleService.queryList(param);
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u4e0a\u6708\u6708\u5ea6\u7ed3\u7b97\u5355\u636e\u6570\u91cf{}\u6761", (Object)settleEntities.size());
            List settleVOs = BeanMapper.mapList((Iterable)settleEntities, SettleVO.class);
            List resultList = projectList.stream().filter(ProjectPoolSetVO2 -> !settleVOs.stream().map(SettleVO::getProjectId).collect(Collectors.toList()).contains(ProjectPoolSetVO2.getId()) && ProjectPoolSetVO2.getProjectDate() != null).collect(Collectors.toList());
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u4e0a\u6708\u672a\u6708\u5ea6\u7ed3\u7b97\u9879\u76ee{}\u4e2a", (Object)resultList.size());
            if (!ListUtil.isNotEmpty(resultList)) continue;
            for (ProjectPoolSetVO pvo : resultList) {
                int i1;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getProjectDepartmentId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel")) && set.getString("parameterValue") != null) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel")) || set.getString("parameterValue") == null) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("\u9879\u76ee-" + pvo.getName() + "-" + pvo.getCode());
                vo.setPcTitle("\u4e13\u4e1a\u5206\u5305\u5408\u540c");
                vo.setPcUrl(PC_URL + pvo.getId());
                vo.setOrgId(pvo.getProjectDepartmentId());
                vo.setSendOrgId(pvo.getProjectDepartmentId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#month#", month + ""));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#month#", month + ""));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getName()).replaceAll("#month#", month + ""));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"applicationWarnExecute"})
    public CommonResponse<String> applicationWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            QueryParam param = new QueryParam();
            param.getParams().put("tenantId", new Parameter("eq", (Object)tenantId));
            ArrayList<Integer> billStatus = new ArrayList<Integer>();
            billStatus.add(1);
            billStatus.add(3);
            param.getParams().put("bill_state", new Parameter("in", billStatus));
            param.getParams().put("useFlag", new Parameter("eq", (Object)0));
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    @PostMapping(value={"salaryWarnExecute"})
    public CommonResponse<String> salaryWarnExecute(@RequestBody JSONArray jsonParam) {
        this.logger.info("\u63a5\u6536\u5230 Task \u53c2\u6570\uff1a{}", (Object)jsonParam);
        ArrayList<EarlyWarnTransVO> warnList = new ArrayList<EarlyWarnTransVO>();
        String warnCode = null;
        for (int i = 0; i < jsonParam.size(); ++i) {
            JSONObject o = jsonParam.getJSONObject(i);
            Long tenantId = o.getLong("tenantId");
            warnCode = o.getString("warnCode");
            JSONArray orgSettings = o.getJSONArray("settings");
            List<SubSalaryVO> subSalaryVOS = this.contractMapper.querySalaryWarn();
            this.logger.info("\u672c\u6b21\u5171\u83b7\u53d6\u672a\u5236\u4f5c\u5de5\u8d44\u5355\u9879\u76ee{}\u4e2a", (Object)subSalaryVOS.size());
            if (!ListUtil.isNotEmpty(subSalaryVOS)) continue;
            for (SubSalaryVO pvo : subSalaryVOS) {
                int i1;
                if (pvo.getId() == null) continue;
                JSONObject orgSet = null;
                JSONObject defaultSet = null;
                Long orgId = pvo.getOrgId();
                OrgVO orgVO = (OrgVO)this.iOrgApi.getOneById(orgId).getData();
                if (orgVO == null) continue;
                String innerCode = orgVO.getInnerCode();
                String[] parentIds = innerCode.split("\\|");
                this.logger.info("parentIds______" + innerCode);
                for (i1 = parentIds.length - 1; i1 >= 0; --i1) {
                    Long pOrgId = Long.parseLong(parentIds[i1]);
                    for (int j = 0; j < orgSettings.size(); ++j) {
                        JSONObject set = orgSettings.getJSONObject(j);
                        if (!pOrgId.equals(set.getLong("orgId"))) continue;
                        orgSet = set;
                        break;
                    }
                    if (orgSet != null) break;
                }
                for (i1 = 0; i1 < orgSettings.size(); ++i1) {
                    JSONObject set = orgSettings.getJSONObject(i1);
                    if (!set.getBoolean("default").booleanValue()) continue;
                    defaultSet = set;
                    break;
                }
                if (orgSet == null) {
                    orgSet = defaultSet;
                }
                if (orgSet == null || !ListUtil.isNotEmpty((List)orgSet.getJSONArray("warningSetings"))) continue;
                JSONArray warningSettings = orgSet.getJSONArray("warningSetings");
                boolean high = false;
                boolean meddle = false;
                boolean low = false;
                JSONObject useSetHigh = null;
                JSONObject useSetMeddle = null;
                JSONObject useSetLow = null;
                for (int i12 = 0; i12 < warningSettings.size(); ++i12) {
                    JSONObject set = warningSettings.getJSONObject(i12);
                    if ("\u9ad8".equals(set.getString("warningLevel"))) {
                        high = true;
                        useSetHigh = set;
                    }
                    if ("\u4e2d".equals(set.getString("warningLevel"))) {
                        meddle = true;
                        useSetMeddle = set;
                    }
                    if (!"\u4f4e".equals(set.getString("warningLevel"))) continue;
                    low = true;
                    useSetLow = set;
                }
                if (!high && !meddle && !low) continue;
                EarlyWarnTransVO vo = new EarlyWarnTransVO();
                vo.setBillName("\u9879\u76ee-" + pvo.getProjectName());
                vo.setPcTitle("\u5de5\u8d44\u5355");
                vo.setPcUrl(null);
                vo.setOrgId(pvo.getOrgId());
                vo.setSendOrgId(pvo.getOrgId() + "");
                vo.setOrgName(orgVO.getName());
                vo.setSourceId(pvo.getId().toString());
                vo.setTenantId(tenantId);
                vo.setWarnSetId(orgSet.getLong("warnId"));
                vo.setEarlywarnName(orgSet.getString("warnName"));
                vo.setWarnType(orgSet.getString("warnType"));
                String tmpContent = orgSet.getString("warningContentTemplate");
                if (high) {
                    vo.setWarnLevel("\u9ad8");
                    vo.setWarnSetParamId(useSetHigh.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getProjectName()).replaceAll("#num#", pvo.getNum() + ""));
                } else if (meddle) {
                    vo.setWarnLevel("\u4e2d");
                    vo.setWarnSetParamId(useSetMeddle.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getProjectName()).replaceAll("#num#", pvo.getNum() + ""));
                } else {
                    vo.setWarnLevel("\u4f4e");
                    vo.setWarnSetParamId(useSetLow.getLong("id"));
                    vo.setEarlywarnContent(tmpContent.replaceAll("#projectName#", pvo.getProjectName()).replaceAll("#num#", pvo.getNum() + ""));
                }
                warnList.add(vo);
            }
        }
        return this.sendWarnToTask(warnList, warnCode);
    }

    private CommonResponse<String> sendWarnToTask(List<EarlyWarnTransVO> warnList, String warnCode) {
        CommonResponse warnResp = this.warnCenterApi.sendToWarnCenterByCode(warnList, warnCode);
        if (!warnResp.isSuccess()) {
            this.logger.error("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25\uff0c{}", (Object)warnResp.getMsg());
            return CommonResponse.error((String)("\u56de\u8c03\u9884\u8b66\u4efb\u52a1\u670d\u52a1\u5931\u8d25" + warnResp.getMsg()));
        }
        return CommonResponse.success((String)"\u4efb\u52a1\u63a5\u53d7\u5904\u7406\u6210\u529f\uff01");
    }
}

