package com.ejianc.business.store.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 仓库流水表
 *
 * @author generator
 *
 */
@ApiModel("仓库流水表")
public class FlowVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("流水单号")
    private String billCode;
    @ApiModelProperty("流水日期")
    private Date billDate;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("仓库")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("生效时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectiveDate;
    @ApiModelProperty("生效状态0自由1已生效")
    private Integer effectiveState;
    @ApiModelProperty("针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成")
    private Integer outUseFlag;
    @ApiModelProperty("业务经办人ID")
    private Long employeeId;
    @ApiModelProperty("业务经办人名称")
    private String employeeName;
    @ApiModelProperty("出入库类型:收料入库等")
    private Integer inOutType;
    @ApiModelProperty("出入库类型名称")
    private String inOutTypeName;
    @ApiModelProperty("出入库属性1入库2出库")
    private Integer inOutFlag;
    @ApiModelProperty("是否甲供1是0否")
    private Integer partyaFlag;
    @ApiModelProperty("是否退货1是0否")
    private Integer returnGoodsFlag;
    @ApiModelProperty("是否退库1是0否")
    private Integer returnStoreFlag;
    @ApiModelProperty("是否对账1是0否")
    private Integer accountFlag;
    @ApiModelProperty("对账主表id")
    private Long accountId;
    @ApiModelProperty("对账子表id")
    private Long accountDetailId;
    @ApiModelProperty("对账时间")
    private Date accountDate;
    @ApiModelProperty("对账单号")
    private String accountCode;
    @ApiModelProperty("是否结算1是0否")
    private Integer settleFlag;
    @ApiModelProperty("结算主表id")
    private Long settleId;
    @ApiModelProperty("结算子表id")
    private Long settleDetailId;
    @ApiModelProperty("结算时间")
    private Date settleDate;
    @ApiModelProperty("结算单号")
    private String settleCode;
    @ApiModelProperty("仓库属性")
    private String storeType;
    @ApiModelProperty("仓库属性名称")
    private String storeTypeName;
    @ApiModelProperty("材料类型编码")
    private String materialType;
    @ApiModelProperty("材料类型名称")
    private String materialTypeName;
    @ApiModelProperty("供应商id")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("采购合同id")
    private Long purchaseContractId;
    @ApiModelProperty("采购合同名称")
    private String purchaseContractName;
    @ApiModelProperty("物资分类id")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资内码")
    private String materialInnerCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("单价(无税)")
    private BigDecimal price;
    @ApiModelProperty("单价")
    private BigDecimal taxPrice;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("金额含税")
    private BigDecimal taxMny;
    @ApiModelProperty("金额(无税)")
    private BigDecimal mny;
    @ApiModelProperty("税额")
    private BigDecimal tax;
    @ApiModelProperty("外加剂id,逗号分隔")
    private String admixtureId;
    @ApiModelProperty("外加剂名称,逗号分隔")
    private String admixtureName;
    @ApiModelProperty("外加剂综合单价")
    private BigDecimal admixturePrice;
    @ApiModelProperty("领料单位id")
    private Long pickUnitId;
    @ApiModelProperty("领料单位")
    private String pickUnitName;
    @ApiModelProperty("领料合同id")
    private Long pickContractId;
    @ApiModelProperty("领料合同")
    private String pickContractName;
    @ApiModelProperty("累计出库数量")
    private BigDecimal outNum;
    @ApiModelProperty("出库占用数量")
    private BigDecimal outLockNum;
    @ApiModelProperty("入库余额(无税)")
    private BigDecimal surplusMny;
    @ApiModelProperty("入库余额")
    private BigDecimal surplusTaxMny;
    @ApiModelProperty("入库余量")
    private BigDecimal surplusNum;
    @ApiModelProperty("库存数量")
    private BigDecimal stockNum;
    @ApiModelProperty("来源单据类型名称")
    private String sourceBillTypeName;
    @ApiModelProperty("来源单据类型编码")
    private String sourceBillTypeCode;
    @ApiModelProperty("来源单据id")
    private Long sourceId;
    @ApiModelProperty("来源单据明细id")
    private Long sourceDetailId;
    @ApiModelProperty("来源单据编码")
    private String sourceBillCode;
    @ApiModelProperty("来源单据日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date sourceBillDate;
    @ApiModelProperty("来源单据备注")
    private String sourceBillRemark;
    @ApiModelProperty("来源单据明细备注")
    private String sourceBillDetailRemark;
    @ApiModelProperty("来源单据用途")
    private String sourceBillPurpose;
    @ApiModelProperty("成本科目id")
    private Long subjectId;
    @ApiModelProperty("成本科目名称")
    private String subjectName;
    @ApiModelProperty("自定义字段1")
    private String cusDef1;
    @ApiModelProperty("是否推送低值易耗品仓库 1是 其他皆为否")
    private Integer consumableFlag;
    @ApiModelProperty("自定义字段3")
    private String cusDef3;
    @ApiModelProperty("自定义字段4")
    private String cusDef4;
    @ApiModelProperty("自定义字段5")
    private String cusDef5;
    @ApiModelProperty("自定义字段6")
    private String cusDef6;
    @ApiModelProperty("自定义字段7")
    private String cusDef7;
    @ApiModelProperty("自定义字段8")
    private String cusDef8;
    @ApiModelProperty("自定义字段9")
    private String cusDef9;
    @ApiModelProperty("自定义字段10")
    private String cusDef10;

    @ApiModelProperty("直入直出流水id")
    private Long straightOutFlowId;
    @ApiModelProperty("出入关系id,退库使用,关联发生退库的出库关系")
    private Long inOutId;

    @ApiModelProperty("暂估单价(无税)")
    private BigDecimal estimatePrice;
    @ApiModelProperty("暂估单价")
    private BigDecimal estimateTaxPrice;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    /**
     * 周转材当前净值=入库金额-摊销金额-出库净值
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("当前净值(无税)")
    private BigDecimal netMny;
    @ApiModelProperty("当前净值")
    private BigDecimal netTaxMny;

    /**
     * 周转材摊销金额（累计值）
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("摊销金额(无税)")
    private BigDecimal shareMny;
    @ApiModelProperty("摊销金额")
    private BigDecimal shareTaxMny;

    /**
     * 周转材出库净值（累计值）=出库数量 * (（入库金额-摊销金额-出库净值）/库存数量)，每次出库后重算
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("出库净值(无税)")
    private BigDecimal outNetMny;
    @ApiModelProperty("出库净值")
    private BigDecimal outNetTaxMny;

    /**
     * 周转材采购入库原价=入库单价，调拨入库=调出采购均价（调出单计算、调入单传入）
     * @Modify by wxh 20220301
     */
    @ApiModelProperty("原值单价(无税)")
    private BigDecimal purchasePrice;
    @ApiModelProperty("原值单价")
    private BigDecimal purchaseTaxPrice;

    @ApiModelProperty("是否周转材 1是0否")
    private Integer turnFlag;

    @ApiModelProperty("上次摊销日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date lastShareDate;

    @ApiModelProperty("来源 0-自制,1-订单")
    private Integer sourceType;

    @ApiModelProperty("合同单价无税")
    private BigDecimal contractPrice;

    @ApiModelProperty("合同单价含税")
    private BigDecimal contractTaxPrice;


    @ApiModelProperty("结算单价(无税),不存库")
    private BigDecimal settlePrice;
    @ApiModelProperty("结算单价,不存库")
    private BigDecimal settleTaxPrice;

    @ApiModelProperty("结算金额(无税),不存库")
    private BigDecimal settleMny;
    @ApiModelProperty("结算金额,不存库")
    private BigDecimal settleTaxMny;
    @ApiModelProperty("结算税额,不存库")
    private BigDecimal settleTax;

    @ApiModelProperty("成本金额(无税),不存库")
    private BigDecimal costMny;
    @ApiModelProperty("成本金额,不存库")
    private BigDecimal costTaxMny;
    @ApiModelProperty("成本税额,不存库")
    private BigDecimal costTax;


    @ApiModelProperty("调差金额(无税),不存库")
    private BigDecimal diffMny;
    @ApiModelProperty("调差金额,不存库")
    private BigDecimal diffTaxMny;
    @ApiModelProperty("调差税额,不存库")
    private BigDecimal diffTax;

    @ApiModelProperty("是否有合同,不存库")
    private String contractFlagStr;
    @ApiModelProperty("来源,不存库")
    private String sourceTypeStr;
    //报表使用-材料收发存汇总
    @ApiModelProperty("出库金额")
    private BigDecimal outTaxMny;
    @ApiModelProperty("出库金额")
    private BigDecimal outMny;

    @ApiModelProperty("领料方式：1-内部领料，2-分包领料")
    private Integer pickType;
    @ApiModelProperty("领料方式名称")
    private String pickTypeName;
    @ApiModelProperty("消耗材使用用途主键")
    private Long materialUseId;
    @ApiModelProperty("消耗材使用用途名称")
    private String materialUseName;

    private String licensePlate; // 车牌号

    private String subEmployeeName; // 分包负责人

    private String useFor; // 使用部位

    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }

    public String getSubEmployeeName() {
        return subEmployeeName;
    }

    public void setSubEmployeeName(String subEmployeeName) {
        this.subEmployeeName = subEmployeeName;
    }

    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }

    public Integer getPickType() {
        return pickType;
    }

    public void setPickType(Integer pickType) {
        this.pickType = pickType;
    }

    public String getPickTypeName() {
        return pickTypeName;
    }

    public void setPickTypeName(String pickTypeName) {
        this.pickTypeName = pickTypeName;
    }

    public BigDecimal getSettleTax() {
        return settleTax;
    }

    public void setSettleTax(BigDecimal settleTax) {
        this.settleTax = settleTax;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostTax() {
        return costTax;
    }

    public void setCostTax(BigDecimal costTax) {
        this.costTax = costTax;
    }

    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }

    public BigDecimal getDiffTaxMny() {
        return diffTaxMny;
    }

    public void setDiffTaxMny(BigDecimal diffTaxMny) {
        this.diffTaxMny = diffTaxMny;
    }

    public BigDecimal getDiffTax() {
        return diffTax;
    }

    public void setDiffTax(BigDecimal diffTax) {
        this.diffTax = diffTax;
    }

    public String getContractFlagStr() {
        return contractFlagStr;
    }

    public void setContractFlagStr(String contractFlagStr) {
        this.contractFlagStr = contractFlagStr;
    }

    public String getSourceTypeStr() {
        return sourceTypeStr;
    }

    public void setSourceTypeStr(String sourceTypeStr) {
        this.sourceTypeStr = sourceTypeStr;
    }

    public BigDecimal getSettlePrice() {
        return settlePrice;
    }

    public void setSettlePrice(BigDecimal settlePrice) {
        this.settlePrice = settlePrice;
    }

    public BigDecimal getSettleTaxPrice() {
        return settleTaxPrice;
    }

    public void setSettleTaxPrice(BigDecimal settleTaxPrice) {
        this.settleTaxPrice = settleTaxPrice;
    }

    public Date getLastShareDate() {
        return lastShareDate;
    }

    public void setLastShareDate(Date lastShareDate) {
        this.lastShareDate = lastShareDate;
    }

    public BigDecimal getStockNum() {
        return stockNum;
    }

    public void setStockNum(BigDecimal stockNum) {
        this.stockNum = stockNum;
    }

    public Integer getTurnFlag() {
        return turnFlag;
    }

    public void setTurnFlag(Integer turnFlag) {
        this.turnFlag = turnFlag;
    }

    public BigDecimal getNetMny() {
        return netMny;
    }

    public void setNetMny(BigDecimal netMny) {
        this.netMny = netMny;
    }

    public BigDecimal getNetTaxMny() {
        return netTaxMny;
    }

    public void setNetTaxMny(BigDecimal netTaxMny) {
        this.netTaxMny = netTaxMny;
    }

    public BigDecimal getShareMny() {
        return shareMny;
    }

    public void setShareMny(BigDecimal shareMny) {
        this.shareMny = shareMny;
    }

    public BigDecimal getShareTaxMny() {
        return shareTaxMny;
    }

    public void setShareTaxMny(BigDecimal shareTaxMny) {
        this.shareTaxMny = shareTaxMny;
    }

    public BigDecimal getOutNetMny() {
        return outNetMny;
    }

    public void setOutNetMny(BigDecimal outNetMny) {
        this.outNetMny = outNetMny;
    }

    public BigDecimal getOutNetTaxMny() {
        return outNetTaxMny;
    }

    public void setOutNetTaxMny(BigDecimal outNetTaxMny) {
        this.outNetTaxMny = outNetTaxMny;
    }

    public BigDecimal getPurchasePrice() {
        return purchasePrice;
    }

    public void setPurchasePrice(BigDecimal purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public BigDecimal getPurchaseTaxPrice() {
        return purchaseTaxPrice;
    }

    public void setPurchaseTaxPrice(BigDecimal purchaseTaxPrice) {
        this.purchaseTaxPrice = purchaseTaxPrice;
    }


    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }


    public BigDecimal getEstimatePrice() {
        return estimatePrice;
    }

    public void setEstimatePrice(BigDecimal estimatePrice) {
        this.estimatePrice = estimatePrice;
    }

    public BigDecimal getEstimateTaxPrice() {
        return estimateTaxPrice;
    }

    public void setEstimateTaxPrice(BigDecimal estimateTaxPrice) {
        this.estimateTaxPrice = estimateTaxPrice;
    }

    /**
     * 流水单号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 流水单号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 流水日期
     */
    public Date getBillDate() {
        return billDate;
    }

    /**
     * 流水日期
     */
    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    /**
     * 项目ID
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目ID
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 所属组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 所属组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 所属组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 所属组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 所属组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 所属组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 仓库
     */
    public Long getStoreId() {
        return storeId;
    }

    /**
     * 仓库
     */
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    /**
     * 仓库名称
     */
    public String getStoreName() {
        return storeName;
    }

    /**
     * 仓库名称
     */
    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    /**
     * 生效时间
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /**
     * 生效时间
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    /**
     * 生效状态0自由1已生效
     */
    public Integer getEffectiveState() {
        return effectiveState;
    }

    /**
     * 生效状态0自由1已生效
     */
    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }
    /**
     * 针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成
     */
    public Integer getOutUseFlag() {
        return outUseFlag;
    }

    /**
     * 针对入库出库使用状态0无需出库1可以出库2出库占用中3出库完成
     */
    public void setOutUseFlag(Integer outUseFlag) {
        this.outUseFlag = outUseFlag;
    }
    /**
     * 业务经办人ID
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 业务经办人ID
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 业务经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 业务经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 出入库类型:收料入库等
     */
    public Integer getInOutType() {
        return inOutType;
    }

    /**
     * 出入库类型:收料入库等
     */
    public void setInOutType(Integer inOutType) {
        this.inOutType = inOutType;
    }
    /**
     * 出入库类型名称
     */
    public String getInOutTypeName() {
        return inOutTypeName;
    }

    /**
     * 出入库类型名称
     */
    public void setInOutTypeName(String inOutTypeName) {
        this.inOutTypeName = inOutTypeName;
    }
    /**
     * 出入库属性1入库2出库
     */
    public Integer getInOutFlag() {
        return inOutFlag;
    }

    /**
     * 出入库属性1入库2出库
     */
    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }
    /**
     * 是否甲供1是0否
     */
    public Integer getPartyaFlag() {
        return partyaFlag;
    }

    /**
     * 是否甲供1是0否
     */
    public void setPartyaFlag(Integer partyaFlag) {
        this.partyaFlag = partyaFlag;
    }
    /**
     * 是否退货1是0否
     */
    public Integer getReturnGoodsFlag() {
        return returnGoodsFlag;
    }

    /**
     * 是否退货1是0否
     */
    public void setReturnGoodsFlag(Integer returnGoodsFlag) {
        this.returnGoodsFlag = returnGoodsFlag;
    }
    /**
     * 是否退库1是0否
     */
    public Integer getReturnStoreFlag() {
        return returnStoreFlag;
    }

    /**
     * 是否退库1是0否
     */
    public void setReturnStoreFlag(Integer returnStoreFlag) {
        this.returnStoreFlag = returnStoreFlag;
    }
    /**
     * 是否对账1是0否
     */
    public Integer getAccountFlag() {
        return accountFlag;
    }

    /**
     * 是否对账1是0否
     */
    public void setAccountFlag(Integer accountFlag) {
        this.accountFlag = accountFlag;
    }
    /**
     * 对账主表id
     */
    public Long getAccountId() {
        return accountId;
    }

    /**
     * 对账主表id
     */
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    /**
     * 对账子表id
     */
    public Long getAccountDetailId() {
        return accountDetailId;
    }

    /**
     * 对账子表id
     */
    public void setAccountDetailId(Long accountDetailId) {
        this.accountDetailId = accountDetailId;
    }
    /**
     * 对账时间
     */
    public Date getAccountDate() {
        return accountDate;
    }

    /**
     * 对账时间
     */
    public void setAccountDate(Date accountDate) {
        this.accountDate = accountDate;
    }
    /**
     * 对账单号
     */
    public String getAccountCode() {
        return accountCode;
    }

    /**
     * 对账单号
     */
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }
    /**
     * 是否结算1是0否
     */
    public Integer getSettleFlag() {
        return settleFlag;
    }

    /**
     * 是否结算1是0否
     */
    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }
    /**
     * 结算主表id
     */
    public Long getSettleId() {
        return settleId;
    }

    /**
     * 结算主表id
     */
    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    /**
     * 结算子表id
     */
    public Long getSettleDetailId() {
        return settleDetailId;
    }

    /**
     * 结算子表id
     */
    public void setSettleDetailId(Long settleDetailId) {
        this.settleDetailId = settleDetailId;
    }
    /**
     * 结算时间
     */
    public Date getSettleDate() {
        return settleDate;
    }

    /**
     * 结算时间
     */
    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    /**
     * 结算单号
     */
    public String getSettleCode() {
        return settleCode;
    }

    /**
     * 结算单号
     */
    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }
    /**
     * 仓库属性
     */
    public String getStoreType() {
        return storeType;
    }
    /**
     * 仓库属性
     */
    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }
    /**
     * 仓库属性名称
     */
    public String getStoreTypeName() {
        return storeTypeName;
    }
    /**
     * 仓库属性名称
     */
    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    /**
     * 材料类型编码
     */
    public String getMaterialType() {
        return materialType;
    }

    /**
     * 材料类型编码
     */
    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }
    /**
     * 材料类型名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 材料类型名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 采购合同id
     */
    public Long getPurchaseContractId() {
        return purchaseContractId;
    }

    /**
     * 采购合同id
     */
    public void setPurchaseContractId(Long purchaseContractId) {
        this.purchaseContractId = purchaseContractId;
    }
    /**
     * 采购合同名称
     */
    public String getPurchaseContractName() {
        return purchaseContractName;
    }

    /**
     * 采购合同名称
     */
    public void setPurchaseContractName(String purchaseContractName) {
        this.purchaseContractName = purchaseContractName;
    }
    /**
     * 物资分类id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类编码
     */
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    /**
     * 物资分类编码
     */
    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资id
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资id
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 物资内码
     */
    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    /**
     * 物资内码
     */
    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getMaterialSpec() {
        return materialSpec;
    }

    /**
     * 规格型号
     */
    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    /**
     * 计量单位id
     */
    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    /**
     * 计量单位id
     */
    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }
    /**
     * 计量单位
     */
    public String getMaterialUnitName() {
        return materialUnitName;
    }

    /**
     * 计量单位
     */
    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }
    /**
     * 单价(无税)
     */
    public BigDecimal getPrice() {
        return price;
    }

    /**
     * 单价(无税)
     */
    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    /**
     * 单价
     */
    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    /**
     * 单价
     */
    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }
    /**
     * 数量
     */
    public BigDecimal getNum() {
        return num;
    }

    /**
     * 数量
     */
    public void setNum(BigDecimal num) {
        this.num = num;
    }
    /**
     * 金额含税
     */
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    /**
     * 金额含税
     */
    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    /**
     * 金额(无税)
     */
    public BigDecimal getMny() {
        return mny;
    }

    /**
     * 金额(无税)
     */
    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    /**
     * 税额
     */
    public BigDecimal getTax() {
        return tax;
    }

    /**
     * 税额
     */
    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    /**
     * 外加剂id,逗号分隔
     */
    public String getAdmixtureId() {
        return admixtureId;
    }

    /**
     * 外加剂id,逗号分隔
     */
    public void setAdmixtureId(String admixtureId) {
        this.admixtureId = admixtureId;
    }
    /**
     * 外加剂名称,逗号分隔
     */
    public String getAdmixtureName() {
        return admixtureName;
    }

    /**
     * 外加剂名称,逗号分隔
     */
    public void setAdmixtureName(String admixtureName) {
        this.admixtureName = admixtureName;
    }
    /**
     * 外加剂综合单价
     */
    public BigDecimal getAdmixturePrice() {
        return admixturePrice;
    }

    /**
     * 外加剂综合单价
     */
    public void setAdmixturePrice(BigDecimal admixturePrice) {
        this.admixturePrice = admixturePrice;
    }
    /**
     * 领料单位id
     */
    public Long getPickUnitId() {
        return pickUnitId;
    }

    /**
     * 领料单位id
     */
    public void setPickUnitId(Long pickUnitId) {
        this.pickUnitId = pickUnitId;
    }
    /**
     * 领料单位
     */
    public String getPickUnitName() {
        return pickUnitName;
    }

    /**
     * 领料单位
     */
    public void setPickUnitName(String pickUnitName) {
        this.pickUnitName = pickUnitName;
    }
    /**
     * 领料合同id
     */
    public Long getPickContractId() {
        return pickContractId;
    }

    /**
     * 领料合同id
     */
    public void setPickContractId(Long pickContractId) {
        this.pickContractId = pickContractId;
    }
    /**
     * 领料合同
     */
    public String getPickContractName() {
        return pickContractName;
    }

    /**
     * 领料合同
     */
    public void setPickContractName(String pickContractName) {
        this.pickContractName = pickContractName;
    }
    /**
     * 累计出库数量
     */
    public BigDecimal getOutNum() {
        return outNum;
    }

    /**
     * 累计出库数量
     */
    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }
    /**
     * 出库占用数量
     */
    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    /**
     * 出库占用数量
     */
    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }
    /**
     * 入库余额(无税)
     */
    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    /**
     * 入库余额(无税)
     */
    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }
    /**
     * 入库余额
     */
    public BigDecimal getSurplusTaxMny() {
        return surplusTaxMny;
    }

    /**
     * 入库余额
     */
    public void setSurplusTaxMny(BigDecimal surplusTaxMny) {
        this.surplusTaxMny = surplusTaxMny;
    }
    /**
     * 入库余量
     */
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    /**
     * 入库余量
     */
    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public Long getStraightOutFlowId() {
        return straightOutFlowId;
    }

    public void setStraightOutFlowId(Long straightOutFlowId) {
        this.straightOutFlowId = straightOutFlowId;
    }

    public Long getInOutId() {
        return inOutId;
    }

    public void setInOutId(Long inOutId) {
        this.inOutId = inOutId;
    }
    /**
     * 来源单据类型名称
     */
    public String getSourceBillTypeName() {
        return sourceBillTypeName;
    }
    /**
     * 来源单据类型名称
     */
    public void setSourceBillTypeName(String sourceBillTypeName) {
        this.sourceBillTypeName = sourceBillTypeName;
    }

    /**
     * 来源单据类型编码
     */
    public String getSourceBillTypeCode() {
        return sourceBillTypeCode;
    }

    /**
     * 来源单据类型编码
     */
    public void setSourceBillTypeCode(String sourceBillTypeCode) {
        this.sourceBillTypeCode = sourceBillTypeCode;
    }
    /**
     * 来源单据id
     */
    public Long getSourceId() {
        return sourceId;
    }

    /**
     * 来源单据id
     */
    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    /**
     * 来源单据明细id
     */
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    /**
     * 来源单据明细id
     */
    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    /**
     * 来源单据编码
     */
    public String getSourceBillCode() {
        return sourceBillCode;
    }

    /**
     * 来源单据编码
     */
    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }
    /**
     * 来源单据日期
     */
    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    /**
     * 来源单据日期
     */
    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }
    /**
     * 来源单据备注
     */
    public String getSourceBillRemark() {
        return sourceBillRemark;
    }

    /**
     * 来源单据备注
     */
    public void setSourceBillRemark(String sourceBillRemark) {
        this.sourceBillRemark = sourceBillRemark;
    }
    /**
     * 来源单据明细备注
     */
    public String getSourceBillDetailRemark() {
        return sourceBillDetailRemark;
    }

    /**
     * 来源单据明细备注
     */
    public void setSourceBillDetailRemark(String sourceBillDetailRemark) {
        this.sourceBillDetailRemark = sourceBillDetailRemark;
    }
    /**
     * 来源单据用途
     */
    public String getSourceBillPurpose() {
        return sourceBillPurpose;
    }

    /**
     * 来源单据用途
     */
    public void setSourceBillPurpose(String sourceBillPurpose) {
        this.sourceBillPurpose = sourceBillPurpose;
    }
    /**
     * 成本科目id
     */
    public Long getSubjectId() {
        return subjectId;
    }

    /**
     * 成本科目id
     */
    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }
    /**
     * 成本科目名称
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 成本科目名称
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public BigDecimal getContractPrice() {
        return contractPrice;
    }

    public void setContractPrice(BigDecimal contractPrice) {
        this.contractPrice = contractPrice;
    }

    public BigDecimal getContractTaxPrice() {
        return contractTaxPrice;
    }

    public void setContractTaxPrice(BigDecimal contractTaxPrice) {
        this.contractTaxPrice = contractTaxPrice;
    }

    /**
     * 自定义字段1
     */
    public String getCusDef1() {
        return cusDef1;
    }

    /**
     * 自定义字段1
     */
    public void setCusDef1(String cusDef1) {
        this.cusDef1 = cusDef1;
    }
    /**
     * 自定义字段2
     */
    public Integer getConsumableFlag() {
        return consumableFlag;
    }

    /**
     * 自定义字段2
     */
    public void setConsumableFlag(Integer consumableFlag) {
        this.consumableFlag = consumableFlag;
    }
    /**
     * 自定义字段3
     */
    public String getCusDef3() {
        return cusDef3;
    }

    /**
     * 自定义字段3
     */
    public void setCusDef3(String cusDef3) {
        this.cusDef3 = cusDef3;
    }
    /**
     * 自定义字段4
     */
    public String getCusDef4() {
        return cusDef4;
    }

    /**
     * 自定义字段4
     */
    public void setCusDef4(String cusDef4) {
        this.cusDef4 = cusDef4;
    }
    /**
     * 自定义字段5
     */
    public String getCusDef5() {
        return cusDef5;
    }

    /**
     * 自定义字段5
     */
    public void setCusDef5(String cusDef5) {
        this.cusDef5 = cusDef5;
    }
    /**
     * 自定义字段6
     */
    public String getCusDef6() {
        return cusDef6;
    }

    /**
     * 自定义字段6
     */
    public void setCusDef6(String cusDef6) {
        this.cusDef6 = cusDef6;
    }
    /**
     * 自定义字段7
     */
    public String getCusDef7() {
        return cusDef7;
    }

    /**
     * 自定义字段7
     */
    public void setCusDef7(String cusDef7) {
        this.cusDef7 = cusDef7;
    }
    /**
     * 自定义字段8
     */
    public String getCusDef8() {
        return cusDef8;
    }

    /**
     * 自定义字段8
     */
    public void setCusDef8(String cusDef8) {
        this.cusDef8 = cusDef8;
    }
    /**
     * 自定义字段9
     */
    public String getCusDef9() {
        return cusDef9;
    }

    /**
     * 自定义字段9
     */
    public void setCusDef9(String cusDef9) {
        this.cusDef9 = cusDef9;
    }
    /**
     * 自定义字段10
     */
    public String getCusDef10() {
        return cusDef10;
    }

    /**
     * 自定义字段10
     */
    public void setCusDef10(String cusDef10) {
        this.cusDef10 = cusDef10;
    }
    /**
     * 出库含税金额
     */
    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }
    /**
     * 出库含税金额
     */
    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }
    /**
     * 出库无税金额
     */
    public BigDecimal getOutMny() {
        return outMny;
    }
    /**
     * 出库无税金额
     */
    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public Long getMaterialUseId() {
        return materialUseId;
    }

    public void setMaterialUseId(Long materialUseId) {
        this.materialUseId = materialUseId;
    }

    public String getMaterialUseName() {
        return materialUseName;
    }

    public void setMaterialUseName(String materialUseName) {
        this.materialUseName = materialUseName;
    }
}
