package com.ejianc.business.store.vo;

import com.ejianc.business.tools.refer.annotation.ReferJsonField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 盘活闲置流水表
 *
 * @author generator
 *
 */
@ApiModel("盘活闲置流水表")
public class IdleFlowVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("流水单号")
    private String billCode;
    @ApiModelProperty("流水日期")
    private Date billDate;
    @ApiModelProperty("项目ID")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("所属组织")
    private Long parentOrgId;
    @ApiModelProperty("所属组织编码")
    private String parentOrgCode;
    @ApiModelProperty("所属组织名称")
    private String parentOrgName;
    @ApiModelProperty("所属组织")
    private Long orgId;
    @ApiModelProperty("所属组织名称")
    private String orgName;
    @ApiModelProperty("仓库")
    private Long storeId;
    @ApiModelProperty("仓库名称")
    private String storeName;
    @ApiModelProperty("仓库属性")
    private String storeType;
    @ApiModelProperty("仓库属性名称")
    private String storeTypeName;
    @ApiModelProperty("物资分类id")
    @ReferJsonField(referCode = "MaterialCategory001",referFields = "code",resultFields = "materialCategoryCode")
    private Long materialCategoryId;
    @ApiModelProperty("物资分类编码")
    private String materialCategoryCode;
    @ApiModelProperty("物资分类名称")
    private String materialCategoryName;
    @ApiModelProperty("物资id")
    private Long materialId;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("物资内码")
    private String materialInnerCode;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("规格型号")
    private String materialSpec;
    @ApiModelProperty("计量单位id")
    private Long materialUnitId;
    @ApiModelProperty("计量单位")
    private String materialUnitName;
    @ApiModelProperty("来源单据类型名称")
    private String sourceBillTypeName;
    @ApiModelProperty("来源单据类型编码")
    private String sourceBillTypeCode;
    @ApiModelProperty("来源单据id")
    private Long sourceId;
    @ApiModelProperty("来源单据明细id")
    private Long sourceDetailId;
    @ApiModelProperty("来源单据编码")
    private String sourceBillCode;
    @ApiModelProperty("来源单据日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date sourceBillDate;
    @ApiModelProperty("来源单据备注")
    private String sourceBillRemark;
    @ApiModelProperty("来源单据明细备注")
    private String sourceBillDetailRemark;
    @ApiModelProperty("来源单据用途")
    private String sourceBillPurpose;
    @ApiModelProperty("数量")
    private BigDecimal num;
    @ApiModelProperty("品牌主键")
    private Long brandId;
    @ApiModelProperty("品牌名称")
    private String brandName;
    @ApiModelProperty("产品代码")
    private String productCode;

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getStoreType() {
        return storeType;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public String getStoreTypeName() {
        return storeTypeName;
    }

    public void setStoreTypeName(String storeTypeName) {
        this.storeTypeName = storeTypeName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }

    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }

    public String getSourceBillTypeName() {
        return sourceBillTypeName;
    }

    public void setSourceBillTypeName(String sourceBillTypeName) {
        this.sourceBillTypeName = sourceBillTypeName;
    }

    public String getSourceBillTypeCode() {
        return sourceBillTypeCode;
    }

    public void setSourceBillTypeCode(String sourceBillTypeCode) {
        this.sourceBillTypeCode = sourceBillTypeCode;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }

    public String getSourceBillCode() {
        return sourceBillCode;
    }

    public void setSourceBillCode(String sourceBillCode) {
        this.sourceBillCode = sourceBillCode;
    }

    public Date getSourceBillDate() {
        return sourceBillDate;
    }

    public void setSourceBillDate(Date sourceBillDate) {
        this.sourceBillDate = sourceBillDate;
    }

    public String getSourceBillRemark() {
        return sourceBillRemark;
    }

    public void setSourceBillRemark(String sourceBillRemark) {
        this.sourceBillRemark = sourceBillRemark;
    }

    public String getSourceBillDetailRemark() {
        return sourceBillDetailRemark;
    }

    public void setSourceBillDetailRemark(String sourceBillDetailRemark) {
        this.sourceBillDetailRemark = sourceBillDetailRemark;
    }

    public String getSourceBillPurpose() {
        return sourceBillPurpose;
    }

    public void setSourceBillPurpose(String sourceBillPurpose) {
        this.sourceBillPurpose = sourceBillPurpose;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }
}
