/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.bean.InitialCheckDetailEntity;
import com.ejianc.business.store.bean.InitialCheckEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.service.IInitialCheckService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="initialCheck")
public class InitialCheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInitialCheckService initialCheckService;
    @Autowired
    StoreManageService storeManageService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        InitialCheckEntity checkEntity = (InitialCheckEntity)((Object)this.initialCheckService.selectById(billId));
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        storeManageVO.setStoreId(checkEntity.getStoreId());
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        storeManageVO.setSourceId(checkEntity.getId());
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        for (int i = 0; i < checkEntity.getInitialCheckDetailList().size(); ++i) {
            FlowVO flowVO = new FlowVO();
            flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
            this.getFlow(checkEntity, checkEntity.getInitialCheckDetailList().get(i), flowVO);
            flowVOS.add(flowVO);
        }
        storeManageVO.setFlowVOList(flowVOS);
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u6d88\u8017\u6750\u9a8c\u6536\u5165\u5e93\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse<StoreManageVO> response = this.storeManageService.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        InitialCheckEntity checkEntity = (InitialCheckEntity)((Object)this.initialCheckService.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setSourceId(checkEntity.getId());
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        storeManageVO.setStoreId(checkEntity.getStoreId());
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u671f\u521d\u76d8\u70b9\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse<StoreManageVO> response = this.storeManageService.inOutStoreRollback(storeManageVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        return CommonResponse.success();
    }

    private void getFlow(InitialCheckEntity checkEntity, InitialCheckDetailEntity t, FlowVO flowVO) {
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getStoreId());
        flowVO.setStoreName(checkEntity.getStoreName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("\u671f\u521d\u76d8\u70b9");
        flowVO.setSourceBillTypeCode("BT202408000001");
        flowVO.setSourceType(Integer.valueOf(0));
        flowVO.setRowState(t.getRowState());
    }
}

