/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.store.bean.ProjAllotEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.mapper.ProjAllotMapper;
import com.ejianc.business.store.service.IProjAllotService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.ProjAllotVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projAllotService")
public class ProjAllotServiceImpl
extends BaseServiceImpl<ProjAllotMapper, ProjAllotEntity>
implements IProjAllotService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "PROJ_ALLOT";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    StoreManageService storeManageService;

    @Override
    public ProjAllotVO saveOrUpdate(ProjAllotVO saveOrUpdateVO) {
        if (null != saveOrUpdateVO.getOutStoreId() && null != saveOrUpdateVO.getInStoreId() && saveOrUpdateVO.getOutStoreId() == saveOrUpdateVO.getInStoreId()) {
            throw new BusinessException("\u8c03\u51fa\u4e0e\u8c03\u5165\u4e0d\u80fd\u4e3a\u540c\u4e00\u4ed3\u5e93\uff01");
        }
        ProjAllotEntity entity = (ProjAllotEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjAllotEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        ProjAllotVO vo = (ProjAllotVO)BeanMapper.map((Object)((Object)entity), ProjAllotVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vo.getDetailList())) {
            StoreManageVO storeManageVO = this.getStoreManageVO(vo, InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93, false);
            this.storeManageService.inOutStore(storeManageVO);
        }
        return vo;
    }

    @Override
    public void delete(List<ProjAllotVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjAllotVO vo : vos) {
                ProjAllotEntity allotOutEntity = (ProjAllotEntity)((Object)this.selectById(vo.getId()));
                if (!CollectionUtils.isNotEmpty(allotOutEntity.getDetailList())) continue;
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setSourceId(vo.getId());
                storeManageVO.setStoreId(vo.getOutStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                storeManageVO.setOutEffectiveON(Boolean.valueOf(false));
                ArrayList<Long> longs = new ArrayList<Long>();
                longs.add(vo.getId());
                storeManageVO.setSourceIdsForRollBack(longs);
                this.logger.info("\u8c03\u7528\u5e93\u5b58\u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
                this.storeManageService.inOutStoreRollback(storeManageVO);
            }
        }
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public StoreManageVO getStoreManageVO(ProjAllotVO vo, InOutTypeEnum inOutTypeEnum, boolean outEffective) {
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo != null) {
            storeManageVO.setStoreId(2 == inOutTypeEnum.getInOutFlag() ? vo.getOutStoreId() : vo.getInStoreId());
            storeManageVO.setSourceId(vo.getId());
            storeManageVO.setInOutTypeEnum(inOutTypeEnum);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(outEffective));
            ArrayList flowVOS = new ArrayList();
            vo.getDetailList().forEach(t -> {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)inOutTypeEnum, (Integer)0);
                flowVO.setStoreId(vo.getOutStoreId());
                flowVO.setStoreName(vo.getOutStoreName());
                flowVO.setSourceBillTypeName("\u540c\u9879\u76ee\u8c03\u62e8");
                flowVO.setSourceBillTypeCode("BT202412000002");
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialUnit());
                flowVO.setNum(t.getAllotNum());
                flowVO.setTaxPrice(t.getSurplusTaxPrice());
                flowVO.setPrice(t.getSurplusPrice());
                flowVO.setTaxMny(t.getAllotTaxMny());
                flowVO.setMny(t.getAllotMny());
                flowVO.setTax(ComputeUtil.safeSub((BigDecimal)flowVO.getTaxMny(), (BigDecimal)flowVO.getMny()));
                flowVO.setTaxRate(ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)flowVO.getTax(), (BigDecimal)flowVO.getMny()), (BigDecimal)BigDecimal.valueOf(100L)));
                flowVO.setSourceId(vo.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillRemark(vo.getMemo());
                flowVO.setRowState(t.getRowState());
                flowVO.setSourceType(StoreCommonConsts.ZERO);
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }
}

