package com.ejianc.business.store.controller.api;

import com.ejianc.business.store.bean.StoreEntity;
import com.ejianc.business.store.service.IAllotInService;
import com.ejianc.business.store.service.IAllotOutService;
import com.ejianc.business.store.service.IStoreService;
import com.ejianc.business.store.vo.AllotOutVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.business.store.vo.StoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/store/")
@Api(value = "仓库API接口", tags = {"仓库API接口"})
public class StoreApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreService service;

    @Autowired
    private IAllotOutService allotOutService;

    @ApiOperation("查询对应类型的仓库")
    @RequestMapping(value = "/queryStoreByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryStoreByProject(@RequestParam Long projectId, @RequestParam Integer attrFlag){
        StoreEntity storeEntity = service.autoByProjectId(projectId,attrFlag);
        return CommonResponse.success("查询成功",BeanMapper.map(storeEntity,StoreVO.class));
    }


    /**
     * @description: 生成调拨出库单
     * @author sunyj
     * @date: 2023/12/19
     */
    @RequestMapping(value = "/changeToAllouOut", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<AllotOutVO> changeToAllouOut(@RequestBody AllotOutVO allotOutVO){
        return allotOutService.changeAllotOutSave(allotOutVO);
    }

}
