package com.ejianc.business.store.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.store.bean.*;
import com.ejianc.business.store.consts.AllocatEnum;
import com.ejianc.business.store.consts.AllocationState;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.service.IIdleFlowService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.service.handler.IStoreManageHandler;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.*;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.AllotOutMapper;
import com.ejianc.business.store.service.IAllotOutService;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 调拨出库
 *
 * @author generator
 */
@Service("allotOutService")
public class AllotOutServiceImpl extends BaseServiceImpl<AllotOutMapper, AllotOutEntity> implements IAllotOutService {
    @Autowired
    StoreManageService storeManageService;
    @Autowired
    private IAllotOutService service;
    @Autowired
    IIdleFlowService idleFlowService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "ALLOT_OUT";//此处需要根据实际修改
    @Autowired
    private IOrgApi iOrgApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    // 推送成本需要调用的接口 start
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;

    @Override
    public CommonResponse<StoreManageVO> surplusMaterialPrice(AllotOutVO saveOrUpdateVO) {
        StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
        CommonResponse<StoreManageVO> commonResponse = storeManageService.surplusMaterialPrice(storeManageVO);
        return commonResponse;
    }

    @Override
    public CommonResponse<AllotOutVO> allotOutSaveOrUpdate(AllotOutVO saveOrUpdateVO) {
        //再次计算
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())){
            CommonResponse<StoreManageVO> commonResponse = service.surplusMaterialPrice(saveOrUpdateVO);
            StoreManageVO data = commonResponse.getData();
            if (data != null) {
                List<UseMaterialPriceVO> useMaterialPriceVOList = data.getUseMaterialPriceVOList();
                if (CollectionUtils.isNotEmpty(useMaterialPriceVOList)) {
                    Map<Long, List<UseMaterialPriceVO>> collect = useMaterialPriceVOList.stream().collect(Collectors.groupingBy(UseMaterialPriceVO::getMaterialId));
                    List<AllotOutDetailVO> allotOutDetailList = saveOrUpdateVO.getAllotOutDetailList();
                    if (CollectionUtils.isNotEmpty(allotOutDetailList)) {
                        for (AllotOutDetailVO allotOutDetailEntity : allotOutDetailList) {
//                            allotOutDetailEntity.setId(IdWorker.getId());
                            //设置入库
                            Long materialId = allotOutDetailEntity.getMaterialId();
                            List<UseMaterialPriceVO> useMaterialPriceVos = collect.get(materialId);
                            UseMaterialPriceVO useMaterialPriceVO = useMaterialPriceVos.get(0);
                            allotOutDetailEntity.setInStoreMny(ComputeUtil.scaleTwo(useMaterialPriceVO.getMny()));
                            allotOutDetailEntity.setInStoreTaxMny(ComputeUtil.scaleTwo(useMaterialPriceVO.getTaxMny()));
                            allotOutDetailEntity.setInStoreTax(useMaterialPriceVO.getTax());
                            if ((useMaterialPriceVO.getTaxMny() != null) && (allotOutDetailEntity.getAllocatNum() != null)) {
                                BigDecimal inStoreAveragePrice = ComputeUtil.safeDiv(useMaterialPriceVO.getTaxMny(), allotOutDetailEntity.getAllocatNum());
                                allotOutDetailEntity.setInStoreAveragePrice(inStoreAveragePrice);
                            }
                            BigDecimal mny = ComputeUtil.scaleTwo(useMaterialPriceVO.getMny());
                            BigDecimal taxMny = ComputeUtil.scaleTwo(useMaterialPriceVO.getTaxMny());
                            if ((ComputeUtil.isNotEmpty(taxMny)) && (ComputeUtil.isNotEmpty(mny))) {
                                BigDecimal bigDecimal = ComputeUtil.safeDiv(taxMny, mny);
                                BigDecimal inStoreRate = ComputeUtil.safeSub(bigDecimal, BigDecimal.ONE);
                                allotOutDetailEntity.setInStoreTaxRate(ComputeUtil.safeMultiply(inStoreRate,new BigDecimal(100)));
                            }
                        }
                        saveOrUpdateVO.setAllotOutDetailList(allotOutDetailList);
                    }
                }
            }
        }
        //保存修改
        AllotOutEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOutEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //设置默认收料状态
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean b = service.saveOrUpdate(entity, false);
        ////生成出库流水 生成
        if (b) {
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
                List<AllotOutDetailVO> delList = saveOrUpdateVO.getAllotOutDetailList().stream().filter(x -> "del".equals(x.getRowState())).collect(Collectors.toList());
                saveOrUpdateVO= BeanMapper.map(entity, AllotOutVO.class);
                saveOrUpdateVO.setId(entity.getId());
                saveOrUpdateVO.setBillCode(entity.getBillCode());
                saveOrUpdateVO.getAllotOutDetailList().addAll(delList);
                StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
                storeManageService.inOutStore(storeManageVO);
            }
        }
        saveCost(entity,0);
        AllotOutVO vo = BeanMapper.map(entity, AllotOutVO.class);
        return CommonResponse.success("保存修改成功", vo);
    }

    @Override
    @Transactional
    public CommonResponse<AllotOutVO> changeAllotOutSave(AllotOutVO saveOrUpdateVO) {
        logger.info("生成调拨出库单实参数信息--"+JSONObject.toJSONString(saveOrUpdateVO));
        logger.info("allotId："+saveOrUpdateVO.getAllotId());
        Long allotId = saveOrUpdateVO.getAllotId();
        //保存修改
        AllotOutEntity entity = BeanMapper.map(saveOrUpdateVO, AllotOutEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //设置默认收料状态
                entity.setProportionFlag("0"); // 初始化标识
                entity.setRelationFlag("0"); // 初始化标识
                entity.setReceiveState(Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setBillState(1);
        entity.setAllocatType(1);//调拨方式-资产盘活
        entity.setReceiveState(2);//已收料
        logger.info("保存调拨出库单实体信息--"+JSONObject.toJSONString(entity));
        boolean b = service.saveOrUpdate(entity, false);
        //生成闲置数量流水  注意 量为负值    此时必须先插入闲置流水 防止下边校验不通过(surplusMaterialPrice 里边会减去闲置数量)
        if(CollectionUtils.isNotEmpty(entity.getAllotOutDetailList())){
            List<IdleFlowVO> idleFlowVOList =  getIdleFlowVO(entity,entity.getAllotOutDetailList());
            CommonResponse<String> response = idleFlowService.inOutStore(idleFlowVOList);
            if(!response.isSuccess()){
                throw new BusinessException(response.getMsg());
            }
        }
        //再次计算
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())){
            CommonResponse<StoreManageVO> commonResponse = service.surplusMaterialPrice(saveOrUpdateVO);
            logger.info("获取剩余量信息"+commonResponse.getMsg());
            if(!commonResponse.isSuccess()){
                throw new BusinessException(commonResponse.getMsg());
            }
            StoreManageVO data = commonResponse.getData();
            logger.info("获取剩余量信息-{}", JSONObject.toJSONString(data));
            if (data != null) {
                List<UseMaterialPriceVO> useMaterialPriceVOList = data.getUseMaterialPriceVOList();
                if (CollectionUtils.isNotEmpty(useMaterialPriceVOList)) {
                    Map<Long, List<UseMaterialPriceVO>> collect = useMaterialPriceVOList.stream().collect(Collectors.groupingBy(UseMaterialPriceVO::getMaterialId));
                    List<AllotOutDetailEntity> allotOutDetailList = entity.getAllotOutDetailList();
                    if (CollectionUtils.isNotEmpty(allotOutDetailList)) {
                        for (AllotOutDetailEntity allotOutDetailEntity : allotOutDetailList) {
//                            allotOutDetailEntity.setId(IdWorker.getId());
                            //设置入库
                            Long materialId = allotOutDetailEntity.getMaterialId();
                            List<UseMaterialPriceVO> useMaterialPriceVos = collect.get(materialId);
                            UseMaterialPriceVO useMaterialPriceVO = useMaterialPriceVos.get(0);
                            logger.info("useMaterialPriceVO-{}", JSONObject.toJSONString(useMaterialPriceVO));
                            allotOutDetailEntity.setInStoreMny(ComputeUtil.scaleTwo(useMaterialPriceVO.getMny()));
                            allotOutDetailEntity.setInStoreTaxMny(ComputeUtil.scaleTwo(useMaterialPriceVO.getTaxMny()));
                            allotOutDetailEntity.setInStoreTax(useMaterialPriceVO.getTax());
                            if ((useMaterialPriceVO.getTaxMny() != null) && (allotOutDetailEntity.getAllocatNum() != null)) {
                                BigDecimal inStoreAveragePrice = ComputeUtil.safeDiv(useMaterialPriceVO.getTaxMny(), allotOutDetailEntity.getAllocatNum());
                                allotOutDetailEntity.setInStoreAveragePrice(inStoreAveragePrice);
                            }
                            BigDecimal mny = ComputeUtil.scaleTwo(useMaterialPriceVO.getMny());
                            BigDecimal taxMny = ComputeUtil.scaleTwo(useMaterialPriceVO.getTaxMny());
                            if ((ComputeUtil.isNotEmpty(taxMny)) && (ComputeUtil.isNotEmpty(mny))) {
                                BigDecimal bigDecimal = ComputeUtil.safeDiv(taxMny, mny);
                                BigDecimal inStoreRate = ComputeUtil.safeSub(bigDecimal, BigDecimal.ONE);
                                logger.info("税率-inStoreRate{}", inStoreRate);
                                allotOutDetailEntity.setInStoreTaxRate(ComputeUtil.safeMultiply(inStoreRate,new BigDecimal(100)));
                                allotOutDetailEntity.setAllocatTaxRate(ComputeUtil.safeMultiply(inStoreRate,new BigDecimal(100)));
                                allotOutDetailEntity.setAllocatTax(ComputeUtil.safeMultiply(allotOutDetailEntity.getAllocatTaxMny(), inStoreRate));
                                allotOutDetailEntity.setAllocatMny(ComputeUtil.safeSub(allotOutDetailEntity.getAllocatTaxMny(), allotOutDetailEntity.getAllocatTax()));
                                allotOutDetailEntity.setAllocatPrice(ComputeUtil.safeDiv(allotOutDetailEntity.getAllocatMny(), allotOutDetailEntity.getAllocatNum()));
                            }
                            allotOutDetailEntity.setAllotDiffMny(ComputeUtil.safeSub(allotOutDetailEntity.getInStoreMny(), allotOutDetailEntity.getAllocatMny()));
                            allotOutDetailEntity.setAllotDiffTaxMny(ComputeUtil.safeSub(allotOutDetailEntity.getInStoreTaxMny(), allotOutDetailEntity.getAllocatTaxMny()));

                            entity.setOutMny(allotOutDetailEntity.getAllocatMny());
                        }
                        entity.setAllotOutDetailList(allotOutDetailList);
                        entity.setSumAllotDiffMny(allotOutDetailList.get(0).getAllotDiffMny());
                        entity.setSumAllotDiffTaxMny(allotOutDetailList.get(0).getAllotDiffTaxMny());
                        service.saveOrUpdate(entity, false);//更新金额单价 字段
                    }
                }
            }
        }

        if (b) {
            //生成调拨出库--
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
                saveOrUpdateVO= BeanMapper.map(entity, AllotOutVO.class);
                saveOrUpdateVO.setId(entity.getId());
                saveOrUpdateVO.setBillCode(entity.getBillCode());
                StoreManageVO storeManageVO = saveOrUpdateVO.getStoreManageVO(saveOrUpdateVO);
                storeManageVO.setOutEffectiveON(true);
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
                storeManageVO.setOutFlagON(true);//直接生效
//                CommonResponse<StoreManageVO>  storeManageVOCommonResponse = storeManageHandler.outHandle(storeManageVO);
                CommonResponse<StoreManageVO>  storeManageVOCommonResponse =storeManageService.inOutStore(storeManageVO);
                if(!storeManageVOCommonResponse.isSuccess()){
                    throw new BusinessException(storeManageVOCommonResponse.getMsg());
                }
                logger.info("生成调拨出库未生效 流水结果--"+storeManageVOCommonResponse.isSuccess()+"====="+storeManageVOCommonResponse.getMsg());
            }

            //生成调拨出库流水--生效
//            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getAllotOutDetailList())) {
//                StoreManageVO storeManageVO = new StoreManageVO();
//                storeManageVO.setStoreId(entity.getStoreId());
//                storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
//                storeManageVO.setOutEffectiveON(true);
//                storeManageVO.setSourceId(entity.getId());
//                logger.info("生成调拨出库生效 流水--"+JSONObject.toJSONString(storeManageVO));
//                CommonResponse<StoreManageVO>  storeManageVOCommonResponse =storeManageService.inOutStore(storeManageVO);
//                logger.info("生成调拨出库生效 流水结果--"+storeManageVOCommonResponse.isSuccess()+"====="+storeManageVOCommonResponse.getMsg());
//            }
            //生成调拨入库流水
            AllotInEntity allotInEntity = getAllotInEntity(allotId,entity);
            StoreManageVO storeManageVO2 = getStoreManageVO(allotInEntity);
            logger.info("生成调拨入库流水--"+JSONObject.toJSONString(storeManageVO2));
            CommonResponse<StoreManageVO> storeManageVOCommonResponse = storeManageService.inOutStore(storeManageVO2);
            if(!storeManageVOCommonResponse.isSuccess()){
                throw new BusinessException(storeManageVOCommonResponse.getMsg());
            }
            logger.info("生成调拨入库流水结果--"+storeManageVOCommonResponse.isSuccess()+"====="+storeManageVOCommonResponse.getMsg());
        }
        costPush(entity);
        AllotOutVO vo = BeanMapper.map(entity, AllotOutVO.class);
        return CommonResponse.success("保存成功", vo);
    }

    public AllotInEntity getAllotInEntity(Long allotId,AllotOutEntity allotOutEntity){
        logger.info("allotId："+allotId);
        //生成调拨入库
        AllotInEntity allotInEntity = new AllotInEntity();
        //出库信息
        allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
        allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
        allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
        allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
        //入库信息
        allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
        allotInEntity.setProjectId(allotOutEntity.getInProjectId());
        allotInEntity.setProjectName(allotOutEntity.getInProjectName());
        allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
        allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
        allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
        allotInEntity.setOrgId(allotOutEntity.getInOrgId());
        allotInEntity.setOrgCode(allotOutEntity.getInOrgCode());
        allotInEntity.setOrgName(allotOutEntity.getInOrgName());
        allotInEntity.setAllotOutId(allotOutEntity.getId());
        allotInEntity.setOutMny(allotOutEntity.getOutMny());
        allotInEntity.setOutDate(allotOutEntity.getOutDate());
        allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
        allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
        allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
        allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
        allotInEntity.setStoreId(allotOutEntity.getInStoreId());//调入仓库信息
        allotInEntity.setStoreName(allotOutEntity.getInStoreName());
        allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
        allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
        allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
        allotInEntity.setMemo(allotOutEntity.getMemo());
        allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
        if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
            List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
            allotInDetailEntitys.forEach(item->{
                item.setId(null);
                item.setAllocatId(allotId);
            });
            allotInEntity.setAllotInDetailList(allotInDetailEntitys);
            logger.info("子表信息："+allotInDetailEntitys.toString());
        }
        AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        if(billCode.isSuccess()) {
            allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        allotInEntity.setId(allotId);
        return allotInEntity;
    }

    public List<IdleFlowVO> getIdleFlowVO(AllotOutEntity vo,List<AllotOutDetailEntity> list){
        List<IdleFlowVO> flowVOS = new ArrayList<>();
        list.forEach(t->{
            IdleFlowVO flowVO = new IdleFlowVO();
            flowVO.setStoreId(vo.getStoreId());
            flowVO.setStoreName(vo.getStoreName());
            flowVO.setSourceBillTypeName("调拨出库");
            flowVO.setSourceBillTypeCode("BT220209000000004");
            flowVO.setProjectId(vo.getProjectId());
            flowVO.setProjectName(vo.getProjectName());
            flowVO.setOrgId(vo.getOrgId());
            flowVO.setOrgName(vo.getOrgName());
            flowVO.setParentOrgId(vo.getParentOrgId());
            flowVO.setParentOrgName(vo.getParentOrgName());
            flowVO.setParentOrgCode(vo.getParentOrgCode());
            flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
            flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
            flowVO.setMaterialId(t.getMaterialId());
            flowVO.setMaterialName(t.getMaterialName());
            flowVO.setMaterialSpec(t.getMaterialSpec());
            flowVO.setMaterialUnitId(t.getMaterialUnitId());
            flowVO.setMaterialUnitName(t.getMaterialUnit());
            flowVO.setNum(ComputeUtil.safeSub(BigDecimal.ZERO, t.getAllocatNum()));//订单确认的时候，闲置数量为负数
            flowVO.setSourceId(vo.getId());
            flowVO.setSourceDetailId(t.getId());
            flowVO.setSourceBillCode(vo.getBillCode());
            flowVO.setSourceBillDate(vo.getOutDate());
            flowVO.setSourceBillRemark(vo.getMemo());
            flowVO.setRowState(t.getRowState());
            flowVOS.add(flowVO);
        });
        return flowVOS;
    }

    public StoreManageVO getStoreManageVO(AllotInEntity vo ){
        StoreManageVO storeManageVO = new StoreManageVO();
        if (vo!=null){
            storeManageVO.setStoreId(vo.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨入库);
            storeManageVO.setSourceId(vo.getId());
            ArrayList<FlowVO> flowVOS = new ArrayList<>();
            vo.getAllotInDetailList().forEach(t->{
                FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.调拨入库, 0);
                flowVO.setStoreId(vo.getStoreId());
                flowVO.setStoreName(vo.getStoreName());
                flowVO.setSourceBillTypeName("调拨入库");
                flowVO.setSourceBillTypeCode("BT220209000000003");
                flowVO.setProjectId(vo.getProjectId());
                flowVO.setProjectName(vo.getProjectName());
                flowVO.setOrgId(vo.getOrgId());
                flowVO.setOrgName(vo.getOrgName());
                flowVO.setParentOrgId(vo.getParentOrgId());
                flowVO.setParentOrgName(vo.getParentOrgName());
                flowVO.setParentOrgCode(vo.getParentOrgCode());
                flowVO.setEmployeeId(vo.getEmployeeId());
                flowVO.setEmployeeName(vo.getEmployeeName());
                flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
                flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
                flowVO.setMaterialId(t.getMaterialId());
                flowVO.setMaterialName(t.getMaterialName());
                flowVO.setMaterialSpec(t.getMaterialSpec());
                flowVO.setMaterialUnitId(t.getMaterialUnitId());
                flowVO.setMaterialUnitName(t.getMaterialUnit());
                flowVO.setNum(t.getAllocatNum());
                flowVO.setTaxPrice(t.getAllocatTaxPrice());
                flowVO.setTaxMny(t.getAllocatTaxMny());
                flowVO.setMny(t.getAllocatMny());
                flowVO.setTax(t.getAllocatTax());
                flowVO.setPrice(t.getAllocatPrice());
                flowVO.setTaxRate(t.getAllocatTaxRate());
                flowVO.setSourceId(vo.getId());
                flowVO.setSourceDetailId(t.getId());
                flowVO.setSourceBillCode(vo.getBillCode());
                flowVO.setSourceBillDate(vo.getOutDate());
                flowVO.setSourceBillRemark(vo.getMemo());
                flowVO.setRowState("add");
                flowVO.setSourceType(StoreCommonConsts.TWO);// 0-自制,1-订单，2-资产盘活
                flowVOS.add(flowVO);
            });
            storeManageVO.setFlowVOList(flowVOS);
        }
        return storeManageVO;
    }
    @Override
    public CommonResponse<String> allotOutDelete(List<AllotOutVO> vos) {

        if (ListUtil.isNotEmpty(vos)) {
            for (AllotOutVO vo : vos) {
                AllotOutEntity allotOutEntity = service.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
                    StoreManageVO storeManageVO = new StoreManageVO();
                    storeManageVO.setStoreId(allotOutEntity.getStoreId());
                    storeManageVO.setSourceId(allotOutEntity.getId());
                    storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
                    ArrayList<Long> longs = new ArrayList<>();
                    longs.add(allotOutEntity.getId());
                    storeManageVO.setSourceIdsForRollBack(longs);
                    storeManageService.inOutStoreRollback(storeManageVO);
                }
            }
            Collection<AllotOutEntity> list = service.listByIds(vos.stream().map(AllotOutVO::getId).collect(Collectors.toList()));
            list.forEach(e->{
                //删除实际成本
                CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(e.getId());
                logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
                if(!stringCommonResponse.isSuccess()){
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            });
        }


        boolean b = service.removeByIds(vos.stream().map(AllotOutVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public void excelExport(QueryParam param, HttpServletResponse response) {
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("materialNames");
        fuzzyFields.add("inProjectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("receiverPerson");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<AllotOutEntity> list = service.queryList(param);
        List<AllotOutExportVO> allotOutVos = BeanMapper.mapList(list, AllotOutExportVO.class);
        allotOutVos.forEach(vo -> {
            if (vo.getOutDate() != null) {
                vo.setAllocatDate(DateFormatUtil.formatDate("yyyy-MM-dd", vo.getOutDate()));
            }
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (vo.getReceiveState() != null) {
                if (Integer.valueOf(AllocationState.TO_RECEIVING.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.TO_RECEIVING.getDescription());
                } else if (Integer.valueOf(AllocationState.RECEIVED.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.RECEIVED.getDescription());
                } else if (Integer.valueOf(AllocationState.REJECT.getCode()).equals(vo.getReceiveState())) {
                    vo.setReceiveStateName(AllocationState.REJECT.getDescription());
                }
            }
            if (vo.getAllocatType() != null) {
                if (Integer.valueOf(AllocatEnum.ASSETS.getCode()).equals(vo.getAllocatType())) {
                    vo.setAllocatTypeName(AllocatEnum.ASSETS.getDescription());
                } else {
                    vo.setAllocatTypeName(AllocatEnum.HOMEMADE.getDescription());
                }
            }
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", allotOutVos);
        ExcelExport.getInstance().export("allocationOutExport.xlsx", beans, response);
    }

    @Override
    public CommonResponse<AllotOutVO> pushCost(AllotOutVO allotOutVO) {
        AllotOutEntity allotOutEntity = baseMapper.selectById(allotOutVO.getId());
        if (CollectionUtils.isNotEmpty(allotOutVO.getAllotOutDetailList())) {
            List<AllotOutDetailEntity> allotOutDetailEntitys = BeanMapper.mapList(allotOutVO.getAllotOutDetailList(), AllotOutDetailEntity.class);
            allotOutEntity.setAllotOutDetailList(allotOutDetailEntitys);
        }
        super.saveOrUpdate(allotOutEntity, false);
        //推送数据
        this.costPush(allotOutEntity);
        return CommonResponse.success(BeanMapper.map(allotOutEntity, AllotOutVO.class));
    }

    @Override
    public void costPush(AllotOutEntity allotOutEntity) {
        logger.info("开始costPush");
        List<AllotOutDetailEntity> allotOutDetailEntities = allotOutEntity.getAllotOutDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AllotOutDetailEntity entity : allotOutDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    logger.info("getSubjectId"+entity.getSubjectId());
                    logger.info("getWbsId"+entity.getWbsId());
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        logger.info("newRelationFlag"+newRelationFlag);
        //先删后增
        saveCost(allotOutEntity,1);//生效状态 0-未生效，1-生效

        //更新是否关联
        LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(AllotOutEntity::getId, allotOutEntity.getId());
        updateWrapper.set(AllotOutEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }
    private void saveCost(AllotOutEntity allotOutEntity,Integer effectiveStatus) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<AllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAllotOutDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailList)) {
            //根据物资id查询物资编码
            List<Long> materialIds = allotOutDetailList.stream().map(AllotOutDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> listCommonResponse = shareMaterialApi.queryMaterialByIds(materialIds);
            List<MaterialVO> voList = new ArrayList<>();
            if(listCommonResponse.isSuccess()){
                voList = listCommonResponse.getData();
            }
            Map<Long, String> materialMap = new HashMap<>();
            voList.forEach(item -> materialMap.put(item.getId(),item.getCode()));
            for (AllotOutDetailEntity entity : allotOutDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getAllocatId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getAllotDiffTaxMny());
                costDetailVO.setHappenMny(entity.getAllotDiffMny());
                costDetailVO.setHappenDate(allotOutEntity.getOutDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ALLOT_OUT");
                costDetailVO.setSourceTabType("ALLOT_OUT_SUB");
                costDetailVO.setProjectId(allotOutEntity.getProjectId());
                //新加的
                costDetailVO.setSourceBillCode(allotOutEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.调拨出库单.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-store-frontend/#/allotOut/card?id="+allotOutEntity.getId());
                //2022-8-16新增传输字段
                costDetailVO.setMaterialId(entity.getMaterialId());
                costDetailVO.setMaterialName(entity.getMaterialName());
                costDetailVO.setMaterialTypeId(entity.getMaterialCategoryId());
                costDetailVO.setMaterialTypeName(entity.getMaterialCategoryName());
                costDetailVO.setMaterialCode(materialMap.get(entity.getMaterialId()));
                costDetailVO.setUnitId(entity.getMaterialUnitId());
                costDetailVO.setUnit(entity.getMaterialUnit());
                costDetailVO.setSpec(entity.getMaterialSpec());
                costDetailVO.setEffectiveStatus(effectiveStatus);//生效状态 0-未生效，1-生效
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public ParamsCheckVO checkParams(AllotOutVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        //--成本科目控制
        CostCtrlVO costCtrlVO = this.sjCost(vo);
        if(null!=costCtrlVO){
            CommonResponse<ParamsCheckVO> costResponse = executionApi.ctrlCost(costCtrlVO);
            if (!costResponse.isSuccess()) {
                throw new BusinessException("成本科目控制失败," + costResponse.getMsg());
            }
            ParamsCheckVO costRes = costResponse.getData();
            if(null!=costRes){
                paramsCheckVOS.add(costRes);
            }
        }
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                }
                else {
                    map.put(warnType, checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    public CostCtrlVO sjCost(AllotOutVO vo){
        List<AllotOutDetailVO> feeList = vo.getAllotOutDetailList();
        if(CollectionUtils.isNotEmpty(feeList)){
            Map<Long, CostCtrlDetailVO> map = new HashMap<>();
            for(AllotOutDetailVO allotOutDetailVO:feeList){
                if(null!=allotOutDetailVO.getSubjectId() &&!"del".equals(allotOutDetailVO.getRowState())){
                    BigDecimal feeMny = allotOutDetailVO.getAllotDiffMny()==null?BigDecimal.ZERO:allotOutDetailVO.getAllotDiffMny();
                    BigDecimal feeTaxMny = allotOutDetailVO.getAllotDiffTaxMny()==null?BigDecimal.ZERO:allotOutDetailVO.getAllotDiffTaxMny();
                    if(map.containsKey(allotOutDetailVO.getSubjectId())){
                        CostCtrlDetailVO costCtrlDetailVO = map.get(allotOutDetailVO.getSubjectId());
                        BigDecimal mny = costCtrlDetailVO.getMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getMny();
                        BigDecimal taxMny = costCtrlDetailVO.getTaxMny()==null?BigDecimal.ZERO:costCtrlDetailVO.getTaxMny();
                        costCtrlDetailVO.setMny(mny.add(feeMny));
                        costCtrlDetailVO.setTaxMny(taxMny.add(feeTaxMny));
                    }else{
                        CostCtrlDetailVO costCtrlDetailVO = new CostCtrlDetailVO();
                        costCtrlDetailVO.setSubjectId(allotOutDetailVO.getSubjectId());
                        costCtrlDetailVO.setMny(feeMny);
                        costCtrlDetailVO.setTaxMny(feeTaxMny);
                        map.put(costCtrlDetailVO.getSubjectId(),costCtrlDetailVO);
                    }
                }
            }
            if(null!=map && map.size() > 0){
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if(null!=vo.getId()){
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList<>(map.values()));
                return ctrlVO;
            }else{
                return null;
            }
        }
        return null;
    }
}
