package com.ejianc.business.store.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.bean.IdleFlowEntity;
import com.ejianc.business.store.bean.SurplusEntity;
import com.ejianc.business.store.mapper.IdleFlowMapper;
import com.ejianc.business.store.service.IIdleFlowService;
import com.ejianc.business.store.service.ISurplusService;
import com.ejianc.business.store.vo.IdleFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 盘活闲置流水表
 *
 * @author generator
 *
 */
@Service("idleFlowService")
public class IdleFlowServiceImpl extends BaseServiceImpl<IdleFlowMapper, IdleFlowEntity> implements IIdleFlowService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISurplusService surplusService;

    @Override
    public CommonResponse<String> inOutStore(List<IdleFlowVO> flowVOS) {
        List<IdleFlowEntity> flowEntities = BeanMapper.mapList(flowVOS, IdleFlowEntity.class);
        QueryWrapper<IdleFlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.and(q -> {
            for(IdleFlowEntity f : flowEntities) {
                q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("material_id", f.getMaterialId()));
            }
            return q;
        });
        List<IdleFlowEntity> list = list(queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            list = new ArrayList<>();
        }
        list.addAll(flowEntities);
        Map<String, BigDecimal> resultMap = list.stream()
                .collect(Collectors.groupingBy(
                        x -> x.getStoreId() + "@" + x.getMaterialId(),
                        Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)
                ));
        QueryWrapper<SurplusEntity> wrapper = new QueryWrapper<>();
        wrapper.and(q -> {
            for(IdleFlowEntity f : flowEntities) {
                q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("material_id", f.getMaterialId()));
            }
            return q;
        });
        List<SurplusEntity> surplusEntities = surplusService.list(wrapper);
        List<SurplusEntity> updateList = new ArrayList<>();
        for(SurplusEntity surplusEntity : surplusEntities){
            String key = surplusEntity.getStoreId() + "@" + surplusEntity.getMaterialId();
            if (!resultMap.containsKey(key) || ComputeUtil.isLessThan(surplusEntity.getSurplusNum(), resultMap.get(key))) {
                return CommonResponse.error("物资[名称：" + surplusEntity.getMaterialName() + "，规格：" + StrUtil.emptyToDefault(surplusEntity.getMaterialSpec(), "无") + "，库存可用量：" + ComputeUtil.scaleTwo(ComputeUtil.safeSub(surplusEntity.getSurplusNum(), surplusEntity.getIdleNum())) + "，库存不足!");
            }else {
                surplusEntity.setIdleNum(resultMap.get(key));
                updateList.add(surplusEntity);
            }
        }

        boolean b = saveOrUpdateBatch(flowEntities);
        //入库成功后更新库存
        if (b && CollectionUtils.isNotEmpty(updateList)) {
            surplusService.saveOrUpdateBatch(updateList);
        }
        return CommonResponse.success("推送盘活闲置流水成功！");
    }

    @Override
    public CommonResponse<String> inOutStoreRollback(Long sourceId) {
        logger.info("撤回操作---"+sourceId);
        //先查询数据库的数据并删除
        QueryWrapper<IdleFlowEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("source_id", sourceId);
        List<IdleFlowEntity> dblist = list(queryWrapper);
        if(CollectionUtils.isNotEmpty(dblist)){
            logger.info("撤回操作dblist---"+JSONObject.toJSONString(dblist));
            if(remove(queryWrapper)){
                //查询剩余流水重新算汇总闲置量
                QueryWrapper<IdleFlowEntity > wrapper = new QueryWrapper<>();
                wrapper.and(q -> {
                    for(IdleFlowEntity f : dblist) {
                        q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("material_id", f.getMaterialId()));
                    }
                    return q;
                });
                List<IdleFlowEntity> list = list(wrapper);
                logger.info("撤回操作list---"+JSONObject.toJSONString(list));
                Map<String, BigDecimal> resultMap = list.stream()
                        .collect(Collectors.groupingBy(
                                x -> x.getStoreId() + "@" + x.getMaterialId(),
                                Collectors.reducing(BigDecimal.ZERO, IdleFlowEntity::getNum, BigDecimal::add)
                        ));
                //查询相关的余量表
                QueryWrapper<SurplusEntity> query = new QueryWrapper<>();
                query.and(q -> {
                    for(IdleFlowEntity f : dblist) {
                        q.or(iq -> iq.eq("store_id", f.getStoreId()).eq("material_id", f.getMaterialId()));
                    }
                    return q;
                });
                List<SurplusEntity> surplusEntities = surplusService.list(query);
                logger.info("撤回操作surplusEntities---"+JSONObject.toJSONString(surplusEntities));
                List<SurplusEntity> updateList = new ArrayList<>();
                for(SurplusEntity surplusEntity : surplusEntities){
                    String key = surplusEntity.getStoreId() + "@" + surplusEntity.getMaterialId();
                    if (resultMap.containsKey(key)) {
                        surplusEntity.setIdleNum(resultMap.get(key));
                        updateList.add(surplusEntity);
                    }else {
                        surplusEntity.setIdleNum(BigDecimal.ZERO);
                        updateList.add(surplusEntity);
                    }
                }

                if (CollectionUtils.isNotEmpty(updateList)) {
                    surplusService.saveOrUpdateBatch(updateList);
                }
            }
        }
        return CommonResponse.success("删除盘活闲置流水成功！");
    }
}
