package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.ApplyEntity;
import com.ejianc.business.store.service.IApplyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.DisposeMapper;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.service.IDisposeService;

import java.util.List;

/**
 * 废旧物资处理明细
 * 
 * @author generator
 * 
 */
@Service("disposeService")
public class DisposeServiceImpl extends BaseServiceImpl<DisposeMapper, DisposeEntity> implements IDisposeService{

    @Autowired
    private IApplyService applyService;

    @Override
    public void updateApply(Long disposeId, List<Long> applyIds) {
        LambdaUpdateWrapper<ApplyEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(ApplyEntity::getDisposeId, disposeId);
        wrapper.set(ApplyEntity::getDisposeId, null);
        wrapper.set(ApplyEntity::getUseFlag, 0);
        applyService.update(wrapper);
        if (CollectionUtils.isNotEmpty(applyIds)) {
            LambdaUpdateWrapper<ApplyEntity> lw = new LambdaUpdateWrapper();
            lw.in(ApplyEntity::getId, applyIds);
            lw.set(ApplyEntity::getDisposeId, disposeId);
            lw.set(ApplyEntity::getUseFlag,1);
            applyService.update(lw);
        }

    }
    
}
