package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 仓库盘点明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_check_detail")
public class CheckDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="check_id")
    private Long checkId; // 所属盘点单据Id
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类Id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资Id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private Long unit; // 计量单位
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="acc_num")
    private BigDecimal accNum; // 期末账面结存数量
    @TableField(value="price")
    private BigDecimal price; // 单价
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 单价
    @TableField(value="acc_amount")
    private BigDecimal accAmount; // 期末账面结存无税金额
    @TableField(value="check_num")
    private BigDecimal checkNum; // 实际盘点数量
    @TableField(value="inventory")
    private BigDecimal inventory; // 盘盈盘亏无税金额
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额(无税)

    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象id
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象code
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象name
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目id
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目code
    @TableField(value="subject_name")
    private String subjectName; // 成本科目name

    @TableField(value="begin_num")
    private BigDecimal beginNum; // 期初数量
    @TableField(value="begin_mny")
    private BigDecimal beginMny; // 期初无税金额
    @TableField(value="in_store_num")
    private BigDecimal inStoreNum; // 入库数量
    @TableField(value="in_store_mny")
    private BigDecimal inStoreMny; // 入库金额
    @TableField(value="in_num")
    private BigDecimal inNum; // 调入数量
    @TableField(value="in_mny")
    private BigDecimal inMny; // 调入无税金额
    @TableField(value="out_store_num")
    private BigDecimal outStoreNum; // 消耗数量
    @TableField(value="out_store_mny")
    private BigDecimal outStoreMny; // 消耗无税金额
    @TableField(value="out_num")
    private BigDecimal outNum; // 调出数量
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出无税金额
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 实际盘点无税金额
    @TableField(value="category_code")
    private String categoryCode; // 物资分类编码

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }
    public BigDecimal getBeginNum() {
        return beginNum;
    }

    public void setBeginNum(BigDecimal beginNum) {
        this.beginNum = beginNum;
    }

    public BigDecimal getBeginMny() {
        return beginMny;
    }

    public void setBeginMny(BigDecimal beginMny) {
        this.beginMny = beginMny;
    }

    public BigDecimal getInStoreNum() {
        return inStoreNum;
    }

    public void setInStoreNum(BigDecimal inStoreNum) {
        this.inStoreNum = inStoreNum;
    }

    public BigDecimal getInStoreMny() {
        return inStoreMny;
    }

    public void setInStoreMny(BigDecimal inStoreMny) {
        this.inStoreMny = inStoreMny;
    }

    public BigDecimal getInNum() {
        return inNum;
    }

    public void setInNum(BigDecimal inNum) {
        this.inNum = inNum;
    }

    public BigDecimal getInMny() {
        return inMny;
    }

    public void setInMny(BigDecimal inMny) {
        this.inMny = inMny;
    }

    public BigDecimal getOutStoreNum() {
        return outStoreNum;
    }

    public void setOutStoreNum(BigDecimal outStoreNum) {
        this.outStoreNum = outStoreNum;
    }

    public BigDecimal getOutStoreMny() {
        return outStoreMny;
    }

    public void setOutStoreMny(BigDecimal outStoreMny) {
        this.outStoreMny = outStoreMny;
    }

    public BigDecimal getOutNum() {
        return outNum;
    }

    public void setOutNum(BigDecimal outNum) {
        this.outNum = outNum;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }

    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getCheckId() {
        return checkId;
    }

    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnit() {
        return unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getAccNum() {
        return accNum;
    }

    public void setAccNum(BigDecimal accNum) {
        this.accNum = accNum;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getAccAmount() {
        return accAmount;
    }

    public void setAccAmount(BigDecimal accAmount) {
        this.accAmount = accAmount;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getInventory() {
        return inventory;
    }

    public void setInventory(BigDecimal inventory) {
        this.inventory = inventory;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
