package com.ejianc.business.store.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.store.consts.StoreAttrEnum;
import com.ejianc.business.store.consts.StoreCommonConsts;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.store.bean.FlowEntity;
import com.ejianc.business.store.service.IFlowService;
import com.ejianc.business.store.vo.FlowVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 仓库流水表
 *
 * @author generator
 */
@Controller
@RequestMapping("flow")
@Api(value = "仓库流水表", tags = {"仓库流水表"})
public class FlowController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "STORE_FLOW_CODE";

    @Autowired
    private IFlowService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<FlowVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody FlowVO saveOrUpdateVO) {
        FlowEntity entity = BeanMapper.map(saveOrUpdateVO, FlowEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        FlowVO vo = BeanMapper.map(entity, FlowVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<FlowVO> queryDetail(@RequestParam Long id) {
        FlowEntity entity = service.selectById(id);
        FlowVO vo = BeanMapper.map(entity, FlowVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FlowVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FlowVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(FlowVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<FlowEntity> page = service.queryPage(param, false);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<FlowEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Flow-export.xlsx", beans, response);
    }

    @ApiOperation("参照入库(材料合并)")
    @RequestMapping(value = "/refInstoreFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refInstoreFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                            String condition,
                                                            String searchObject,
                                                            String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if (_con.containsKey("contractId")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if (_con.containsKey("storeId")) {
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, _con.get("storeId")));
            }
            if (_con.containsKey("sourceBillDate")) {
                param.getParams().put("sourceBillDate", new Parameter(QueryParam.LE, _con.get("sourceBillDate")));
            }
            if (_con.containsKey("materialIds")) {
                param.getParams().put("materialId", new Parameter(QueryParam.IN, _con.get("materialIds")));
            }
        }

        Page<FlowVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<FlowVO> list = service.queryInstoreFlowData(page, wrapper);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        list.forEach(item -> {
            item.getSurplusNum().setScale(4, BigDecimal.ROUND_UP);
            item.getNum().setScale(4, BigDecimal.ROUND_UP);
        });
        pageData.setRecords(BeanMapper.mapList(list, FlowVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                     String condition,
                                                     String searchObject,
                                                     String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<FlowEntity> page = service.queryPage(param, false);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), FlowVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @description: 对账/结算入库材料参照
     * 有合同: 项目id和合同id
     * 无合同: 项目id\供应商id并且合同id为空
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.store.vo.FlowVO>>
     * @author songlx
     * @date: 2022/3/9
     */
    @ApiOperation("对账/结算入库材料参照")
    @RequestMapping(value = "/refAccountSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<StoreApiVO>> refAccountSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                  String condition,
                                                                  String searchObject,
                                                                  String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        Page<StoreApiVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper<FlowEntity> wrapper = changeToQueryWrapper(param);
        QueryWrapper<FlowEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                wrapper.eq("project_id", _con.get("projectId"));
            }
            //有合同能查询到有合同还有无合同，有合同的范围大
            if (_con.containsKey("contractId")) {
                wrapper.and((changeWrapper) -> changeWrapper.eq("purchase_contract_id", _con.get("contractId")).or().isNull("purchase_contract_id"));
            } else {
                wrapper.isNull("purchase_contract_id");
            }
            if (_con.containsKey("supplierId")) {
                wrapper.eq("supplier_id", _con.get("supplierId"));
            }
            if (_con.containsKey("inOutType")) {
                wrapper.in("in_out_type", _con.get("inOutType"));
                queryWrapper.in("in_out_type", _con.get("inOutType"));
            }
            if (_con.containsKey("accountFlag")) {
                wrapper.eq("account_flag", _con.get("accountFlag"));
                queryWrapper.eq("account_flag", _con.get("accountFlag"));
            }
            if (_con.containsKey("settleFlag")) {
                wrapper.eq("settle_flag", _con.get("settleFlag"));
                queryWrapper.eq("settle_flag", _con.get("settleFlag"));
            }
            // 材料标志，0消耗材，1周转材，不放默认查询消耗材
            if (_con.containsKey("turnFlag")) {
                wrapper.eq("turn_flag", _con.get("turnFlag"));
            }else {
                //消耗材 过滤掉甲供材的物资 2022-4-19 turnFlag 没有传这个字段 写在else
                wrapper.ne("store_type", StoreAttrEnum.ASUPPLY.getCode());
            }
            if(_con.containsKey("effectiveDate")){
                wrapper.le("TO_CHAR(source_bill_date, 'YYYY-MM-DD')", _con.get("effectiveDate"));//edit by syj   effective_date->source_bill_date
            }
        }

        List<StoreApiVO> list = service.queryStoreInstoreData(page, wrapper);
        IPage<StoreApiVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<StoreApiVO> storeInstoreVOS = BeanMapper.mapList(list, StoreApiVO.class);
        if (CollectionUtils.isNotEmpty(storeInstoreVOS)) {
            List<Long> sourceIds = storeInstoreVOS.stream().map(StoreApiVO::getSourceId).collect(Collectors.toList());
            queryWrapper.in("source_id", sourceIds);
            queryWrapper.eq("in_out_flag", StoreCommonConsts.IN_OUT_TYPE_IN);
            List<FlowEntity> flowEntities = service.list(queryWrapper);
            List<FlowVO> flowVOS = BeanMapper.mapList(flowEntities, FlowVO.class);
            Map<Long, List<FlowVO>> flowMap = flowVOS.stream().collect(Collectors.groupingBy(FlowVO::getSourceId));
            storeInstoreVOS.forEach(t -> {
                t.setDetail(flowMap.get(t.getSourceId()));
            });
        }

        pageData.setRecords(storeInstoreVOS);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @description: 周转材入库参照
     * @return: com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.store.vo.FlowVO>>
     * @author songlx
     * @date: 2022/3/9
     */
    @ApiOperation("周转材入库参照")
    @RequestMapping(value = "/refTurnInstoreFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<FlowVO>> refTurnInstoreFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if (_con.containsKey("contractId")) {
                param.getParams().put("purchaseContractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if (_con.containsKey("storeId")) {
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, _con.get("storeId")));
            }
            if (_con.containsKey("sourceBillDate")) {
                param.getParams().put("sourceBillDate", new Parameter(QueryParam.LE, _con.get("sourceBillDate")));
            }
            if (_con.containsKey("materialIds")) {
                param.getParams().put("materialId", new Parameter(QueryParam.IN, _con.get("materialIds")));
            }
        }

        Page<FlowVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<FlowVO> list = service.queryTurnInstoreFlowData(page, wrapper);
        IPage<FlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        list.forEach(item -> {
            item.getSurplusNum().setScale(4, BigDecimal.ROUND_UP);
            item.getNum().setScale(4, BigDecimal.ROUND_UP);
        });
        pageData.setRecords(BeanMapper.mapList(list, FlowVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
