package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 仓库材料处置明细表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_handle_detail")
public class HandleDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="handle_id")
    private Long handleId; // 处置ID
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类Id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物资Id
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private Long unit; // 计量单位
    @TableField(value="unit_name")
    private String unitName; // 计量单位
    @TableField(value="surplus_num")
    private BigDecimal surplusNum; // 库存余量
    @TableField(value="handle_price")
    private BigDecimal handlePrice; // 处置单价
    @TableField(value="handle_num")
    private BigDecimal handleNum; // 处置数量
    @TableField(value="in_store_avg")
    private BigDecimal inStoreAvg; // 入库均价
    @TableField(value="handle_mny")
    private BigDecimal handleMny; // 处置金额
    @TableField(value="in_store_tax_mny")
    private BigDecimal inStoreTaxMny; // 入库金额
    @TableField(value="in_store_tax")
    private BigDecimal inStoreTax; // 入库税额
    @TableField(value="in_store_mny")
    private BigDecimal inStoreMny; // 入库金额(无税)
    @TableField(value="handle_sub_tax_mny")
    private BigDecimal handleSubTaxMny; // 处置差额
    @TableField(value="handle_sub_mny")
    private BigDecimal handleSubMny; // 处置差额(无税)
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="handle_tax_mny")
    private BigDecimal handleTaxMny; // 处置金额(含税)
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象id
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象code
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象name
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目id
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目code
    @TableField(value="subject_name")
    private String subjectName; // 成本科目name

    public BigDecimal getHandleTaxMny() {
        return handleTaxMny;
    }

    public void setHandleTaxMny(BigDecimal handleTaxMny) {
        this.handleTaxMny = handleTaxMny;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getHandleId() {
        return handleId;
    }

    public void setHandleId(Long handleId) {
        this.handleId = handleId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public Long getUnit() {
        return unit;
    }

    public void setUnit(Long unit) {
        this.unit = unit;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }
    public BigDecimal getHandlePrice() {
        return handlePrice;
    }

    public void setHandlePrice(BigDecimal handlePrice) {
        this.handlePrice = handlePrice;
    }
    public BigDecimal getHandleNum() {
        return handleNum;
    }

    public void setHandleNum(BigDecimal handleNum) {
        this.handleNum = handleNum;
    }
    public BigDecimal getInStoreAvg() {
        return inStoreAvg;
    }

    public void setInStoreAvg(BigDecimal inStoreAvg) {
        this.inStoreAvg = inStoreAvg;
    }

    public BigDecimal getHandleMny() {
        return handleMny;
    }

    public void setHandleMny(BigDecimal handleMny) {
        this.handleMny = handleMny;
    }
    public BigDecimal getInStoreTaxMny() {
        return inStoreTaxMny;
    }

    public void setInStoreTaxMny(BigDecimal inStoreTaxMny) {
        this.inStoreTaxMny = inStoreTaxMny;
    }
    public BigDecimal getInStoreTax() {
        return inStoreTax;
    }

    public void setInStoreTax(BigDecimal inStoreTax) {
        this.inStoreTax = inStoreTax;
    }
    public BigDecimal getInStoreMny() {
        return inStoreMny;
    }

    public void setInStoreMny(BigDecimal inStoreMny) {
        this.inStoreMny = inStoreMny;
    }
    public BigDecimal getHandleSubTaxMny() {
        return handleSubTaxMny;
    }

    public void setHandleSubTaxMny(BigDecimal handleSubTaxMny) {
        this.handleSubTaxMny = handleSubTaxMny;
    }
    public BigDecimal getHandleSubMny() {
        return handleSubMny;
    }

    public void setHandleSubMny(BigDecimal handleSubMny) {
        this.handleSubMny = handleSubMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
