package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.store.bean.SettleDetailEntity;
/**
 * 废旧物资对账结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_settle")
public class SettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="apply_date")
    private Date applyDate; // 申请日期
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方单位id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方单位name
    @TableField(value="settle_date")
    private Date settleDate; // 对账日期
    @TableField(value="contract_id")
    private Long contractId; // 合同名称id
    @TableField(value="contract_name")
    private String contractName; // 合同名称name
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="current_settle_mny")
    private BigDecimal currentSettleMny; // 对账日期
    @TableField(value="sum_settle_mny")
    private BigDecimal sumSettleMny; // 累计对账金额(含本期)
    @TableField(value="last_sum_settle_mny")
    private BigDecimal lastSumSettleMny; // 上期累计对账金额



    @TableField(exist=false)
    @SubEntity(serviceName="settleDetailService",pidName="mid")
    private List<SettleDetailEntity> settleDetailList = new ArrayList<>(); // 废旧物资对账结算-子表

    public BigDecimal getLastSumSettleMny() {
        return lastSumSettleMny;
    }

    public void setLastSumSettleMny(BigDecimal lastSumSettleMny) {
        this.lastSumSettleMny = lastSumSettleMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public BigDecimal getCurrentSettleMny() {
        return currentSettleMny;
    }

    public void setCurrentSettleMny(BigDecimal currentSettleMny) {
        this.currentSettleMny = currentSettleMny;
    }
    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }
    

    public List<SettleDetailEntity> getSettleDetailList() {
        return settleDetailList;
    }

    public void setSettleDetailList(List<SettleDetailEntity> settleDetailList) {
        this.settleDetailList = settleDetailList;
    }
}
