package com.ejianc.business.store.controller;

import java.io.ByteArrayInputStream;
import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.store.bean.*;
import com.ejianc.business.store.service.ICheckDetailService;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.vo.CheckVO;
import com.ejianc.business.store.vo.SettleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.store.service.IPdallService;
import com.ejianc.business.store.vo.PdallVO;

/**
 * 盘点汇总表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pdall")
public class PdallController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPdallService service;
    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PdallVO> saveOrUpdate(@RequestBody PdallVO saveOrUpdateVO) {

        PdallVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PdallVO> queryDetail(Long id) {
    	PdallEntity entity = service.selectById(id);
    	PdallVO vo = BeanMapper.map(entity, PdallVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail 根据盘点单id查询子表详情
     */
    @RequestMapping(value = "/getListById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<PdallDetailEntity>> getListById(@RequestBody List<Long> checkIds) {

        LambdaQueryWrapper<CheckDetailEntity> lambdaQueryWrapper = new LambdaQueryWrapper<>();
        lambdaQueryWrapper.in(CheckDetailEntity::getCheckId,checkIds);
        List<CheckDetailEntity> checkDetailEntities = checkDetailService.list(lambdaQueryWrapper);
        ArrayList<PdallDetailEntity> pdallDetailEntities = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(checkDetailEntities)){
            Map<Long, List<CheckDetailEntity>> map = checkDetailEntities.stream().collect(
                    Collectors.groupingBy(
                            s -> s.getMaterialCategoryId()
                    ));
            map.forEach((key,value) ->{
                PdallDetailEntity pdallDetailEntity = new PdallDetailEntity();
                CheckDetailEntity checkDetailEntity = value.stream().findFirst().get();
                pdallDetailEntity.setMaterialCategoryId(checkDetailEntity.getMaterialCategoryId());
                pdallDetailEntity.setMaterialCategoryName(checkDetailEntity.getMaterialCategoryName());
                pdallDetailEntity.setMaterialCategoryCode(checkDetailEntity.getCategoryCode());
                BigDecimal beginMny = value.stream().map(CheckDetailEntity::getBeginMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setBeginMny(beginMny);
                BigDecimal inMny = value.stream().map(CheckDetailEntity::getInMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInMny(inMny);
                BigDecimal inStoreMny = value.stream().map(CheckDetailEntity::getInStoreMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInStoreMny(inStoreMny);
                BigDecimal outStoreMny = value.stream().map(CheckDetailEntity::getOutStoreMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setOutStoreMny(outStoreMny);
                BigDecimal outMny = value.stream().map(CheckDetailEntity::getOutMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setOutMny(outMny);
                BigDecimal accAmount = value.stream().map(CheckDetailEntity::getAccAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setAccAmount(accAmount);
                BigDecimal checkMny = value.stream().map(CheckDetailEntity::getCheckMny).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setCheckMny(checkMny);
                BigDecimal inventory = value.stream().map(CheckDetailEntity::getInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                pdallDetailEntity.setInventory(inventory);
                pdallDetailEntities.add(pdallDetailEntity);

            });

        }
        return CommonResponse.success("查询详情数据成功！",pdallDetailEntities);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PdallVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PdallVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PdallVO::getId).collect(Collectors.toList()),true);
        service.deleteCheckId(vos.stream().map(PdallVO::getId).collect(Collectors.toList()));

        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PdallVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PdallEntity> page = service.queryPage(param,false);
        IPage<PdallVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PdallVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PdallEntity> list = service.queryList(param);
        List<PdallVO> checkVOs = BeanMapper.mapList(list, PdallVO.class);
        checkVOs.forEach(item->{
            item.setBillStateName(BillStateEnum.getEnumByStateCode(item.getBillState()).getDescription());
        });
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Pdall-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPdallData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PdallVO>> refPdallData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.containsKey("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        IPage<PdallEntity> page = service.queryPage(param,false);
        IPage<PdallVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PdallVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
