package com.ejianc.business.store.service.handler;


import com.ejianc.business.store.consts.InOutTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 仓库管理公共服务工厂
 * @date 2022/1/24
 */
@Component
public class StoreManageFactory {

    @Autowired
    private Map<String, IStoreManageHandler> handlerMap;

    /**
     * @description: 获取出入库类型处理器
     * @return: com.ejianc.business.store.service.IStoreManage
     * @author songlx
     * @date: 2022/1/25
     */
    public IStoreManageHandler getHandler(InOutTypeEnum inOutTypeEnum) {
        if (
                InOutTypeEnum.收料入库.equals(inOutTypeEnum)
                        || InOutTypeEnum.调拨入库.equals(inOutTypeEnum)
                        || InOutTypeEnum.盘盈入库.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("inStoreHandler");
        } else if (
                InOutTypeEnum.领料出库.equals(inOutTypeEnum)
                        || InOutTypeEnum.调拨出库.equals(inOutTypeEnum)
                        || InOutTypeEnum.盘亏出库.equals(inOutTypeEnum)
                        || InOutTypeEnum.材料处置.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("outStoreHandler");
        } else if (
                InOutTypeEnum.直入直出入库.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("straightInOutStoreHandler");
        } else if (
                InOutTypeEnum.领料退库.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("backStoreHandler");
        } else if (
                InOutTypeEnum.材料退货.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("backGoodsHandler");
        } else if (
                InOutTypeEnum.周转材收料入库.equals(inOutTypeEnum)
                        || InOutTypeEnum.周转材调拨入库.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("turnInStoreHandler");
        } else if (
                InOutTypeEnum.周转材调拨出库.equals(inOutTypeEnum)
                        || InOutTypeEnum.周转材材料处置.equals(inOutTypeEnum)
        ) {
            return handlerMap.get("turnOutStoreHandler");
        }
        return null;
    }

}
