package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.ApplyDetailEntity;
import com.ejianc.business.store.bean.DefinitionDetailEntity;
import com.ejianc.business.store.bean.DefinitionEntity;
import com.ejianc.business.store.service.IDefinitionService;
import com.ejianc.business.store.vo.DefinitionDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("definition") 
public class DefinitionBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IDefinitionService definitionService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		DefinitionEntity entity = definitionService.selectById(billId);
		//校验要撤回的单据待处理数量是否够撤回
		List<DefinitionDetailEntity> detailList = entity.getDefinitionDetailList();
		if (CollectionUtils.isNotEmpty(detailList)) {
			QueryParam param = new QueryParam();
			param.setPageIndex(1);
			param.setPageSize(-1);
			param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
			param.getParams().put("checkNum", new Parameter(QueryParam.GT, 0));
			IPage<DefinitionDetailVO> pageData = new Page<>(param.getPageIndex(), param.getPageSize());
			pageData = definitionService.queryDetailPageData(pageData, param, entity.getProjectId());
			Map<Long, BigDecimal> surMap = pageData.getRecords().stream().filter(item->null!=item.getCheckNum())
					.collect(Collectors.groupingBy(DefinitionDetailVO::getMaterialId, Collectors.reducing(BigDecimal.ZERO, DefinitionDetailVO::getCheckNum, BigDecimal::add)));
			Map<Long, BigDecimal> oldDetailMap = detailList.stream().filter(item->null!=item.getCheckNum())
					.collect(Collectors.groupingBy(DefinitionDetailEntity::getMaterialId, Collectors.reducing(BigDecimal.ZERO, DefinitionDetailEntity::getCheckNum, BigDecimal::add)));
			for (DefinitionDetailEntity definitionDetailEntity : detailList) {
				if (null==surMap.get(definitionDetailEntity.getMaterialId())
						|| ComputeUtil.isGreaterThan(oldDetailMap.get(definitionDetailEntity.getMaterialId()),surMap.get(definitionDetailEntity.getMaterialId()))){
					throw new BusinessException("物资【"+definitionDetailEntity.getMaterialName()+"】,鉴定后待处理数量不足，无法撤回！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
