/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.ApplyDetailEntity;
import com.ejianc.business.store.bean.ApplyEntity;
import com.ejianc.business.store.service.IApplyDetailService;
import com.ejianc.business.store.service.IApplyService;
import com.ejianc.business.store.service.IDefinitionService;
import com.ejianc.business.store.vo.ApplyVO;
import com.ejianc.business.store.vo.DefinitionDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"apply"})
public class ApplyController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_APPLY";
    @Autowired
    private IApplyService service;
    @Autowired
    private IApplyDetailService detailService;
    @Autowired
    private IDefinitionService definitionService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApplyVO> saveOrUpdate(@RequestBody ApplyVO saveOrUpdateVO) {
        List<ApplyDetailEntity> detailList;
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(entity.getProjectName() + "-" + (String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        Map<Object, Object> oldDetailMap = new HashMap();
        if (null != entity.getId()) {
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"mid", (Object)entity.getId());
            List oldDetailList = this.detailService.list((Wrapper)qw);
            oldDetailMap = oldDetailList.stream().filter(item -> null != item.getDisposeNum()).collect(Collectors.groupingBy(ApplyDetailEntity::getMaterialId, Collectors.reducing(BigDecimal.ZERO, ApplyDetailEntity::getDisposeNum, BigDecimal::add)));
        }
        if (CollectionUtils.isNotEmpty(detailList = entity.getApplyDetailList())) {
            Map<Long, BigDecimal> detailMap = detailList.stream().filter(item -> !"del".equals(item.getRowState()) && null != item.getDisposeNum()).collect(Collectors.groupingBy(ApplyDetailEntity::getMaterialId, Collectors.reducing(BigDecimal.ZERO, ApplyDetailEntity::getDisposeNum, BigDecimal::add)));
            QueryParam param = new QueryParam();
            param.setPageIndex(1);
            param.setPageSize(-1);
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            param.getParams().put("checkNum", new Parameter("gt", (Object)0));
            IPage<DefinitionDetailVO> pageData = new IPage<DefinitionDetailVO>((long)param.getPageIndex(), (long)param.getPageSize());
            pageData = this.definitionService.queryDetailPageData(pageData, param, entity.getProjectId());
            Map<Long, BigDecimal> surMap = pageData.getRecords().stream().filter(item -> null != item.getCheckNum()).collect(Collectors.groupingBy(DefinitionDetailVO::getMaterialId, Collectors.reducing(BigDecimal.ZERO, DefinitionDetailVO::getCheckNum, BigDecimal::add)));
            for (ApplyDetailEntity applyDetailEntity : detailList) {
                BigDecimal surNum = surMap.get(applyDetailEntity.getMaterialId());
                BigDecimal detailNum = detailMap.get(applyDetailEntity.getMaterialId());
                BigDecimal oldNum = ComputeUtil.nullToZero((BigDecimal)((BigDecimal)oldDetailMap.get(applyDetailEntity.getMaterialId())));
                if (!ComputeUtil.isLessThan((BigDecimal)ComputeUtil.safeAdd((BigDecimal)surNum, (BigDecimal)oldNum), (BigDecimal)detailNum)) continue;
                throw new BusinessException("\u7269\u8d44\u3010" + applyDetailEntity.getMaterialName() + "\u3011,\u5269\u4f59\u5f85\u5904\u7406\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\uff01");
            }
        }
        entity.setUseFlag(0);
        this.service.saveOrUpdate((Object)entity, false);
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApplyVO> queryDetail(Long id) {
        ApplyEntity entity = (ApplyEntity)((Object)this.service.selectById(id));
        ApplyVO vo = (ApplyVO)BeanMapper.map((Object)((Object)entity), ApplyVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ApplyVO applyVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "parentOrgName", "supplierName", "billCode", "supLinkman", "supPhone"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "parentOrgName", "supplierName", "billCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Apply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refApplyData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ApplyVO>> refApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
            }
        }
        param.getParams().put("useFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        IPage page = this.service.queryPage(param, false);
        List ids = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper dlw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)dlw.eq(BaseEntity::getDr, (Object)0)).in(ApplyDetailEntity::getMid, ids);
            List list = this.detailService.list((Wrapper)dlw);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Map<Long, List<ApplyDetailEntity>> detailMap = list.stream().collect(Collectors.groupingBy(ApplyDetailEntity::getMid));
                for (ApplyEntity record : page.getRecords()) {
                    record.setApplyDetailList(detailMap.get(record.getId()));
                }
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ApplyVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

