/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.store.bean.ApplyEntity;
import com.ejianc.business.store.bean.DisposeDetailEntity;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.service.IApplyService;
import com.ejianc.business.store.service.IDisposeDetailService;
import com.ejianc.business.store.service.IDisposeService;
import com.ejianc.business.store.vo.DisposeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dispose"})
public class DisposeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "STORE_DISPOSE";
    @Autowired
    private IDisposeService service;
    @Autowired
    private IApplyService applyService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDisposeDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DisposeVO> saveOrUpdate(@RequestBody DisposeVO saveOrUpdateVO) {
        DisposeEntity entity = (DisposeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, DisposeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(entity.getProjectName() + "-" + (String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setUseFlag(0);
        List<Long> applyIds = null;
        if (CollUtil.isNotEmpty(entity.getDisposeDetailList())) {
            applyIds = entity.getDisposeDetailList().stream().filter(e -> !"del".equals(e.getRowState())).map(DisposeDetailEntity::getApplyId).collect(Collectors.toList());
            LambdaQueryWrapper aqw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)aqw.in(ApplyEntity::getDisposeId, applyIds)).eq(BaseEntity::getDr, (Object)0);
            List list = this.applyService.list((Wrapper)aqw);
            for (ApplyEntity applyEntity : list) {
                if (applyEntity.getBillState() != 1 || applyEntity.getBillState() != 3) {
                    throw new BusinessException("\u5b50\u8868\u542b\u5df2\u88ab\u64a4\u56de\u7684\u7533\u8bf7\u5355\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\uff01");
                }
                if (applyEntity.getUseFlag() == 0 || applyEntity.getDisposeId() == entity.getId()) continue;
                throw new BusinessException("\u5b50\u8868\u542b\u5df2\u88ab\u5f15\u7528\u7684\u7533\u8bf7\u5355\uff0c\u8bf7\u91cd\u65b0\u5236\u5355\uff01");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        this.service.updateApply(entity.getId(), applyIds);
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DisposeVO> queryDetail(Long id) {
        DisposeEntity entity = (DisposeEntity)((Object)this.service.selectById(id));
        DisposeVO vo = (DisposeVO)BeanMapper.map((Object)((Object)entity), DisposeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DisposeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DisposeVO vo : vos) {
                this.service.updateApply(vo.getId(), null);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "employeeName", "supplierName", "billCode"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DisposeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("projectName", "parentOrgName", "supplierName", "billCode"));
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("Dispose-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDisposeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DisposeVO>> refDisposeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter("eq", (Object)_con.getLong("projectId")));
            }
        }
        param.getParams().put("useFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        IPage page = this.service.queryPage(param, false);
        List ids = page.getRecords().stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaQueryWrapper dlw = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)dlw.eq(BaseEntity::getDr, (Object)0)).in(DisposeDetailEntity::getMid, ids);
            List list = this.detailService.list((Wrapper)dlw);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                Map<Long, List<DisposeDetailEntity>> detailMap = list.stream().collect(Collectors.groupingBy(DisposeDetailEntity::getMid));
                for (DisposeEntity record : page.getRecords()) {
                    record.setDisposeDetailList(detailMap.get(record.getId()));
                }
            }
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DisposeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/disposeReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> disposeReport(@RequestBody QueryParam param) {
        JSONObject result = this.service.disposeReport(param);
        return CommonResponse.success((Object)result);
    }

    @RequestMapping(value={"/disposeReportExport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> disposeReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        JSONObject result = this.service.disposeReport(param);
        HashMap<String, JSONArray> beans = new HashMap<String, JSONArray>();
        beans.put("records", result.getJSONArray("records"));
        ExcelExport.getInstance().export("dispose-detail-report-export.xlsx", beans, response);
        return CommonResponse.success((Object)result);
    }
}

