/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.store.service.impl;

import com.ejianc.business.promaterial.order.api.IOrderApi;
import com.ejianc.business.promaterial.order.vo.WriteBackVO;
import com.ejianc.business.store.bean.ReturnGoodsEntity;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.service.IReturnGoodsService;
import com.ejianc.business.store.service.StoreManageService;
import com.ejianc.business.store.vo.ReturnGoodsVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="returnGoods")
public class ReturnGoodsBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IReturnGoodsService returnGoodsService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IOrderApi orderApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        ReturnGoodsVO returnGoodsVO = (ReturnGoodsVO)BeanMapper.map((Object)((Object)entity), ReturnGoodsVO.class);
        if (returnGoodsVO != null && returnGoodsVO.getReturnGoodsDetailList().size() > 0) {
            StoreManageVO storeManageVO = returnGoodsVO.getStoreManageVO(returnGoodsVO);
            this.storeManageService.inOutStore(storeManageVO);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getReduceType())) {
            Map<Long, BigDecimal> numMap = entity.getReturnGoodsDetailList().stream().collect(Collectors.toMap(x -> x.getMaterialId(), x -> ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)x.getReturnNum())));
            WriteBackVO vo = new WriteBackVO();
            vo.setReduceType(entity.getReduceType());
            vo.setCheckId(entity.getCheckId());
            vo.setOrderId(entity.getOrderId());
            vo.setNumMap(numMap);
            CommonResponse response = this.orderApi.writeBackOccupyNum(vo);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null) {
            CommonResponse commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getOutDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5355\u636e\u5f02\u5e38\uff0c\u5f03\u5ba1\u5931\u8d25");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ReturnGoodsEntity entity = (ReturnGoodsEntity)((Object)this.returnGoodsService.selectById(billId));
        if (entity != null && entity.getReturnGoodsDetailList().size() > 0) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6750\u6599\u9000\u8d27);
            ArrayList<Long> longs = new ArrayList<Long>();
            longs.add(entity.getId());
            storeManageVO.setSourceIdsForRollBack(longs);
            this.storeManageService.inOutStoreRollback(storeManageVO);
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getReduceType())) {
            Map<Long, BigDecimal> numMap = entity.getReturnGoodsDetailList().stream().collect(Collectors.toMap(x -> x.getMaterialId(), x -> x.getReturnNum()));
            WriteBackVO vo = new WriteBackVO();
            vo.setReduceType(entity.getReduceType());
            vo.setCheckId(entity.getCheckId());
            vo.setOrderId(entity.getOrderId());
            vo.setNumMap(numMap);
            CommonResponse response = this.orderApi.writeBackOccupyNum(vo);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }
}

