package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.store.bean.AllotInDetailEntity;
/**
 * 调拨入库
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_allot_in")
public class AllotInEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="allot_out_id")
    private Long allotOutId; // 调拨入库id
    @TableField(value="project_id")
    private Long projectId; // 出库项目id
    @TableField(value="project_name")
    private String projectName; // 入库项目名称
    @TableField(value="org_id")
    private Long orgId; // 入库组织id
    @TableField(value="org_name")
    private String orgName; // 入库组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="store_id")
    private Long storeId; // 入库仓库id
    @TableField(value="store_name")
    private String storeName; // 入库仓库名称
    @TableField(value="out_date")
    private Date outDate; // 调出的时间
    @TableField(value="out_mny")
    private BigDecimal outMny; // 调出金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 调出金额
    @TableField(value="allocat_type")
    private Integer allocatType; // 调拨方式 1 资产盘活 2 自制
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="out_project_id")
    private Long outProjectId; // 调出项目id
    @TableField(value="out_project_name")
    private String outProjectName; // 调出项目名称
    @TableField(value="out_org_id")
    private Long outOrgId; // 调出组织id
    @TableField(value="out_org_name")
    private String outOrgName; // 调出组织名称
    @TableField(value="material_names")
    private String materialNames; // 出库物资名称集合
    @TableField(value="notify_receiver_id")
    private Long notifyReceiverId; // 通知收料状人id
    @TableField(value="receiver_name")
    private String receiverName; // 调入组织收料状人
    @TableField(value="receiver_person_id")
    private String receiverPersonId; // 收料人id
    @TableField(value="receiver_person")
    private String receiverPerson; // 收料人
    @TableField(value="receive_date")
    private Date receiveDate; // 收料时间
    @TableField(value="pass_date")
    private Date passDate; // 通过时间
    @TableField(value="return_reason")
    private String returnReason; // 退回原因
    @TableField(value="receive_state")
    private Integer receiveState; // 收料状态 1、待收；2、已收；3、退回
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="out_store_id")
    private Long outStoreId; // 出库id
    @TableField(value="out_store_name")
    private String outStoreName; // 出库名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="allotInDetailService",pidName ="allocatId")
    private List<AllotInDetailEntity> allotInDetailList = new ArrayList<>(); // 调拨入库子表


    @TableField(value="org_code")
    private String orgCode; // 项目组织编码


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getAllotOutId() {
        return allotOutId;
    }

    public void setAllotOutId(Long allotOutId) {
        this.allotOutId = allotOutId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public Integer getAllocatType() {
        return allocatType;
    }

    public void setAllocatType(Integer allocatType) {
        this.allocatType = allocatType;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getOutProjectId() {
        return outProjectId;
    }

    public void setOutProjectId(Long outProjectId) {
        this.outProjectId = outProjectId;
    }
    public String getOutProjectName() {
        return outProjectName;
    }

    public void setOutProjectName(String outProjectName) {
        this.outProjectName = outProjectName;
    }
    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }
    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }
    public String getMaterialNames() {
        return materialNames;
    }

    public void setMaterialNames(String materialNames) {
        this.materialNames = materialNames;
    }
    public Long getNotifyReceiverId() {
        return notifyReceiverId;
    }

    public void setNotifyReceiverId(Long notifyReceiverId) {
        this.notifyReceiverId = notifyReceiverId;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverPersonId() {
        return receiverPersonId;
    }

    public void setReceiverPersonId(String receiverPersonId) {
        this.receiverPersonId = receiverPersonId;
    }

    public String getReceiverPerson() {
        return receiverPerson;
    }

    public void setReceiverPerson(String receiverPerson) {
        this.receiverPerson = receiverPerson;
    }

    public Date getReceiveDate() {
        return receiveDate;
    }

    public void setReceiveDate(Date receiveDate) {
        this.receiveDate = receiveDate;
    }

    public Date getPassDate() {
        return passDate;
    }

    public void setPassDate(Date passDate) {
        this.passDate = passDate;
    }

    public String getReturnReason() {
        return returnReason;
    }

    public void setReturnReason(String returnReason) {
        this.returnReason = returnReason;
    }

    public Integer getReceiveState() {
        return receiveState;
    }

    public void setReceiveState(Integer receiveState) {
        this.receiveState = receiveState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getOutStoreId() {
        return outStoreId;
    }

    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    

    public List<AllotInDetailEntity> getAllotInDetailList() {
        return allotInDetailList;
    }

    public void setAllotInDetailList(List<AllotInDetailEntity> allotInDetailList) {
        this.allotInDetailList = allotInDetailList;
    }
}
