package com.ejianc.business.store.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.store.bean.ApplyDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 废旧物资处置申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_store_apply")
public class ApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织
    @TableField(value="org_code")
    private String orgCode; // 所属组织编码
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="employee_id")
    private Long employeeId; // 业务经办人ID
    @TableField(value="employee_name")
    private String employeeName; // 业务经办人名称
    @TableField(value="apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 所属组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方单位id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方单位name
    @TableField(value="sup_phone")
    private String supPhone; // 乙方电话
    @TableField(value="sup_linkman")
    private String supLinkman; // 乙方联系人
    @TableField(value="start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 处理开始时间
    @TableField(value="end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 处理结束时间
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="applyDetailService",pidName = "mid")
    private List<ApplyDetailEntity> applyDetailList = new ArrayList<>(); // 废旧物资处置申请-子表

    @TableField(value="use_flag")
    private Integer useFlag; //引用状态, 0-未引用,1-已引用
    @TableField(value="dispose_id")
    private Long disposeId; //处置明细id

    @TableField(value = "exec_contract_flag")
    private String execContractFlag; //是否执行合同：0-否，1-是
    @TableField(value = "contract_id")
    private Long contractId; //处置合同Id
    @TableField(value = "contract_code")
    private String contractCode; //处置合同编码
    @TableField(value = "contract_name")
    private String contractName; //处置合同名称
    @TableField(value = "no_exc_reason")
    private String noExecReason; //不执行原因

    public String getExecContractFlag() {
        return execContractFlag;
    }

    public void setExecContractFlag(String execContractFlag) {
        this.execContractFlag = execContractFlag;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getNoExecReason() {
        return noExecReason;
    }

    public void setNoExecReason(String noExecReason) {
        this.noExecReason = noExecReason;
    }

    public Integer getUseFlag() {
        return useFlag;
    }

    public void setUseFlag(Integer useFlag) {
        this.useFlag = useFlag;
    }

    public Long getDisposeId() {
        return disposeId;
    }

    public void setDisposeId(Long disposeId) {
        this.disposeId = disposeId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupPhone() {
        return supPhone;
    }

    public void setSupPhone(String supPhone) {
        this.supPhone = supPhone;
    }
    public String getSupLinkman() {
        return supLinkman;
    }

    public void setSupLinkman(String supLinkman) {
        this.supLinkman = supLinkman;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    

    public List<ApplyDetailEntity> getApplyDetailList() {
        return applyDetailList;
    }

    public void setApplyDetailList(List<ApplyDetailEntity> applyDetailList) {
        this.applyDetailList = applyDetailList;
    }
}
