package com.ejianc.business.store.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 仓库库存存量表
 *
 * @author generator
 */
@TableName("ejc_store_surplus")
public class SurplusEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="parent_org_id")
    private Long parentOrgId; // 所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 所属组织名称

    @TableField(value = "org_id")
    private Long orgId; // 所属组织
    @TableField(value = "org_name")
    private String orgName; // 所属组织名称
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "store_id")
    private Long storeId; // 仓库
    @TableField(value = "store_name")
    private String storeName; // 仓库名称
    @TableField(value = "material_type")
    private String materialType; // 材料类型编码
    @TableField(value = "material_type_name")
    private String materialTypeName; // 材料类型名称
    @TableField(value = "material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value = "material_category_code")
    private String materialCategoryCode; // 物资分类编码
    @TableField(value = "material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value = "material_id")
    private Long materialId; // 物资id
    @TableField(value = "material_code")
    private String materialCode; // 物资编码
    @TableField(value = "material_name")
    private String materialName; // 物资名称
    @TableField(value = "material_inner_code")
    private String materialInnerCode; // 物资内码
    @TableField(value = "material_spec")
    private String materialSpec; // 规格型号
    @TableField(value = "material_unit_id")
    private Long materialUnitId; // 计量单位id
    @TableField(value = "material_unit_name")
    private String materialUnitName; // 计量单位
    @TableField(value = "surplus_mny")
    private BigDecimal surplusMny; // 库存余额(无税)
    @TableField(value = "surplus_tax_mny")
    private BigDecimal surplusTaxMny; // 库存余额
    @TableField(value = "surplus_num")
    private BigDecimal surplusNum; // 库存余量
    @TableField(value = "instore_mny")
    private BigDecimal instoreMny; // 入库金额(无税)
    @TableField(value = "instore_tax_mny")
    private BigDecimal instoreTaxMny; // 入库金额
    @TableField(value = "instore_num")
    private BigDecimal instoreNum; // 入库总量
    @TableField(value = "out_lock_num")
    private BigDecimal outLockNum; // 出库占用数量
    @TableField(value = "return_goods_num")
    private BigDecimal returnGoodsNum; //退货数量

    @TableField(value = "out_lock_mny")
    private BigDecimal outLockMny;
    @TableField(value = "out_lock_tax_mny")
    private BigDecimal outLockTaxMny;

    @TableField(value="use_type")
    private String useType; // 用途分类:消耗材/低值易耗品/小型工机具/临时设施


    public String getUseType() {
        return useType;
    }

    public void setUseType(String useType) {
        this.useType = useType;
    }

    public BigDecimal getOutLockMny() {
        return outLockMny;
    }

    public void setOutLockMny(BigDecimal outLockMny) {
        this.outLockMny = outLockMny;
    }

    public BigDecimal getOutLockTaxMny() {
        return outLockTaxMny;
    }

    public void setOutLockTaxMny(BigDecimal outLockTaxMny) {
        this.outLockTaxMny = outLockTaxMny;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public BigDecimal getReturnGoodsNum() {
        return returnGoodsNum;
    }

    public void setReturnGoodsNum(BigDecimal returnGoodsNum) {
        this.returnGoodsNum = returnGoodsNum;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }

    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }

    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getMaterialInnerCode() {
        return materialInnerCode;
    }

    public void setMaterialInnerCode(String materialInnerCode) {
        this.materialInnerCode = materialInnerCode;
    }

    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }

    public Long getMaterialUnitId() {
        return materialUnitId;
    }

    public void setMaterialUnitId(Long materialUnitId) {
        this.materialUnitId = materialUnitId;
    }

    public String getMaterialUnitName() {
        return materialUnitName;
    }

    public void setMaterialUnitName(String materialUnitName) {
        this.materialUnitName = materialUnitName;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public BigDecimal getSurplusTaxMny() {
        return surplusTaxMny;
    }

    public void setSurplusTaxMny(BigDecimal surplusTaxMny) {
        this.surplusTaxMny = surplusTaxMny;
    }

    public BigDecimal getSurplusNum() {
        return surplusNum;
    }

    public void setSurplusNum(BigDecimal surplusNum) {
        this.surplusNum = surplusNum;
    }

    public BigDecimal getInstoreMny() {
        return instoreMny;
    }

    public void setInstoreMny(BigDecimal instoreMny) {
        this.instoreMny = instoreMny;
    }

    public BigDecimal getInstoreTaxMny() {
        return instoreTaxMny;
    }

    public void setInstoreTaxMny(BigDecimal instoreTaxMny) {
        this.instoreTaxMny = instoreTaxMny;
    }

    public BigDecimal getInstoreNum() {
        return instoreNum;
    }

    public void setInstoreNum(BigDecimal instoreNum) {
        this.instoreNum = instoreNum;
    }

    public BigDecimal getOutLockNum() {
        return outLockNum;
    }

    public void setOutLockNum(BigDecimal outLockNum) {
        this.outLockNum = outLockNum;
    }

}
