package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.store.bean.CheckEntity;
import com.ejianc.business.store.service.ICheckService;
import com.ejianc.business.store.vo.PdallVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.PdallMapper;
import com.ejianc.business.store.bean.PdallEntity;
import com.ejianc.business.store.service.IPdallService;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 盘点汇总表
 * 
 * @author generator
 * 
 */
@Service("pdallService")
public class PdallServiceImpl extends BaseServiceImpl<PdallMapper, PdallEntity> implements IPdallService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICheckService checkService;

    private static final String BILL_CODE = "PDALL";//

    @Override
    public PdallVO saveOrUpdate(PdallVO saveOrUpdateVO) {
        PdallEntity entity = BeanMapper.map(saveOrUpdateVO, PdallEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        PdallVO vo = BeanMapper.map(entity, PdallVO.class);
        List<Long> checkIds = Arrays.stream(StringUtils.split(saveOrUpdateVO.getCheckId(), ",")).map(Long::parseLong).collect(Collectors.toList());
        this.updateCheck(entity.getId(), checkIds);
        return vo;
    }
    @Override
    public void deleteCheckId(List<Long> settleIds) {
        LambdaUpdateWrapper<CheckEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.in(CheckEntity::getPdallId, settleIds);
        wrapper.set(CheckEntity::getPdallId, null);
        wrapper.set(CheckEntity::getUseFlag, 0);
        checkService.update(wrapper);
    }


    @Override
    public void updateCheck(Long pdallId, List<Long> checkIds) {
        LambdaUpdateWrapper<CheckEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(CheckEntity::getPdallId, pdallId);
        wrapper.set(CheckEntity::getPdallId, null);
        wrapper.set(CheckEntity::getUseFlag, 0);
        checkService.update(wrapper);
        if (CollectionUtils.isNotEmpty(checkIds)) {
            LambdaUpdateWrapper<CheckEntity> lambda = new LambdaUpdateWrapper();
            lambda.in(CheckEntity::getId, checkIds);
            lambda.set(CheckEntity::getPdallId, pdallId);
            lambda.set(CheckEntity::getUseFlag,1);
            checkService.update(lambda);
        }
    }
}
