package com.ejianc.business.store.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.store.bean.DisposeEntity;
import com.ejianc.business.store.service.IDisposeService;
import com.ejianc.business.store.vo.SettleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.store.mapper.SettleMapper;
import com.ejianc.business.store.bean.SettleEntity;
import com.ejianc.business.store.service.ISettleService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 废旧物资对账结算
 * 
 * @author generator
 * 
 */
@Service("settleService")
public class SettleServiceImpl extends BaseServiceImpl<SettleMapper, SettleEntity> implements ISettleService{
    @Autowired
    private IDisposeService disposeService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "STORE_SETTLE";//此处需要根据实际修改

    @Override
    public void updateDispose(Long settleId, List<Long> disposeIds) {
        LambdaUpdateWrapper<DisposeEntity> wrapper = new LambdaUpdateWrapper();
        wrapper.eq(DisposeEntity::getSettleId, settleId);
        wrapper.set(DisposeEntity::getSettleId, null);
        wrapper.set(DisposeEntity::getUseFlag, 0);
        disposeService.update(wrapper);
        if (CollectionUtils.isNotEmpty(disposeIds)) {
            disposeIds.forEach(e -> {
                LambdaUpdateWrapper<DisposeEntity> lambda = new LambdaUpdateWrapper();
                lambda.eq(DisposeEntity::getId, e);
                lambda.set(DisposeEntity::getSettleId, settleId);
                lambda.set(DisposeEntity::getUseFlag,1);
                disposeService.update(lambda);
            });
        }
    }
    @Transactional
    @Override
    public SettleVO saveOrUpdate(SettleVO saveOrUpdateVO) {

        SettleEntity entity = BeanMapper.map(saveOrUpdateVO, SettleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        this.updateDispose(entity.getId(), saveOrUpdateVO.getDisposeIds());
        SettleVO vo = BeanMapper.map(entity, SettleVO.class);
        return vo;
    }

    @Override
    public void deleteDisposeId(List<Long> settleIds) {
        LambdaUpdateWrapper<DisposeEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.in(DisposeEntity::getSettleId, settleIds);
        wrapper.set(DisposeEntity::getSettleId, null);
        wrapper.set(DisposeEntity::getUseFlag, 0);
        disposeService.update(wrapper);
    }
}
