package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 分包零星用工表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
public class OddjobRecordDetailVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 零工单号
     */
    private String billCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 分包类型
     */
    private Long contractType;

    /**
     * 用工类型
     */
    private Long jobType;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 分包供应商
     */
    private Long supplierId;

    /**
     * 分包供应商名称
     */
    private String supplierName;

    /**
     * 开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 使用部位
     */
    private Long partUsed;

    /**
     * 零工总金额
     */
    private BigDecimal jobMny;

    /**
     * 零工总金额（含税）
     */
    private BigDecimal jobTaxMny;

    /**
     * 用工摘要
     */
    private String roundup;

    /**
     * 用工前图片
     */
    private String beforeUrls;

    /**
     * 用工后图片
     */
    private String afterUrls;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    private BigDecimal scale;
    /**
     * 零工结算金额（含税）
     */
    private BigDecimal oddjobSettleTaxMny;
    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }

    public BigDecimal getOddjobSettleTaxMny() {
        return oddjobSettleTaxMny;
    }

    public void setOddjobSettleTaxMny(BigDecimal oddjobSettleTaxMny) {
        this.oddjobSettleTaxMny = oddjobSettleTaxMny;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getContractType() {
        return contractType;
    }

    @ReferDeserialTransfer
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getJobType() {
        return jobType;
    }

    @ReferDeserialTransfer
    public void setJobType(Long jobType) {
        this.jobType = jobType;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPartUsed() {
        return partUsed;
    }

    @ReferDeserialTransfer
    public void setPartUsed(Long partUsed) {
        this.partUsed = partUsed;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    public void setJobTaxMny(BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    public String getRoundup() {
        return roundup;
    }

    public void setRoundup(String roundup) {
        this.roundup = roundup;
    }
    public String getBeforeUrls() {
        return beforeUrls;
    }

    public void setBeforeUrls(String beforeUrls) {
        this.beforeUrls = beforeUrls;
    }
    public String getAfterUrls() {
        return afterUrls;
    }

    public void setAfterUrls(String afterUrls) {
        this.afterUrls = afterUrls;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getScale() {
        return scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }
}
