package com.ejianc.business.sub.api;

import com.ejianc.business.sub.hystrix.SubContractForPayHystrix;
import com.ejianc.business.sub.vo.SubSettleVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 获取合同参照工厂类方法
 * 
 * @author yqls
 *
 */
@FeignClient(name= "ejc-sub-web", url="${common.env.feign-client-url}", path="ejc-sub-web", fallback = SubContractForPayHystrix.class)
public interface ISubContractForPayApi {

	/**
	 * 回写分包合同累计付款金额、累计预付款金额
	 * @param contractId
	 * @param payMny	本期支付金额，正为回写，负为逆回写
	 * @param prepayMny	本期支付金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/subForPay/updateSubContractSumPayMny")
	CommonResponse<String> updateSubContractSumPayMny(
			@RequestParam(value = "contractId", required = true) Long contractId,
			@RequestParam("payMny") BigDecimal payMny, @RequestParam("prepayMny") BigDecimal prepayMny);

	/**
	 * 回写分包结算单累计付款金额
	 * @param settleId 结算单id
	 * @param payMny 本期支付金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/subForPay/updateSubSettleSumPayMny")
	CommonResponse<String> updateSubSettleSumPayMny(
			@RequestParam(value = "settleId", required = true) Long settleId,
			@RequestParam("payMny") BigDecimal payMny);

	/**
	 * 回写分包结算单累计申请金额、剩余可申请金额
	 * @param settleId 结算单id
	 * @param applyMny 本期申请金额，正为回写，负为逆回写
	 * @return
	 */
	@GetMapping(value = "/api/subForPay/updateSubSettleSumApplyMny")
	CommonResponse<String> updateSubSettleSumApplyMny(
			@RequestParam(value = "settleId", required = true) Long settleId,
			@RequestParam("applyMny") BigDecimal applyMny);

	/**
	 * 根据条件查询结算单累计冲抵金额
	 * @return
	 */
	@GetMapping(value = "/api/subForPay/getSubSettleById")
	public CommonResponse<SubSettleVO> getSubSettleById(
			@RequestParam(value = "contractId", required = true) Long contractId,
			@RequestParam(value = "orgId", required = true) Long orgId);

}
