package com.ejianc.business.sub.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author zhangwx
 * @Date 2020/5/27 分包合同
 * @Description ContractVO
 */

public class CertificateRecordVO extends BaseVO {

    private static final long serialVersionUID = 2779265683203439571L;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 经办人名称
     */
    private String employeeName;
    private String billCode;
    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate;

    /**
     * 确认金额
     */
    private BigDecimal affirmMny;

    /**
     * 签证金额
     */
    private BigDecimal mny;

    /**
     * 分包合同总金额
     */
    private BigDecimal contractTaxMny;


    /**
     * 签证总金额
     */
    private BigDecimal totalMny;
    private BigDecimal totalRate;


    List<CertificateRecordVO> detailList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getTotalMny() {
        return totalMny;
    }

    public void setTotalMny(BigDecimal totalMny) {
        this.totalMny = totalMny;
    }

    public BigDecimal getTotalRate() {
        return totalRate;
    }

    public void setTotalRate(BigDecimal totalRate) {
        this.totalRate = totalRate;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public BigDecimal getAffirmMny() {
        return affirmMny;
    }

    public void setAffirmMny(BigDecimal affirmMny) {
        this.affirmMny = affirmMny;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public List<CertificateRecordVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CertificateRecordVO> detailList) {
        this.detailList = detailList;
    }
}
