package com.ejianc.business.sub.api;

import com.ejianc.business.sub.hystrix.SubContractHystrix;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.business.sub.vo.SubContractorContractVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@FeignClient(name = "ejc-sub-web", url = "${common.env.feign-client-url}", path = "ejc-sub-web", fallback = SubContractHystrix.class)
public interface ISubContractApi {
	@GetMapping(value = "/api/contract/fetchSjzcje")
	CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId);


	@PostMapping(value = "/api/contract/getContractByCondition")
	@ResponseBody
	CommonResponse<List<ContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds);


	@GetMapping(value = "/api/contract/getSettleVO")
	CommonResponse<SettleVO> getSettleVO(@RequestParam(value = "settleId") Long settleId);


	@GetMapping(value = "/api/contract/getSubContractorContractVO")
	CommonResponse<SubContractorContractVO> getSubContractorContractVO(@RequestParam(value = "supplierId") Long supplierId);



}
