package com.ejianc.business.sub.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: ListUtils
 * @date 2022/7/20
 */
public class ListSplitUtil {

    /**
     * @param list 要拆分的集合
     * @param subNum 每份的数量
     * @description: 将list拆成每份多少个
     * @return: java.util.List<java.util.List < T>>
     * @author songlx
     * @date: 2022/7/20
     */
    public static <T> List<List<T>> splistList(List<T> list, int subNum) {
        List<List<T>> tNewList = new ArrayList<>();
        int priIndex = 0;
        int lastPriIndex = 0;
        int insertTimes = list.size() / subNum;
        List<T> subList = new ArrayList<>();
        for (int i = 0; i <= insertTimes; i++) {
            priIndex = subNum * i;
            lastPriIndex = priIndex + subNum;
            if (i == insertTimes) {
                subList = list.subList(priIndex, list.size());
            } else {
                subList = list.subList(priIndex, lastPriIndex);
            }
            if (subList.size() > 0) {
                tNewList.add(subList);
            }
        }
        return tNewList;
    }


    public static void main(String[] args) {
        List<String> list = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9");
        List<List<String>> lists = splistList(list, 4);
        System.out.println(lists.size());
    }
}
