package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sub.vo.WorkerPresentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.WorkerPresentMapper;
import com.ejianc.business.sub.bean.WorkerPresentEntity;
import com.ejianc.business.sub.service.IWorkerPresentService;

/**
 * 工人在场统计
 * 
 * @author generator
 * 
 */
@Service("workerPresentService")
public class WorkerPresentServiceImpl extends BaseServiceImpl<WorkerPresentMapper, WorkerPresentEntity> implements IWorkerPresentService{

    @Autowired
    private WorkerPresentMapper workerPresentMapper;

    @Override
    public WorkerPresentVO checkWorkerPresent(Long projectId, Long supplierId, Long contractId) {
        WorkerPresentVO resp = null;
        QueryWrapper<WorkerPresentEntity> query = new QueryWrapper<>();
        query.eq("project_id", projectId);
        query.eq("supplier_id", supplierId);
        if(contractId != null){
            query.eq("contract_id", contractId);
        }else{
            query.isNull("contract_id");
        }
        query.eq("dr", BaseVO.DR_UNDELETE);
        //带上租户id
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        WorkerPresentEntity entity = workerPresentMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity,WorkerPresentVO.class);
        }
        return resp;
    }

    @Override
    public WorkerPresentVO checkCode(String billCode) {
        WorkerPresentVO resp = null;
        QueryWrapper<WorkerPresentEntity> query = new QueryWrapper<>();
        query.eq("bill_code", billCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
        //带上租户id
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        WorkerPresentEntity entity = workerPresentMapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity,WorkerPresentVO.class);
        }
        return resp;
    }
}
