/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.sub.bean.CertificateEntity;
import com.ejianc.business.sub.service.ICertificateService;
import com.ejianc.business.sub.vo.CertificateRecordVO;
import com.ejianc.business.sub.vo.CertificateVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"certificate"})
public class CertificateController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FBQZ";
    @Autowired
    private ICertificateService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CertificateVO> saveOrUpdate(@RequestBody CertificateVO saveOrUpdateVO) {
        CertificateEntity entity = (CertificateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CertificateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setImgFlag(0);
                entity.setSettleFlag(0);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CertificateVO vo = (CertificateVO)BeanMapper.map((Object)((Object)entity), CertificateVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertificateVO> queryDetail(Long id) {
        CertificateEntity entity = (CertificateEntity)((Object)this.service.selectById(id));
        CertificateVO vo = (CertificateVO)BeanMapper.map((Object)((Object)entity), CertificateVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/imgFlagStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> imgFlagStatus(Long id) {
        CertificateEntity entity = (CertificateEntity)((Object)this.service.selectById(id));
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(id, "BT240611000000001", "demo04", null);
        if (!listCommonResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u9644\u4ef6\u5f02\u5e38");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            entity.setImgFlag(1);
        } else {
            entity.setImgFlag(0);
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CertificateVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CertificateVO certificateVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List certificateVOS = BeanMapper.mapList((Iterable)page.getRecords(), CertificateVO.class);
        certificateVOS.stream().forEach(certificateVO -> certificateVO.setImgFlagStr(certificateVO.getImgFlag() == 1 ? "\u662f" : "\u5426"));
        pageData.setRecords(certificateVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List certificateVOS = BeanMapper.mapList((Iterable)list, CertificateVO.class);
        certificateVOS.stream().forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setImgFlagStr(vo.getImgFlag() == 1 ? "\u662f" : "\u5426");
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", certificateVOS);
        ExcelExport.getInstance().export("Certificate-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCertificateData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CertificateVO>> refCertificateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("settleFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getOrderMap().put("createTime", "desc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"includeIds")) {
                ArrayList<String> includeIds = new ArrayList<String>(Arrays.asList(_con.getString("includeIds").split(",")));
                param.getParams().put("id", new Parameter("not_in", includeIds));
            }
            if (_con.containsKey((Object)"contractId")) {
                param.getParams().put("contractId", new Parameter("eq", (Object)_con.getLong("contractId")));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CertificateVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CertificateRecordVO> queryDetailRecord(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)id);
        queryWrapper.in((Object)"bill_state", new ArrayList<Integer>(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = this.service.list((Wrapper)queryWrapper);
        CertificateRecordVO certificateRecord = new CertificateRecordVO();
        ArrayList<CertificateRecordVO> certificateRecordList = new ArrayList<CertificateRecordVO>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal totalMny = BigDecimal.ZERO;
            for (CertificateEntity cert : list) {
                CertificateRecordVO vo = new CertificateRecordVO();
                vo.setContractId(cert.getContractId());
                vo.setEmployeeName(cert.getApplyUserName());
                vo.setContractTaxMny(cert.getContractMny());
                vo.setMny(cert.getMny());
                vo.setAffirmMny(cert.getAffirmMny());
                vo.setBillCode(cert.getBillCode());
                vo.setId(cert.getId());
                vo.setCreateDate(cert.getCreateTime());
                certificateRecordList.add(vo);
                totalMny = MathUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)cert.getAffirmMny());
            }
            certificateRecord.setDetailList(certificateRecordList);
            certificateRecord.setContractId(id);
            certificateRecord.setContractTaxMny(((CertificateEntity)((Object)list.get(0))).getContractMny());
            certificateRecord.setTotalMny(totalMny);
            BigDecimal decimal = MathUtil.safeDiv((BigDecimal)certificateRecord.getTotalMny(), (BigDecimal)certificateRecord.getContractTaxMny());
            BigDecimal decimal1 = MathUtil.safeMultiply((BigDecimal)decimal, (BigDecimal)new BigDecimal(100));
            decimal1.setScale(2, 4);
            certificateRecord.setTotalRate(decimal1);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)certificateRecord);
    }
}

