/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IDeductionApi;
import com.ejianc.business.finance.vo.DeductionVO;
import com.ejianc.business.sub.bean.LabSettleCertificateEntity;
import com.ejianc.business.sub.bean.LabSettleDeductEntity;
import com.ejianc.business.sub.bean.LabSettleDetailEntity;
import com.ejianc.business.sub.bean.LabSettleEntity;
import com.ejianc.business.sub.service.ICertificateService;
import com.ejianc.business.sub.service.ILabSettleDetailService;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.LabSettleCertificateVO;
import com.ejianc.business.sub.vo.LabSettleDetailVO;
import com.ejianc.business.sub.vo.LabSettleRecordVo;
import com.ejianc.business.sub.vo.LabSettleVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"labSettle"})
public class LabSettleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LWJS";
    @Autowired
    private ILabSettleService service;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    private ILabSettleDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDeductionApi deductionApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LabSettleVO> saveOrUpdate(@RequestBody LabSettleVO saveOrUpdateVO) {
        List<LabSettleDetailEntity> beforeDetails;
        LabSettleEntity entity;
        List certificateList;
        if (this.checkUnEffectSettle(saveOrUpdateVO).booleanValue()) {
            throw new BusinessException("\u4e00\u4e2a\u5408\u540c\u53ea\u505a\u4e00\u4e2a\u52b3\u52a1\u7ed3\u7b97\u5355!");
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getCertificateList())) {
            certificateList = saveOrUpdateVO.getCertificateList();
            ArrayList<Long> ids = new ArrayList<Long>();
            ArrayList<Long> delIds = new ArrayList<Long>();
            for (LabSettleCertificateVO certificate : certificateList) {
                if (certificate.getRowState() != null && !certificate.getRowState().equals("del")) {
                    ids.add(certificate.getSourceId());
                    continue;
                }
                if (certificate.getRowState() == null || !certificate.getRowState().equals("del")) continue;
                delIds.add(certificate.getSourceId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                this.certificateService.settleFlag(ids, 1);
            }
            if (CollectionUtils.isNotEmpty(delIds)) {
                this.certificateService.settleFlag(delIds, 0);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getDeductList())) {
            certificateList = saveOrUpdateVO.getDeductList();
            ArrayList<DeductionVO> list = new ArrayList<DeductionVO>();
            ArrayList<DeductionVO> delList = new ArrayList<DeductionVO>();
            for (LabSettleCertificateVO certificate : certificateList) {
                DeductionVO deductionVO;
                if (certificate.getRowState() != null && !certificate.getRowState().equals("del")) {
                    deductionVO = new DeductionVO();
                    deductionVO.setId(certificate.getSettleId());
                    deductionVO.setSettleFlag(Integer.valueOf(1));
                    list.add(deductionVO);
                    continue;
                }
                if (certificate.getRowState() == null || !certificate.getRowState().equals("del")) continue;
                deductionVO = new DeductionVO();
                deductionVO.setId(certificate.getSettleId());
                deductionVO.setSettleFlag(Integer.valueOf(0));
                delList.add(deductionVO);
            }
            if (CollectionUtils.isNotEmpty(list)) {
                this.deductionApi.settleFlag(list);
            }
            if (CollectionUtils.isNotEmpty(delList)) {
                this.deductionApi.settleFlag(delList);
            }
        }
        if ((entity = (LabSettleEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LabSettleEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = entity.getDetailList()) && null == entity.getId()) {
            for (LabSettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<LabSettleDetailEntity> finishDetailEntities = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(finishDetailEntities)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (LabSettleDetailEntity cdEntity : finishDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (LabSettleDetailEntity cdEntity : finishDetailEntities) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.detailService.saveOrUpdateBatch(finishDetailEntities, finishDetailEntities.size(), false);
        }
        return this.queryDetail(entity.getId());
    }

    private Boolean checkUnEffectSettle(LabSettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(LabSettleEntity::getContractId, (Object)finishVO.getContractId());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        return this.service.list((Wrapper)lambda).size() > 0;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LabSettleVO> queryDetail(Long id) {
        LabSettleEntity entity = (LabSettleEntity)((Object)this.service.selectById(id));
        LabSettleVO vo = (LabSettleVO)BeanMapper.map((Object)((Object)entity), LabSettleVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settleId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityList = this.detailService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityList)) {
            for (LabSettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityList, LabSettleDetailVO.class);
            LabSettleController.sortIntMethod(resultMapList);
            List finishDetailVOS = TreeNodeBUtil.buildTree((List)resultMapList);
            vo.setDetailList(finishDetailVOS);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private static void sortIntMethod(List<LabSettleDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                LabSettleDetailVO o1Detail = (LabSettleDetailVO)objectMapper.convertValue(o1, LabSettleDetailVO.class);
                LabSettleDetailVO o2Detail = (LabSettleDetailVO)objectMapper.convertValue(o2, LabSettleDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    @RequestMapping(value={"/queryLastSettle"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LabSettleVO> queryLastSettle(Long contractId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.ne((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u7ed3\u7b97\u5355\uff01");
        }
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.eq((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        query.orderByDesc((Object)"create_time");
        List list1 = this.service.list((Wrapper)query);
        LabSettleVO vo = new LabSettleVO();
        if (CollectionUtils.isNotEmpty((Collection)list1)) {
            LabSettleEntity entity = (LabSettleEntity)((Object)list1.get(0));
            vo.setLastSubmissionMny(null == entity.getTotalSubmissionMny() ? BigDecimal.ZERO : entity.getLastSubmissionMny());
            vo.setLastSubmissionTaxMny(null == entity.getLastSubmissionTaxMny() ? BigDecimal.ZERO : entity.getLastSubmissionTaxMny());
            vo.setLastAuditMny(null == entity.getTotalAuditMny() ? BigDecimal.ZERO : entity.getTotalAuditMny());
            vo.setLastAuditTaxMny(null == entity.getTotalAuditTaxMny() ? BigDecimal.ZERO : entity.getTotalAuditTaxMny());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LabSettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LabSettleVO vo : vos) {
                LabSettleEntity labSettleEntity = (LabSettleEntity)((Object)this.service.selectById(vo.getId()));
                if (CollectionUtils.isNotEmpty(labSettleEntity.getCertificateList())) {
                    List<LabSettleCertificateEntity> certificateList = labSettleEntity.getCertificateList();
                    ArrayList<Long> delIds = new ArrayList<Long>();
                    for (LabSettleCertificateEntity labSettleCertificateEntity : certificateList) {
                        delIds.add(labSettleCertificateEntity.getSourceId());
                    }
                    if (CollectionUtils.isNotEmpty(delIds)) {
                        this.certificateService.settleFlag(delIds, 0);
                    }
                }
                ArrayList<DeductionVO> delList = new ArrayList<DeductionVO>();
                if (CollectionUtils.isNotEmpty(labSettleEntity.getDeductList())) {
                    List<LabSettleDeductEntity> deductList = labSettleEntity.getDeductList();
                    for (LabSettleDeductEntity labSettleDeductEntity : deductList) {
                        DeductionVO deductionVO = new DeductionVO();
                        deductionVO.setId(labSettleDeductEntity.getSettleId());
                        deductionVO.setSettleFlag(Integer.valueOf(0));
                        delList.add(deductionVO);
                    }
                }
                if (!CollectionUtils.isNotEmpty(delList)) continue;
                this.deductionApi.settleFlag(delList);
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<LabSettleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LabSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List labSettleVOS = BeanMapper.mapList((Iterable)list, LabSettleVO.class);
        labSettleVOS.stream().forEach(vo -> vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription()));
        beans.put("records", labSettleVOS);
        ExcelExport.getInstance().export("LabSettle-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLabSettleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<LabSettleVO>> refLabSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LabSettleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryDetailRecord"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LabSettleRecordVo> queryDetailRecord(Long id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)id);
        queryWrapper.in((Object)"bill_state", new ArrayList<Integer>(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        List list = this.service.list((Wrapper)queryWrapper);
        LabSettleRecordVo certificateRecord = new LabSettleRecordVo();
        ArrayList<LabSettleRecordVo> certificateRecordList = new ArrayList<LabSettleRecordVo>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (LabSettleEntity cert : list) {
                LabSettleRecordVo vo = new LabSettleRecordVo();
                vo.setContractId(cert.getContractId());
                vo.setEmployeeName(cert.getEmployeeName());
                vo.setContractTaxMny(cert.getContractMny());
                vo.setSettleTaxMny(cert.getSettleTaxMny());
                vo.setBillCode(cert.getBillCode());
                vo.setId(cert.getId());
                vo.setSettleTaxMny(cert.getSettleTaxMny());
                vo.setSupplierName(cert.getOrgName());
                vo.setSettleDate(cert.getSettleDate());
                certificateRecordList.add(vo);
            }
            certificateRecord.setDetailList(certificateRecordList);
            certificateRecord.setContractId(id);
            certificateRecord.setSupplierName(((LabSettleEntity)((Object)list.get(0))).getOrgName());
            certificateRecord.setContractName(((LabSettleEntity)((Object)list.get(0))).getContractName());
            certificateRecord.setContractTaxMny(((LabSettleEntity)((Object)list.get(0))).getContractMny());
            certificateRecord.setSettleTaxMny(((LabSettleEntity)((Object)list.get(0))).getSettleTaxMny());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8bb0\u5f55\u6570\u636e\u6210\u529f\uff01", (Object)certificateRecord);
    }
}

