/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller;

import com.ejianc.business.sub.service.ISettleReportService;
import com.ejianc.business.sub.vo.SettleReportDetailVO;
import com.ejianc.business.sub.vo.SettleReportVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"settleReport"})
public class SettleReportController
implements Serializable {
    @Autowired
    private ISettleReportService settleReportService;

    @RequestMapping(value={"/queryReport"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SettleReportVO> queryReport(@RequestParam Long contractId, Long settleId, @RequestParam Integer showSum, @RequestParam Integer showThis) {
        return this.settleReportService.queryReport(contractId, settleId, showSum, showThis, true);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.GET})
    @ResponseBody
    public void excelExport(@RequestParam Long contractId, @RequestParam Long settleId, @RequestParam Integer showSum, @RequestParam Integer showThis, HttpServletResponse response) {
        CommonResponse<SettleReportVO> commonResponse = this.settleReportService.queryReport(contractId, settleId, showSum, showThis, false);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            HashMap<String, List> beans = new HashMap<String, List>();
            SettleReportVO settleReportVO = (SettleReportVO)commonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)settleReportVO.getSettleDetailList())) {
                Iterator iterator = settleReportVO.getSettleDetailList().iterator();
                while (iterator.hasNext()) {
                    SettleReportDetailVO detailVO;
                    detailVO.setSourceTypeName((detailVO = (SettleReportDetailVO)iterator.next()).getSourceType() != null && detailVO.getSourceType() == 1 ? "\u5408\u540c\u5185" : "\u5408\u540c\u5916");
                }
            }
            ArrayList<SettleReportVO> list = new ArrayList<SettleReportVO>();
            list.add(settleReportVO);
            beans.put("main", list);
            beans.put("detail", settleReportVO.getSettleDetailList());
            beans.put("oddjob", settleReportVO.getSettleOddjobList());
            beans.put("other", settleReportVO.getSettleOtherList());
            ExcelExport.getInstance().export("settle-report-export.xlsx", beans, response);
        }
    }
}

