/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.FinishEntity;
import com.ejianc.business.sub.bean.SettleEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IFinishService;
import com.ejianc.business.sub.service.ISettlePickDeductService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.SettlePickDeductVO;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.tax.vo.ContractResVO;
import com.ejianc.foundation.share.vo.CustomerVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ICustomerApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sub/"})
public class SubContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IContractService contractService;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private ICustomerApi customerApi;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IFinishService finishService;
    @Autowired
    private ISettlePickDeductService settlePickDeductService;

    @PostMapping(value={"afterApproveInvoiceReceive"})
    public CommonResponse<JSONObject> afterApproveInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(ContractEntity::getSumInvoiceMny, (Object)sumInvoiceMny.add(invoiceMny));
            updateWrapper.set(ContractEntity::getSumInvoiceTaxMny, (Object)sumInvoiceTaxMny.add(invoiceTaxMny));
            boolean flag = this.contractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @PostMapping(value={"afterRevocationInvoiceReceive"})
    public CommonResponse<JSONObject> afterRevocationInvoiceReceive(@RequestParam(value="contractId") Long contractId, @RequestParam(value="invoiceMny") BigDecimal invoiceMny, @RequestParam(value="invoiceTaxMny") BigDecimal invoiceTaxMny) {
        ContractEntity entity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        if (null != entity) {
            BigDecimal sumInvoiceMny = entity.getSumInvoiceMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceMny();
            BigDecimal sumInvoiceTaxMny = entity.getSumInvoiceTaxMny() == null ? BigDecimal.ZERO : entity.getSumInvoiceTaxMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)contractId);
            updateWrapper.set(ContractEntity::getSumInvoiceMny, (Object)sumInvoiceMny.subtract(invoiceMny));
            updateWrapper.set(ContractEntity::getSumInvoiceTaxMny, (Object)sumInvoiceTaxMny.subtract(invoiceTaxMny));
            boolean flag = this.contractService.update((Wrapper)updateWrapper);
            if (flag) {
                return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
            }
            return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38");
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5f02\u5e38!\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f");
    }

    @GetMapping(value={"getSubContractById"})
    public CommonResponse<ContractResVO> getRentContractById(@RequestParam(value="contractId") Long contractId) {
        ContractEntity ContractEntity2 = (ContractEntity)((Object)this.contractService.selectById(contractId));
        ContractResVO rentContractVO = (ContractResVO)BeanMapper.map((Object)((Object)ContractEntity2), ContractResVO.class);
        if (null != ContractEntity2) {
            CommonResponse supplierVOCommonResponse = this.supplierApi.queryById(ContractEntity2.getSupplierId());
            if (supplierVOCommonResponse.isSuccess() && supplierVOCommonResponse.getData() != null) {
                rentContractVO.setSupplierCreditCode(((SupplierVO)supplierVOCommonResponse.getData()).getSocialCreditCode());
            }
            CommonResponse customerVOCommonResponse = this.customerApi.detailById(ContractEntity2.getCustomerId());
            if (supplierVOCommonResponse.isSuccess() && customerVOCommonResponse.getData() != null) {
                rentContractVO.setCustomerCreditCode(((CustomerVO)customerVOCommonResponse.getData()).getSocialCreditCode());
            }
        } else {
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u5931\u8d25!");
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u5408\u540c\u4fe1\u606f\u6210\u529f", (Object)rentContractVO);
    }

    @RequestMapping(value={"/getMonthSubMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SubProjectReportVo>> getMonthSubMny(@RequestParam(value="projectId") Long projectId, @RequestParam(value="lastDay") Integer lastDay) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.contractService.getMonthSubMny(projectId, lastDay));
    }

    @RequestMapping(value={"/getSubContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubProjectReportVo> getSubContract(@RequestParam(value="projectId") Long projectId) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)this.contractService.getSubContract(projectId));
    }

    @RequestMapping(value={"/querySubSettleMoneyByTypeAndProjectIds"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<BigDecimal> querySubSettleMoneyByTypeAndProjectIds(@RequestBody QueryParam param) {
        BaseEntity entity;
        int i;
        List finishEntities = this.finishService.queryList(param, false);
        if (param.getParams().get("projectId") == null) {
            param.getParams().put("projectId", new Parameter("ne", null));
        }
        List settleEntityList = this.settleService.queryList(param, false);
        BigDecimal res = BigDecimal.ZERO;
        if (ListUtil.isNotEmpty((List)settleEntityList)) {
            for (i = 0; i < settleEntityList.size(); ++i) {
                entity = (SettleEntity)((Object)settleEntityList.get(i));
                if (entity.getSettleTaxMny() == null) continue;
                res = res.add(entity.getSettleTaxMny());
            }
        }
        if (ListUtil.isNotEmpty((List)finishEntities)) {
            for (i = 0; i < finishEntities.size(); ++i) {
                entity = (FinishEntity)((Object)finishEntities.get(i));
                if (entity.getShouldPayTaxMny() == null) continue;
                res = res.add(entity.getShouldPayTaxMny());
            }
        }
        this.logger.info("\u6839\u636e \u9879\u76eeids\u67e5\u8be2\u7d2f\u8ba1\u7ed3\u7b97(\u542b\u7a0e)  \u5305\u62ec\u8fc7\u7a0b\u7ed3\u7b97\u548c\u5b8c\u5de5\u7ed3\u7b97 \u53c2\u6570\uff1a{}\uff0cSettleEntity\uff1a{}\uff0cFinishEntity\uff0c{},res:{}", new Object[]{JSONObject.toJSONString((Object)param), JSONObject.toJSONString((Object)settleEntityList), JSONObject.toJSONString((Object)finishEntities), JSONObject.toJSONString((Object)res)});
        return CommonResponse.success((Object)res);
    }

    @RequestMapping(value={"/getSubSettleNum"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SubProjectSettleNumVO>> getSubSettleNum(@RequestParam(value="projectIds") List<Long> projectIds) {
        return CommonResponse.success((String)"\u67e5\u8be2\u67e5\u5206\u5305\u5408\u540c\u7ed3\u7b97\u5de5\u7a0b\u91cf\u6210\u529f\uff01", this.contractService.getSubSettleNum(projectIds));
    }

    @RequestMapping(value={"/queryLastSettlePickDeductMnyList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<SettlePickDeductVO>> queryLastSettlePickDeductMnyList(@RequestBody QueryParam param) {
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"project_id", "supplier_id", "material_id"});
        List<SettlePickDeductVO> list = this.settlePickDeductService.queryLastSettlePickDeductMny(wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97\u548c\u5b8c\u5de5\u7ed3\u7b97\u91d1\u989d\u6210\u529f", list);
    }
}

