/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectDetailProVO;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.api.IFinanceLoadReimburseApi;
import com.ejianc.business.finance.api.IFinancePayReimburseApi;
import com.ejianc.business.finance.api.IFinancePaySporadicApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherContractVO;
import com.ejianc.business.othprice.api.IPicketageApi;
import com.ejianc.business.othprice.vo.PicketageVO;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.mapper.ContractMapper;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.utils.BigDecimalUtils;
import com.ejianc.business.sub.utils.ExcelImportUtil;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.ContractDetailVO;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.ParamsCheckDsVO;
import com.ejianc.business.sub.vo.ParamsCheckVO;
import com.ejianc.business.sub.vo.SqlParam;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.sub.vo.SubProjectSettleNumVO;
import com.ejianc.business.sub.vo.warn.SubWarnVo;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUB_CONTRACT_BILL_CODE = "SUB_CONTRACT";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IFinancePayReimburseApi financePayReimburseApi;
    @Autowired
    private IFinancePaySporadicApi financePaySporadicApi;
    @Autowired
    private IFinanceLoadReimburseApi financeLoadReimburseApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ISettleService settleService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IPicketageApi picketageApi;
    private static String PARAM_LABOR_MNY = "P-9P63m148";
    private static String PARAM_LABOR_DETAIL_NUM = "P-J7c50750";
    private static String PARAM_LABOR_DETAIL_MNY = "P-rj09ju51";
    private static String PARAM_MAJOR_MNY = "P-k3cSoQ49";
    private static String PARAM_MAJOR_DETAIL_NUM = "P-5Z9ASh54";
    private static String PARAM_MAJOR_DETAIL_MNY = "P-RjM0C653";
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ContractVO insertOrUpdate(ContractVO contractVO) {
        if (StringUtils.isBlank((CharSequence)contractVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(SUB_CONTRACT_BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                contractVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(ContractEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.ne(contractVO.getId() != null && contractVO.getId() > 0L, BaseEntity::getId, (Object)contractVO.getId());
        List entities = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        ContractEntity contractEntity = (ContractEntity)((Object)BeanMapper.map((Object)contractVO, ContractEntity.class));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setBeforeChangeMny(contractEntity.getContractMny());
        contractEntity.setBeforeChangeTaxMny(contractEntity.getContractTaxMny());
        contractEntity.setBaseMoney(contractEntity.getContractMny());
        contractEntity.setBaseTaxMoney(contractEntity.getContractTaxMny());
        boolean b = this.saveOrUpdateNoES((Object)contractEntity);
        List<ContractDetailEntity> contractDetailEntityList = contractEntity.getDetailList();
        if (CollectionUtils.isNotEmpty(contractDetailEntityList)) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ContractDetailEntity cdEntity : contractDetailEntityList) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
            this.contractDetailService.saveOrUpdateBatch(contractDetailEntityList);
        }
        if (b) {
            this.countContractNumAndMnyByEnquiry(contractEntity.getEnquiryPriceBillId());
        }
        return this.queryDetail(contractEntity.getId(), true);
    }

    @Override
    public ContractVO queryDetail(Long id, Boolean detailHasChildren) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO contractVO = (ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.contractDetailService.queryList(queryParam, false);
        ArrayList detailEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.\u4e2d\u6b62.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (ContractDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List resultMapList = BeanMapper.mapList(detailEntityList, ContractDetailVO.class);
            ContractServiceImpl.sortIntMethod(resultMapList);
            if (detailHasChildren.booleanValue()) {
                contractVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            } else {
                contractVO.setDetailList(resultMapList);
            }
        } else {
            contractVO.setDetailList(BeanMapper.mapList(detailEntityList, ContractDetailVO.class));
        }
        return contractVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ContractVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> enquiryPriceBillIds;
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BaseEntity::getId, ids);
            queryWrapper.isNotNull(ContractEntity::getEnquiryPriceBillId);
            List materialContractEntities = this.list((Wrapper)queryWrapper);
            boolean b = this.removeByIds(ids, false);
            if (b && CollectionUtils.isNotEmpty((Collection)materialContractEntities) && CollectionUtils.isNotEmpty(enquiryPriceBillIds = materialContractEntities.stream().filter(t -> t.getEnquiryPriceBillId() != null).map(ContractEntity::getEnquiryPriceBillId).collect(Collectors.toList()))) {
                this.countContractNumAndMnyByEnquiry(enquiryPriceBillIds.toArray(new Long[enquiryPriceBillIds.size()]));
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse<IPage<ContractVO>> queryListVOs(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        IPage page = this.queryPage(param, false);
        List contractVOList = BeanMapper.mapList((Iterable)page.getRecords(), ContractVO.class);
        Page contractVOIPage = new Page();
        contractVOIPage.setCurrent(page.getCurrent());
        contractVOIPage.setRecords(contractVOList);
        contractVOIPage.setSize(page.getSize());
        contractVOIPage.setTotal(page.getTotal());
        contractVOIPage.setPages(page.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)contractVOIPage);
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_money) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMoney", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public ContractVO queryRecordDetail(Long id, boolean b) {
        return null;
    }

    @Override
    public List<ContractDetailVO> refContractDetail(Long contractId, String condition) {
        String code = null;
        String name = null;
        boolean filterFlag = false;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            String codeStr = (String)conditionMap.get("code");
            String nameStr = (String)conditionMap.get("name");
            code = StringUtils.isNotBlank((CharSequence)codeStr) ? codeStr : null;
            name = StringUtils.isNotBlank((CharSequence)nameStr) ? nameStr : null;
            filterFlag = code != null || name != null;
        }
        HashMap<Long, ContractDetailEntity> leafMap = new HashMap<Long, ContractDetailEntity>();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List detailEntityListDb = this.contractDetailService.list((Wrapper)wrapper);
        ArrayList<ContractDetailEntity> entities = new ArrayList<ContractDetailEntity>();
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            for (ContractDetailEntity entity : detailEntityListDb) {
                if (entity.getLeafFlag().booleanValue() && (code != null && StringUtils.isNotEmpty((CharSequence)entity.getCode()) && !entity.getCode().contains(code) || name != null && StringUtils.isNotEmpty((CharSequence)entity.getName()) && !entity.getName().contains(name)) || null != entity.getChangeType() && ChangeTypeEnum.\u4e2d\u6b62.getCode() == entity.getChangeType()) continue;
                entities.add(entity);
                if (!entity.getLeafFlag().booleanValue()) continue;
                leafMap.put(entity.getId(), entity);
            }
        }
        List<ContractDetailEntity> resList = null;
        resList = filterFlag ? this.handleFilterData(entities, leafMap) : entities;
        List detailVos = BeanMapper.mapList(resList, ContractDetailVO.class);
        if (CollectionUtils.isNotEmpty((Collection)detailVos)) {
            for (ContractDetailVO cdEntity : detailVos) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
        }
        this.settleService.getSumSettleNum(detailVos);
        List contractDetailVOS = TreeNodeBUtil.buildTree((List)detailVos);
        ContractServiceImpl.sortIntMethod(contractDetailVOS);
        return contractDetailVOS;
    }

    private static void sortIntMethod(List<ContractDetailVO> list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                String[] strs2;
                ObjectMapper objectMapper = new ObjectMapper();
                ContractDetailVO o1Detail = (ContractDetailVO)objectMapper.convertValue(o1, ContractDetailVO.class);
                ContractDetailVO o2Detail = (ContractDetailVO)objectMapper.convertValue(o2, ContractDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                int length = strs1.length > (strs2 = o2Detail.getTreeIndex().split("\\.")).length ? strs1.length : strs2.length;
                for (int i = 0; i < length; ++i) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 <= num2) continue;
                    return 1;
                }
                return 0;
            }
        });
    }

    private List<ContractDetailEntity> handleFilterData(List<ContractDetailEntity> entities, HashMap<Long, ContractDetailEntity> leafMap) {
        if (MapUtils.isEmpty(leafMap)) {
            entities.clear();
            return entities;
        }
        Map<Long, ContractDetailEntity> map = entities.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        ArrayList<ContractDetailEntity> resList = new ArrayList<ContractDetailEntity>();
        for (Long id : leafMap.keySet()) {
            ContractDetailEntity leafContractDetailEntity = leafMap.get(id);
            resList.add(leafContractDetailEntity);
            this.getContractDetaiParent(leafContractDetailEntity, map, resList);
        }
        return resList;
    }

    private void getContractDetaiParent(ContractDetailEntity leafContractDetailEntity, Map<Long, ContractDetailEntity> map, List<ContractDetailEntity> resList) {
        Long parentId = leafContractDetailEntity.getParentId();
        if (null != parentId) {
            resList.add(map.get(parentId));
            this.getContractDetaiParent(map.get(parentId), map, resList);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        JSONObject resp = new JSONObject();
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
            ArrayList<ContractDetailVO> detailVoList = new ArrayList<ContractDetailVO>();
            HashMap<String, String> tidMap = new HashMap<String, String>();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ContractDetailVO vo = new ContractDetailVO();
                boolean flag = false;
                boolean parentWarn = false;
                String warnType = "";
                String detailIndex = (String)datas.get(0);
                vo.setTreeIndex(detailIndex);
                String id = UUID.randomUUID().toString().replaceAll("-", "");
                if (StringUtils.isNotEmpty((CharSequence)detailIndex)) {
                    String[] split = detailIndex.split("[-/.]");
                    vo.setTid(id);
                    tidMap.put(detailIndex, id);
                    if (split.length > 1) {
                        vo.setTpid(detailIndex.substring(0, detailIndex.length() - split[split.length - 1].length() - 1));
                    }
                } else {
                    vo.setTid(id);
                    vo.setTpid("");
                }
                if (indexMap.containsKey(detailIndex)) {
                    return CommonResponse.error((String)("\u7b2c" + (i + 2) + "\u884c\u5e8f\u53f7\u548c\u7b2c" + ((Integer)indexMap.get(detailIndex) + 2) + "\u884c\u91cd\u590d"));
                }
                indexMap.put(detailIndex, i);
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(1)))) {
                    vo.setCode(null);
                    warnType = warnType + "\u6e05\u5355\u7f16\u7801\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setCode((String)datas.get(1));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(2)))) {
                    vo.setName(null);
                    warnType = warnType + "\u6e05\u5355\u540d\u79f0\u4e3a\u7a7a,";
                    flag = true;
                    parentWarn = true;
                } else {
                    vo.setName((String)datas.get(2));
                }
                if (StringUtils.isNotEmpty((CharSequence)((CharSequence)datas.get(3))) && ((String)datas.get(3)).length() > 2000) {
                    flag = true;
                    warnType = warnType + "\u7279\u5f81\u63cf\u8ff0/\u89c4\u683c\u578b\u53f7\u8d85\u8fc72000\u5b57,";
                }
                vo.setSpec((String)datas.get(3));
                vo.setUnit((String)datas.get(4));
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(5)))) {
                    vo.setNum(null);
                    warnType = warnType + "\u5de5\u7a0b\u91cf\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setNum(new BigDecimal((String)datas.get(5)));
                    }
                    catch (Exception e) {
                        vo.setNum(null);
                        warnType = warnType + "\u5de5\u7a0b\u91cf\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(6)))) {
                    vo.setPrice(null);
                    warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u4e3a\u7a7a,";
                    flag = true;
                } else {
                    try {
                        vo.setPrice(new BigDecimal((String)datas.get(6)));
                    }
                    catch (Exception e) {
                        vo.setPrice(null);
                        warnType = warnType + "\u7efc\u5408\u5355\u4ef7\u53ea\u80fd\u4e3a\u6570\u5b57\u6216\u5c0f\u6570,";
                        flag = true;
                    }
                }
                if (!flag) {
                    vo.setMoney(vo.getPrice().multiply(vo.getNum()).setScale(2, 4));
                }
                if ((null == vo.getPrice() || vo.getPrice().compareTo(BigDecimal.ZERO) == 0) && null != vo.getMoney()) {
                    vo.setPrice(BigDecimalUtils.safeDiv(vo.getMoney(), vo.getNum()).setScale(2, 4));
                }
                if ((null == vo.getMoney() || vo.getMoney().compareTo(BigDecimal.ZERO) == 0) && null != vo.getPrice()) {
                    vo.setMoney(BigDecimalUtils.safeMultiply(vo.getNum(), vo.getPrice()).setScale(2, 4));
                }
                vo.setMemo((String)datas.get(8));
                vo.setImportFlag(Boolean.valueOf(!flag));
                vo.setParentWarn(Boolean.valueOf(parentWarn));
                if (flag) {
                    warnType = warnType.substring(0, warnType.length() - 1);
                }
                vo.setWarnType(warnType);
                vo.setRowState("add");
                vo.setShadowId(vo.getTid());
                vo.setChangeType(Integer.valueOf(3));
                detailVoList.add(vo);
            }
            for (ContractDetailVO tVo : detailVoList) {
                tVo.setTpid((String)tidMap.get(tVo.getTpid()));
            }
            List<Map<String, Object>> deailTreeData = ExcelImportUtil.treeData(BeanMapper.mapList(detailVoList, Map.class));
            List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
            ArrayList<Map<String, Object>> falseList = new ArrayList<Map<String, Object>>();
            List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
            List<Map<String, Object>> errorList = ExcelImportUtil.treeToList(allList.get(1));
            resp.put("successList", allList.get(0));
            resp.put("errorList", errorList);
            resp.put("successNum", (Object)(result.size() - errorList.size()));
            resp.put("errorNum", (Object)errorList.size());
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"Excel\u4e3a\u7a7a");
    }

    @Override
    public List<Map<String, Object>> payMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).payMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> prePayMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).prePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> finishMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).finishMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<Map<String, Object>> invoiceContractMnyWarn(List<SqlParam> sqlParamList) {
        return ((ContractMapper)this.baseMapper).invoiceContractMnyWarn(sqlParamList);
    }

    @Override
    public List<SubWarnVo> subProjectOutMny(List<Long> tenantIds) {
        return ((ContractMapper)this.baseMapper).subProjectOutMny(tenantIds);
    }

    @Override
    public List<SubProjectReportVo> getMonthSubMny(Long projectId, Integer lastDay) {
        return ((ContractMapper)this.baseMapper).getMonthSubMny(projectId, lastDay);
    }

    @Override
    public SubProjectReportVo getSubContract(Long projectId) {
        BigDecimal mny = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ContractEntity::getBillState, billStatus);
        List entities = super.list((Wrapper)lambda);
        for (ContractEntity ce : entities) {
            mny = mny.add(ce.getContractTaxMny() == null ? BigDecimal.ZERO : ce.getContractTaxMny());
        }
        BigDecimal settleMny = ((ContractMapper)this.baseMapper).getSubContract(projectId);
        SubProjectReportVo vo = new SubProjectReportVo();
        vo.setNum(Integer.valueOf(entities.size()));
        vo.setMny(mny);
        vo.setSettleMny(settleMny);
        return vo;
    }

    @Override
    public List<SubProjectSettleNumVO> getSubSettleNum(List<Long> projectIds) {
        return ((ContractMapper)this.baseMapper).getSubSettleNum(projectIds);
    }

    @Override
    public ParamsCheckVO checkParams(ContractVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        HashMap paramsCheckVOMap = new HashMap();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        Long contractType = vo.getContractType();
        Integer controlType = 0;
        paramsCheckVO.setWarnType(paramsArray[controlType]);
        ParamsCheckVO pc = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            pc.setWarnType("alert");
            pc.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            pc.setWarnType("warn");
            pc.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            pc.setWarnType("none");
            pc.setDataSource(null);
        }
        return pc;
    }

    private BigDecimal getSjzcje(Long id, Long contractId, Long projectId, BigDecimal mny) {
        BigDecimal fb = ((ContractMapper)this.baseMapper).fetchSjzcje(projectId, id, contractId);
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        CommonResponse fybxCommonResponse = this.financePayReimburseApi.fetchSjzcje(projectId);
        if (!fybxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8d39\u7528\u62a5\u9500\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fybx = (BigDecimal)fybxCommonResponse.getData();
        CommonResponse lxCommonResponse = this.financePaySporadicApi.fetchSjzcje(projectId);
        if (!lxCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u96f6\u661f\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal lx = (BigDecimal)lxCommonResponse.getData();
        CommonResponse yjCommonResponse = this.financeLoadReimburseApi.fetchSjzcje(projectId);
        if (!yjCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5907\u7528\u91d1\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal yj = (BigDecimal)yjCommonResponse.getData();
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    @Override
    public ParamsCheckVO checkParamsDetail(ContractVO vo) {
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        List detailList = vo.getDetailList();
        Long contractType = vo.getContractType();
        Integer controlType = 0;
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
            BudgetProjectProParamControlVO proParamControlVO = new BudgetProjectProParamControlVO();
            proParamControlVO.setProjectId(vo.getProjectId());
            if (contractType.equals(1270328729526124545L)) {
                proParamControlVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType());
                CommonResponse response = this.budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
                if (response.getData() != null) {
                    Map detailProMap = ((BudgetProjectProQuantityAndMnyVO)response.getData()).getDetailProMap();
                    CommonResponse laborDetailNumParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_NUM, vo.getOrgId());
                    if (laborDetailNumParamByCode.isSuccess() && null != laborDetailNumParamByCode.getData()) {
                        List data = (List)laborDetailNumParamByCode.getData();
                        if (CollectionUtils.isNotEmpty((Collection)data)) {
                            for (BillParamVO datum : data) {
                                if (0 == datum.getControlType()) continue;
                                BigDecimal roleValue = datum.getRoleValue();
                                Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                List voDetailList = BeanMapper.mapList((Iterable)detailList, ContractDetailVO.class);
                                voDetailList.forEach(detailVo -> {
                                    if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                        ContractDetailVO contractDetailVO = (ContractDetailVO)detailMap.get(detailVo.getBudgetDetailId());
                                        detailVo.setNum(ComputeUtil.safeAdd((BigDecimal)detailVo.getNum(), (BigDecimal)(contractDetailVO != null ? contractDetailVO.getNum() : BigDecimal.ZERO)));
                                    }
                                });
                                for (ContractDetailVO detailVO : voDetailList) {
                                    BudgetProjectDetailProVO proVO;
                                    BigDecimal proNum;
                                    BigDecimal _proNum;
                                    BigDecimal num = detailVO.getNum();
                                    if (!detailProMap.containsKey(detailVO.getBudgetDetailId()) || num.compareTo(_proNum = ComputeUtil.safeMultiply((BigDecimal)(proNum = (proVO = (BudgetProjectDetailProVO)detailProMap.get(detailVO.getBudgetDetailId())).getNum()), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)))) <= 0) continue;
                                    controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                                    paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                    paramsCheckDsVO.setWarnName("\u52b3\u52a1\u5206\u5305\u5408\u540c\u6e05\u5355\u91cf > \u9884\u7b97\u4eba\u5de5\u8d39\u6e05\u5355\u91cf");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5de5\u7a0b\u91cf\uff1a").append(num.setScale(2, 4)).append("\uff0c\u9884\u7b97\u6e05\u5355\u5de5\u7a0b\u91cf*").append(roleValue).append("%:").append(_proNum.setScale(2, 4)).append("\u3002\u8d85\u51fa\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)num, (BigDecimal)_proNum).setScale(2, 4));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    checkDsVOS.add(paramsCheckDsVO);
                                    ContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                }
                            }
                        }
                    } else {
                        this.logger.info(laborDetailNumParamByCode.getMsg());
                        throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                    }
                    CommonResponse laborDetailMnyParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_LABOR_DETAIL_MNY, vo.getOrgId());
                    if (laborDetailMnyParamByCode.isSuccess() && null != laborDetailMnyParamByCode.getData()) {
                        List data = (List)laborDetailMnyParamByCode.getData();
                        if (CollectionUtils.isNotEmpty((Collection)data)) {
                            for (BillParamVO datum : data) {
                                if (0 == datum.getControlType()) continue;
                                BigDecimal roleValue = datum.getRoleValue();
                                Map<Long, ContractDetailVO> detailMap = this.queryContractDetailMap(vo);
                                List voDetailList = BeanMapper.mapList((Iterable)detailList, ContractDetailVO.class);
                                voDetailList.forEach(detailVo -> {
                                    if (detailMap.containsKey(detailVo.getBudgetDetailId())) {
                                        ContractDetailVO contractDetailVO = (ContractDetailVO)detailMap.get(detailVo.getBudgetDetailId());
                                        detailVo.setMoney(ComputeUtil.safeAdd((BigDecimal)detailVo.getMoney(), (BigDecimal)(contractDetailVO != null ? contractDetailVO.getMoney() : BigDecimal.ZERO)));
                                    }
                                });
                                for (ContractDetailVO detailVO : voDetailList) {
                                    BudgetProjectDetailProVO proVO;
                                    BigDecimal proMny;
                                    BigDecimal _proMny;
                                    BigDecimal money = detailVO.getMoney();
                                    if (!detailProMap.containsKey(detailVO.getBudgetDetailId()) || money.compareTo(_proMny = ComputeUtil.safeMultiply((BigDecimal)(proMny = (proVO = (BudgetProjectDetailProVO)detailProMap.get(detailVO.getBudgetDetailId())).getTaxMny()), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)roleValue, (BigDecimal)BigDecimal.valueOf(100L)))) <= 0) continue;
                                    controlType = datum.getControlType() > controlType ? datum.getControlType() : controlType;
                                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                                    paramsCheckDsVO.setOrgName(datum.getOrgName());
                                    paramsCheckDsVO.setWarnItem(detailVO.getCode() + "-" + detailVO.getName());
                                    paramsCheckDsVO.setWarnName("\u52b3\u52a1\u5206\u5305\u5408\u540c\u6e05\u5355\u5408\u4ef7 > \u9884\u7b97\u4eba\u5de5\u8d39\u6e05\u5355\u5408\u4ef7");
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append("\u5206\u5305\u6e05\u5355\u5408\u4ef7\uff1a").append(money.setScale(2, 4)).append("\uff0c\u9884\u7b97\u6e05\u5355\u5408\u4ef7*").append(roleValue).append("%:").append(_proMny.setScale(2, 4)).append("\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)money, (BigDecimal)_proMny).setScale(2, 4));
                                    paramsCheckDsVO.setContent(stringBuffer.toString());
                                    checkDsVOS.add(paramsCheckDsVO);
                                    ContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, datum, paramsCheckDsVO);
                                }
                            }
                        }
                    } else {
                        this.logger.info(laborDetailMnyParamByCode.getMsg());
                        throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
                    }
                }
            }
            paramsCheckVO.setWarnType(paramsArray[controlType]);
            ParamsCheckVO pc = new ParamsCheckVO();
            if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
                pc.setWarnType("alert");
                pc.setDataSource((List)paramsCheckVOMap.get("alert"));
            } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
                pc.setWarnType("warn");
                pc.setDataSource((List)paramsCheckVOMap.get("warn"));
            } else {
                pc.setWarnType("none");
                pc.setDataSource(null);
            }
            return pc;
        }
        return paramsCheckVO;
    }

    public ContractVO querySumContractTaxMny(Long projectId, Long id, Long contractId, Long contractType) {
        ContractEntity one = new ContractEntity();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"contract_type", (Object)contractType);
        wrapper.eq((Object)"dr", (Object)0);
        if (id != null) {
            wrapper.ne((Object)"id", (Object)id);
        }
        if (contractId != null) {
            wrapper.ne((Object)"id", (Object)contractId);
        }
        wrapper.ne((Object)"change_status", (Object)2);
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            BigDecimal contractTaxMny = list.stream().map(ContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            one.setContractTaxMny(contractTaxMny);
        }
        QueryWrapper cWrapper = new QueryWrapper();
        cWrapper.select(new String[]{" IFNULL(sum(contract_tax_mny),0) AS contractTaxMny"});
        cWrapper.eq((Object)"project_id", (Object)projectId);
        cWrapper.eq((Object)"contract_type", (Object)contractType);
        cWrapper.eq((Object)"dr", (Object)0);
        if (id != null) {
            cWrapper.ne((Object)"id", (Object)id);
        }
        cWrapper.in((Object)"bill_state", new Object[]{BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode(), BillStateEnum.SUSPEND.getBillStateCode()});
        ChangeEntity one1 = (ChangeEntity)((Object)this.changeService.getOne((Wrapper)cWrapper));
        one.setContractTaxMny(ComputeUtil.safeAdd((BigDecimal)one.getContractTaxMny(), (BigDecimal)one1.getContractTaxMny()));
        ContractVO vo = new ContractVO();
        if (one != null) {
            vo = (ContractVO)BeanMapper.map((Object)((Object)one), ContractVO.class);
        }
        return vo;
    }

    public Map<Long, ContractDetailVO> queryContractDetailMap(ContractVO vo) {
        List<ContractDetailVO> voList;
        Map<Long, ContractDetailVO> resMap = new HashMap<Long, ContractDetailVO>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectId", vo.getProjectId());
        map.put("contractType", vo.getContractType());
        map.put("dr", 0);
        if (vo.getId() != null) {
            map.put("id", vo.getId());
        }
        if (vo.getContractId() != null) {
            map.put("contractId", vo.getContractId());
        }
        if (CollectionUtils.isNotEmpty(voList = ((ContractMapper)this.baseMapper).queryContractDetailList(map))) {
            resMap = voList.stream().collect(Collectors.toMap(ContractDetailVO::getBudgetDetailId, contractDetailVO -> contractDetailVO));
        }
        return resMap;
    }

    private static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ContractMapper)this.baseMapper).fetchSjzcje(projectId, null, null);
    }

    @Override
    public PicketageVO countContractNumAndMnyByEnquiry(Long ... enquiryPriceBillIds) {
        if (enquiryPriceBillIds != null && enquiryPriceBillIds.length > 0) {
            for (Long enquiryPriceBillId : enquiryPriceBillIds) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.select(new String[]{"count(1) as num, IFNULL(sum(contract_tax_mny),0) as money"}).eq((Object)"enquiry_price_bill_id", (Object)enquiryPriceBillId);
                Map map = this.getMap((Wrapper)queryWrapper);
                PicketageVO picketageVO = new PicketageVO();
                if (MapUtils.isNotEmpty((Map)map)) {
                    Integer num = map.get("num") != null ? Integer.valueOf(map.get("num").toString()) : 0;
                    BigDecimal money = ComputeUtil.toBigDecimal(map.get("money"));
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(num);
                    picketageVO.setContractSignMny(money);
                } else {
                    picketageVO.setId(enquiryPriceBillId);
                    picketageVO.setContractSign(Integer.valueOf(0));
                    picketageVO.setContractSignMny(BigDecimal.ZERO);
                }
                this.picketageApi.updateContractSignMny(picketageVO);
            }
        }
        return null;
    }

    @Override
    public CommonResponse<String> onFile(OtherContractVO contractVO) {
        ContractEntity entity = (ContractEntity)((Object)this.selectById(contractVO.getId()));
        if ("1".equals(entity.getFileState())) {
            throw new BusinessException("\u4e0d\u80fd\u91cd\u590d\u5f52\u6863");
        }
        entity.setFileState("1");
        this.saveOrUpdate((Object)entity, false);
        CommonResponse back = this.attachmentApi.updateAttachRef(contractVO.getId(), contractVO.getAttachIds());
        if (!back.isSuccess()) {
            throw new BusinessException("\u5f52\u6863\u5931\u8d25");
        }
        return CommonResponse.success((String)"\u5f52\u6863\u6210\u529f\uff01");
    }
}

