package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包完工结算零工表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_finish_oddjob")
public class FinishOddjobEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 完工结算ID
     */
    @TableField("finish_id")
    private Long finishId;

    /**
     * 零工ID
     */
    @TableField("oddjob_id")
    private Long oddjobId;

    /**
     * 零工单号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 零工总金额
     */
    @TableField("job_mny")
    private BigDecimal jobMny;

    /**
     * 零工总金额（含税）
     */
    @TableField("job_tax_mny")
    private BigDecimal jobTaxMny;

    /**
     * 结算金额
     */
    @TableField("settle_mny")
    private BigDecimal settleMny;

    /**
     * 用工摘要
     */
    @TableField("roundup")
    private String roundup;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    public Long getFinishId() {
        return finishId;
    }

    public void setFinishId(Long finishId) {
        this.finishId = finishId;
    }
    public Long getOddjobId() {
        return oddjobId;
    }

    public void setOddjobId(Long oddjobId) {
        this.oddjobId = oddjobId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    public void setJobTaxMny(BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public String getRoundup() {
        return roundup;
    }

    public void setRoundup(String roundup) {
        this.roundup = roundup;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
