package com.ejianc.business.sub.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 劳务结算
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sub_lab_settle")
public class LabSettleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 结算单号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额(不含税)
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_submission_mny")
    private BigDecimal contractSubmissionMny; // 合同报送金额(不含税)
    @TableField(value="contract_submission_tax_mny")
    private BigDecimal contractSubmissionTaxMny; // 合同报送金额
    @TableField(value="supplier_id")
    private Long supplierId; // 分包供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 分包供应商

    @TableField(value="audit_mny")
    private BigDecimal auditMny; // 合同审核金额(不含税)
    @TableField(value="audit_tax_mny")
    private BigDecimal auditTaxMny; // 合同审核金额
    @TableField(value="certificate_submission_mny")
    private BigDecimal certificateSubmissionMny; // 签证报送金额(不含税)
    @TableField(value="certificate_submission_tax_mny")
    private BigDecimal certificateSubmissionTaxMny; // 签证报送金额

    @TableField(value="certificate_audit_mny")
    private BigDecimal certificateAuditMny; // 签证审核金额(不含税)
    @TableField(value="certificate_audit_tax_mny")
    private BigDecimal certificateAuditTaxMny; // 签证审核金额

    @TableField(value="total_submission_mny")
    private BigDecimal totalSubmissionMny; // 报送金额合计
    @TableField(value="total_submission_tax_mny")
    private BigDecimal totalSubmissionTaxMny; // 报送金额合计
    @TableField(value="last_submission_mny")
    private BigDecimal lastSubmissionMny; // 报送金额历史报送金额
    @TableField(value="last_submission_tax_mny")
    private BigDecimal lastSubmissionTaxMny; // 报送金额历史报送金额


    @TableField(value="last_audit_mny")
    private BigDecimal lastAuditMny; // 审核金额历史(不含税)
    @TableField(value="last_audit_tax_mny")
    private BigDecimal lastAuditTaxMny; // 审核金额历史

    @TableField(value="total_audit_mny")
    private BigDecimal totalAuditMny; // 审核金额合计(不含税)
    @TableField(value="total_audit_tax_mny")
    private BigDecimal totalAuditTaxMny; // 审核金额合计


    @TableField(value="total_allowance_mny")
    private BigDecimal totalAllowanceMny; // 审减金额合计(不含税)
    @TableField(value="total_allowance_tax_mny")
    private BigDecimal totalAllowanceTaxMny; // 审减金额合计
    @TableField(value="exceed_allowance_mny")
    private BigDecimal exceedAllowanceMny; // 超过审减额扣款(不含税)
    @TableField(value="exceed_allowance_tax_mny")
    private BigDecimal exceedAllowanceTaxMny; // 超过审减额扣款
    @TableField(value="allowance_rate")
    private BigDecimal allowanceRate; // 审减率
    @TableField(value="income_deduct_mny")
    private BigDecimal incomeDeductMny; // 施工过程扣款合计(不含税)
    @TableField(value="income_deduct_tax_mny")
    private BigDecimal incomeDeductTaxMny; // 施工过程扣款合计
    @TableField(value="total_other_mny")
    private BigDecimal totalOtherMny; // 其他费用合计(不含税)
    @TableField(value="total_other_tax_mny")
    private BigDecimal totalOtherTaxMny; // 其他费用合计
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="settle_mny")
    private BigDecimal settleMny; // 结算总金额(不含税)
    @TableField(value="settle_tax_mny")
    private BigDecimal settleTaxMny; // 结算总金额
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value="settle_date")
    private Date settleDate; // 结算日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="depart_id")
    private Long departId; // 申请部门id
    @TableField(value="depart_name")
    private String departName; // 申请部门
    @TableField(value="sum_apply_mny")
    private BigDecimal sumApplyMny; // 累计申请金额
    @TableField(value="surplus_apply_mny")
    private BigDecimal surplusApplyMny; // 剩余可申请金额
    @TableField(value="settle_scale")
    private BigDecimal settleScale; // 完工结算比例
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sum_invoice_tax_mny")
    private BigDecimal sumInvoiceTaxMny; // 累计收票金额
    @TableField(value="quality_assurance_mny")
    private BigDecimal qualityAssuranceMny; // 质保金
    @TableField(value="paid_money")
    private BigDecimal paidMoney; // 已付金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="labSettleDetailService",pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<LabSettleDetailEntity> detailList = new ArrayList<>(); // 劳务结算-明细表
    @TableField(exist=false)
    @SubEntity(serviceName="labSettleCertificateService",pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<LabSettleCertificateEntity> certificateList = new ArrayList<>(); // 劳务结算-分包签证表
    @TableField(exist=false)
    @SubEntity(serviceName="labSettleDeductService",pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<LabSettleDeductEntity> deductList = new ArrayList<>(); // 劳务结算-施工工程扣款
    @TableField(exist=false)
    @SubEntity(serviceName="labSettleOtherService",pidName = "settleId")//此处有pid="xxx"，默认值pid="pid"
    private List<LabSettleOtherEntity> otherList = new ArrayList<>(); // 劳务结算-其他费用

    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;


    /**
     * 累计预付款金额
     */
    @TableField("sum_prepay_mny")
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public BigDecimal getLastSubmissionMny() {
        return lastSubmissionMny;
    }

    public void setLastSubmissionMny(BigDecimal lastSubmissionMny) {
        this.lastSubmissionMny = lastSubmissionMny;
    }

    public BigDecimal getLastSubmissionTaxMny() {
        return lastSubmissionTaxMny;
    }

    public void setLastSubmissionTaxMny(BigDecimal lastSubmissionTaxMny) {
        this.lastSubmissionTaxMny = lastSubmissionTaxMny;
    }

    public BigDecimal getLastAuditMny() {
        return lastAuditMny;
    }

    public void setLastAuditMny(BigDecimal lastAuditMny) {
        this.lastAuditMny = lastAuditMny;
    }

    public BigDecimal getLastAuditTaxMny() {
        return lastAuditTaxMny;
    }

    public void setLastAuditTaxMny(BigDecimal lastAuditTaxMny) {
        this.lastAuditTaxMny = lastAuditTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getCertificateAuditMny() {
        return certificateAuditMny;
    }

    public void setCertificateAuditMny(BigDecimal certificateAuditMny) {
        this.certificateAuditMny = certificateAuditMny;
    }

    public BigDecimal getCertificateAuditTaxMny() {
        return certificateAuditTaxMny;
    }

    public void setCertificateAuditTaxMny(BigDecimal certificateAuditTaxMny) {
        this.certificateAuditTaxMny = certificateAuditTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getContractSubmissionMny() {
        return contractSubmissionMny;
    }

    public void setContractSubmissionMny(BigDecimal contractSubmissionMny) {
        this.contractSubmissionMny = contractSubmissionMny;
    }
    public BigDecimal getContractSubmissionTaxMny() {
        return contractSubmissionTaxMny;
    }

    public void setContractSubmissionTaxMny(BigDecimal contractSubmissionTaxMny) {
        this.contractSubmissionTaxMny = contractSubmissionTaxMny;
    }
    public BigDecimal getAuditMny() {
        return auditMny;
    }

    public void setAuditMny(BigDecimal auditMny) {
        this.auditMny = auditMny;
    }
    public BigDecimal getAuditTaxMny() {
        return auditTaxMny;
    }

    public void setAuditTaxMny(BigDecimal auditTaxMny) {
        this.auditTaxMny = auditTaxMny;
    }
    public BigDecimal getCertificateSubmissionMny() {
        return certificateSubmissionMny;
    }

    public void setCertificateSubmissionMny(BigDecimal certificateSubmissionMny) {
        this.certificateSubmissionMny = certificateSubmissionMny;
    }
    public BigDecimal getCertificateSubmissionTaxMny() {
        return certificateSubmissionTaxMny;
    }

    public void setCertificateSubmissionTaxMny(BigDecimal certificateSubmissionTaxMny) {
        this.certificateSubmissionTaxMny = certificateSubmissionTaxMny;
    }
    public BigDecimal getTotalSubmissionMny() {
        return totalSubmissionMny;
    }

    public void setTotalSubmissionMny(BigDecimal totalSubmissionMny) {
        this.totalSubmissionMny = totalSubmissionMny;
    }
    public BigDecimal getTotalSubmissionTaxMny() {
        return totalSubmissionTaxMny;
    }

    public void setTotalSubmissionTaxMny(BigDecimal totalSubmissionTaxMny) {
        this.totalSubmissionTaxMny = totalSubmissionTaxMny;
    }
    public BigDecimal getTotalAuditMny() {
        return totalAuditMny;
    }

    public void setTotalAuditMny(BigDecimal totalAuditMny) {
        this.totalAuditMny = totalAuditMny;
    }
    public BigDecimal getTotalAuditTaxMny() {
        return totalAuditTaxMny;
    }

    public void setTotalAuditTaxMny(BigDecimal totalAuditTaxMny) {
        this.totalAuditTaxMny = totalAuditTaxMny;
    }
    public BigDecimal getTotalAllowanceMny() {
        return totalAllowanceMny;
    }

    public void setTotalAllowanceMny(BigDecimal totalAllowanceMny) {
        this.totalAllowanceMny = totalAllowanceMny;
    }
    public BigDecimal getTotalAllowanceTaxMny() {
        return totalAllowanceTaxMny;
    }

    public void setTotalAllowanceTaxMny(BigDecimal totalAllowanceTaxMny) {
        this.totalAllowanceTaxMny = totalAllowanceTaxMny;
    }
    public BigDecimal getExceedAllowanceMny() {
        return exceedAllowanceMny;
    }

    public void setExceedAllowanceMny(BigDecimal exceedAllowanceMny) {
        this.exceedAllowanceMny = exceedAllowanceMny;
    }
    public BigDecimal getExceedAllowanceTaxMny() {
        return exceedAllowanceTaxMny;
    }

    public void setExceedAllowanceTaxMny(BigDecimal exceedAllowanceTaxMny) {
        this.exceedAllowanceTaxMny = exceedAllowanceTaxMny;
    }
    public BigDecimal getAllowanceRate() {
        return allowanceRate;
    }

    public void setAllowanceRate(BigDecimal allowanceRate) {
        this.allowanceRate = allowanceRate;
    }
    public BigDecimal getIncomeDeductMny() {
        return incomeDeductMny;
    }

    public void setIncomeDeductMny(BigDecimal incomeDeductMny) {
        this.incomeDeductMny = incomeDeductMny;
    }
    public BigDecimal getIncomeDeductTaxMny() {
        return incomeDeductTaxMny;
    }

    public void setIncomeDeductTaxMny(BigDecimal incomeDeductTaxMny) {
        this.incomeDeductTaxMny = incomeDeductTaxMny;
    }
    public BigDecimal getTotalOtherMny() {
        return totalOtherMny;
    }

    public void setTotalOtherMny(BigDecimal totalOtherMny) {
        this.totalOtherMny = totalOtherMny;
    }
    public BigDecimal getTotalOtherTaxMny() {
        return totalOtherTaxMny;
    }

    public void setTotalOtherTaxMny(BigDecimal totalOtherTaxMny) {
        this.totalOtherTaxMny = totalOtherTaxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Date getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(Date settleDate) {
        this.settleDate = settleDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartId() {
        return departId;
    }

    public void setDepartId(Long departId) {
        this.departId = departId;
    }
    public String getDepartName() {
        return departName;
    }

    public void setDepartName(String departName) {
        this.departName = departName;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }
    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }
    public BigDecimal getSettleScale() {
        return settleScale;
    }

    public void setSettleScale(BigDecimal settleScale) {
        this.settleScale = settleScale;
    }
    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getSumInvoiceTaxMny() {
        return sumInvoiceTaxMny;
    }

    public void setSumInvoiceTaxMny(BigDecimal sumInvoiceTaxMny) {
        this.sumInvoiceTaxMny = sumInvoiceTaxMny;
    }
    public BigDecimal getQualityAssuranceMny() {
        return qualityAssuranceMny;
    }

    public void setQualityAssuranceMny(BigDecimal qualityAssuranceMny) {
        this.qualityAssuranceMny = qualityAssuranceMny;
    }
    public BigDecimal getPaidMoney() {
        return paidMoney;
    }

    public void setPaidMoney(BigDecimal paidMoney) {
        this.paidMoney = paidMoney;
    }
    
    public List<LabSettleDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<LabSettleDetailEntity> detailList) {
        this.detailList = detailList;
    }
    public List<LabSettleCertificateEntity> getCertificateList() {
        return certificateList;
    }

    public void setCertificateList(List<LabSettleCertificateEntity> certificateList) {
        this.certificateList = certificateList;
    }
    public List<LabSettleDeductEntity> getDeductList() {
        return deductList;
    }

    public void setDeductList(List<LabSettleDeductEntity> deductList) {
        this.deductList = deductList;
    }
    public List<LabSettleOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<LabSettleOtherEntity> otherList) {
        this.otherList = otherList;
    }
}
