package com.ejianc.business.sub.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 分包过程结算零工表
 * </p>
 *
 * @author zhangwx
 * @since 2020-06-05
 */
@TableName("ejc_sub_settle_oddjob")
public class SettleOddjobEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 过程结算ID
     */
    @TableField("settle_id")
    private Long settleId;

    /**
     * 零工ID
     */
    @TableField("oddjob_id")
    private Long oddjobId;

    /**
     * 零工单号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 零工总金额
     */
    @TableField("job_mny")
    private BigDecimal jobMny;

    /**
     * 零工总金额（含税）
     */
    @TableField("job_tax_mny")
    private BigDecimal jobTaxMny;

    /**
     * 结算金额
     */
    @TableField("settle_mny")
    private BigDecimal settleMny;

    /**
     * 用工摘要
     */
    @TableField("roundup")
    private String roundup;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public Long getOddjobId() {
        return oddjobId;
    }

    public void setOddjobId(Long oddjobId) {
        this.oddjobId = oddjobId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getJobMny() {
        return jobMny;
    }

    public void setJobMny(BigDecimal jobMny) {
        this.jobMny = jobMny;
    }
    public BigDecimal getJobTaxMny() {
        return jobTaxMny;
    }

    public void setJobTaxMny(BigDecimal jobTaxMny) {
        this.jobTaxMny = jobTaxMny;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public String getRoundup() {
        return roundup;
    }

    public void setRoundup(String roundup) {
        this.roundup = roundup;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
