package com.ejianc.business.sub.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sub.bean.WorkerPresentDetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人在场统计
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sub_worker_present")
public class WorkerPresentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="project_id")
    private Long projectId; // 所属项目Id
    @TableField(value="project_name")
    private String projectName; // 所属项目名称
    @TableField(value="project_code")
    private String projectCode; // 所属项目编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办部门id
    @TableField(value="department_name")
    private String departmentName; // 经办部门
    @TableField(value="supplier_id")
    private Long supplierId; // 分包单位
    @TableField(value="supplier_name")
    private String supplierName; // 分包单位
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="present_num")
    private Integer presentNum; // 在场人数
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 编制日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="workerPresentDetailService")
    private List<WorkerPresentDetailEntity> workerPresentDetailList = new ArrayList<>(); // 工人现场统计明细
    

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Integer getPresentNum() {
        return presentNum;
    }

    public void setPresentNum(Integer presentNum) {
        this.presentNum = presentNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    

    public List<WorkerPresentDetailEntity> getWorkerPresentDetailList() {
        return workerPresentDetailList;
    }

    public void setWorkerPresentDetailList(List<WorkerPresentDetailEntity> workerPresentDetailList) {
        this.workerPresentDetailList = workerPresentDetailList;
    }
}
