package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.api.IDeductionApi;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ParamUtil;
import com.ejianc.business.finance.vo.DeductionVO;
import com.ejianc.business.sub.bean.*;
import com.ejianc.business.sub.service.ICertificateService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ILabSettleDetailService;
import com.ejianc.business.sub.service.ILabSettleService;
import com.ejianc.business.sub.utils.TreeNodeBUtil;
import com.ejianc.business.sub.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 劳务结算
 *
 * @author generator
 */
@Controller
@RequestMapping("labSettle")
public class LabSettleController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LWJS";//此处需要根据实际修改

    @Autowired
    private ILabSettleService service;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    private ILabSettleDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDeductionApi deductionApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<LabSettleVO> saveOrUpdate(@RequestBody LabSettleVO saveOrUpdateVO) {
        if (checkUnEffectSettle(saveOrUpdateVO)) {
            throw new BusinessException("一个合同只做一个劳务结算单!");
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getCertificateList())) {
            List<LabSettleCertificateVO> certificateList = saveOrUpdateVO.getCertificateList();
            List<Long> ids = new ArrayList<>();
            List<Long> delIds = new ArrayList<>();
            for (LabSettleCertificateVO certificate : certificateList) {
                if (certificate.getRowState() != null && !certificate.getRowState().equals("del")) {
                    ids.add(certificate.getSourceId());
                } else if (certificate.getRowState() != null && certificate.getRowState().equals("del")) {
                    delIds.add(certificate.getSourceId());
                }
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                certificateService.settleFlag(ids, 1);
            }
            if (CollectionUtils.isNotEmpty(delIds)) {
                certificateService.settleFlag(delIds, 0);
            }
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getDeductList())) {
            List<LabSettleDeductVO> certificateList = saveOrUpdateVO.getDeductList();

            List<DeductionVO> list = new ArrayList<>();
            List<DeductionVO> delList = new ArrayList<>();


            for (LabSettleDeductVO certificate : certificateList) {
                if (certificate.getRowState() == null || !certificate.getRowState().equals("del")) {
                    DeductionVO deductionVO = new DeductionVO();
                    deductionVO.setId(certificate.getSourceId());
                    deductionVO.setSettleFlag(1);
                    list.add(deductionVO);
                } else if (certificate.getRowState() != null && certificate.getRowState().equals("del")) {
                    DeductionVO deductionVO = new DeductionVO();
                    deductionVO.setId(certificate.getSourceId());
                    deductionVO.setSettleFlag(0);
                    delList.add(deductionVO);
                }
            }
            if (CollectionUtils.isNotEmpty(list)) {
                CommonResponse<String> stringCommonResponse = deductionApi.settleFlag(list);
                if (!stringCommonResponse.isSuccess()) {
                    throw new BusinessException(stringCommonResponse.getMsg());
                }
            }
            if (CollectionUtils.isNotEmpty(delList)) {
                deductionApi.settleFlag(delList);
            }
        }

        LabSettleEntity entity = BeanMapper.map(saveOrUpdateVO, LabSettleEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }


        //保存前清空主键和父主键，重新生成
        List<LabSettleDetailEntity> beforeDetails = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == entity.getId()) {
            for (LabSettleDetailEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        service.saveOrUpdate(entity, false);
        List<LabSettleDetailEntity> finishDetailEntities = entity.getDetailList();
        if (CollectionUtils.isNotEmpty(finishDetailEntities)) {
            Map<String, Long> idMap = new HashMap<>();
            for (LabSettleDetailEntity cdEntity : finishDetailEntities) {
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (LabSettleDetailEntity cdEntity : finishDetailEntities) {
                if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            detailService.saveOrUpdateBatch(finishDetailEntities, finishDetailEntities.size(), false);
        }

        return queryDetail(entity.getId());
    }

    private Boolean checkUnEffectSettle(LabSettleVO finishVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper<LabSettleEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(LabSettleEntity::getContractId, finishVO.getContractId());
        if (finishVO.getId() != null){
            lambda.ne(LabSettleEntity::getId, finishVO.getId());
        }
        lambda.eq(LabSettleEntity::getTenantId, tenantId);
        return service.list(lambda).size() > 0;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LabSettleVO> queryDetail(Long id) {
        LabSettleEntity entity = service.selectById(id);
        LabSettleVO vo = BeanMapper.map(entity, LabSettleVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("settle_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("tree_index", "asc");
        List<LabSettleDetailEntity> detailEntityList = detailService.queryList(queryParam);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {

            for (LabSettleDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<LabSettleDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, LabSettleDetailVO.class);
            sortIntMethod(resultMapList);
            List<LabSettleDetailVO> finishDetailVOS = TreeNodeBUtil.buildTree(resultMapList);
            vo.setDetailList(finishDetailVOS);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    private static void sortIntMethod(List<LabSettleDetailVO> list) {
        Collections.sort(list, new Comparator() {
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                LabSettleDetailVO o1Detail = objectMapper.convertValue(o1, LabSettleDetailVO.class);
                LabSettleDetailVO o2Detail = objectMapper.convertValue(o2, LabSettleDetailVO.class);
                String[] strs1 = o1Detail.getTreeIndex().split("\\.");
                String[] strs2 = o2Detail.getTreeIndex().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2) {
                        return -1;
                    }
                    if (num1 > num2) {
                        return 1;
                    }
                }
                return 0;
            }
        });
    }

    @RequestMapping(value = "/queryLastSettle", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryLastSettle(Long contractId) {
        QueryWrapper<LabSettleEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        List<LabSettleEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            return CommonResponse.error("该合同已存在分包结算单，不能重复新增！");
        }
        return CommonResponse.success("查询详情数据成功！" );

    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LabSettleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (LabSettleVO vo : vos) {
                LabSettleEntity labSettleEntity = service.selectById(vo.getId());
                if (CollectionUtils.isNotEmpty(labSettleEntity.getCertificateList())) {
                    List<LabSettleCertificateEntity> certificateList = labSettleEntity.getCertificateList();
                    List<Long> delIds = new ArrayList<>();
                    for (LabSettleCertificateEntity certificate : certificateList) {
                        delIds.add(certificate.getSourceId());
                    }
                    if (CollectionUtils.isNotEmpty(delIds)) {
                        certificateService.settleFlag(delIds, 0);
                    }
                }
                List<DeductionVO> delList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(labSettleEntity.getDeductList())) {
                    List<LabSettleDeductEntity> deductList = labSettleEntity.getDeductList();
                    for (LabSettleDeductEntity certificate : deductList) {
                        DeductionVO deductionVO = new DeductionVO();
                        deductionVO.setId(certificate.getSettleId());
                        deductionVO.setSettleFlag(0);
                        delList.add(deductionVO);
                    }
                }
                if (CollectionUtils.isNotEmpty(delList)) {
                    deductionApi.settleFlag(delList);
                }
            }
        }
        service.removeByIds(vos.stream().map(LabSettleVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<LabSettleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<LabSettleEntity> page = service.queryPage(param, false);
        IPage<LabSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabSettleVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<LabSettleEntity> list = service.queryList(param);

        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<LabSettleVO> labSettleVOS = BeanMapper.mapList(list, LabSettleVO.class);
        labSettleVOS.stream().forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        });
        beans.put("records", labSettleVOS);
        ExcelExport.getInstance().export("LabSettle-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refLabSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<LabSettleVO>> refLabSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<LabSettleEntity> page = service.queryPage(param, false);
        IPage<LabSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), LabSettleVO.class));
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @Autowired
    private IContractService contractService;
    @RequestMapping(value = "/queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<LabSettleRecordVo> queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);

        QueryWrapper<LabSettleEntity> queryWrapper =  new QueryWrapper<>();
        queryWrapper.eq("contract_id",id);
        queryWrapper.in("bill_state",new ArrayList<>(Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<LabSettleEntity> list = service.list(queryWrapper);
        LabSettleRecordVo certificateRecord =  new LabSettleRecordVo();
        List<LabSettleRecordVo> certificateRecordList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            for (LabSettleEntity cert : list){
                LabSettleRecordVo vo = new LabSettleRecordVo();
                vo.setContractId(cert.getContractId());
                vo.setEmployeeName(cert.getEmployeeName());
                vo.setContractTaxMny(cert.getContractMny());
                vo.setSettleTaxMny(cert.getSettleTaxMny());
                vo.setBillCode(cert.getBillCode());
                vo.setId(cert.getId());
                vo.setSettleTaxMny(cert.getSettleTaxMny());
                vo.setSupplierName(cert.getOrgName());
                vo.setSettleDate(cert.getSettleDate());
                certificateRecordList.add(vo);
            }
            certificateRecord.setDetailList(certificateRecordList);
            certificateRecord.setSettleTaxMny(list.get(0).getSettleTaxMny());
        }else {
            certificateRecord.setSettleTaxMny(new BigDecimal("0"));
        }
        certificateRecord.setSupplierName(contractEntity.getSupplierName());
        certificateRecord.setContractName(contractEntity.getContractName());
        certificateRecord.setContractTaxMny(contractEntity.getContractTaxMny());
        certificateRecord.setContractId(id);
        return CommonResponse.success("查询记录数据成功！", certificateRecord);
    }


    @RequestMapping(value = "/subSettlementRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> subSettlementRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("contractName");
        queryParam.getFuzzyFields().add("billCode");
        queryParam.getFuzzyFields().add("supplierName");
        if(StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if(null == conditionMap.get("type") || !"settleReport".equals(conditionMap.get("type"))) {
                /** 剩余可申请金额不等于0  */
                ComplexParam c4 = ParamUtil.getOrParam("surplusApplyMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
                queryParam.getComplexParams().add(c4);
            }
        }

//        ComplexParam c5 = ParamUtil.getOrParam("shouldPayTaxMny", new Parameter(QueryParam.NE, 0), new Parameter(QueryParam.EQ, null));
//        queryParam.getComplexParams().add(c5);
        queryParam.getParams().put("tenantId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("create_time",QueryParam.DESC);
        if(StringUtils.isNotBlank(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                queryParam.getParams().put("contractId",new Parameter(QueryParam.EQ,con.getLong("contractId")));
            }
            if(condition.contains("orgId")){
                queryParam.getParams().put("orgId",new Parameter(QueryParam.EQ,con.getLong("orgId")));
            }
            if(condition.contains("supplierId")){
                queryParam.getParams().put("supplierId",new Parameter(QueryParam.EQ,con.getLong("supplierId")));
            }
        }
        JSONObject page = service.querySubSettleVOList(queryParam,false);
        return CommonResponse.success("参照查询成功！", page);
    }
}
