package com.ejianc.business.sub.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISettleService;
import com.ejianc.business.sub.vo.ContractVO;
import com.ejianc.business.sub.vo.SettleVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * TODO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping(value = "/api/contract")
public class ContractApi {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IContractService service;

	@Autowired
	private ISettleService settleService;

	@GetMapping(value = "fetchSjzcje")
	public CommonResponse<BigDecimal> fetchSjzcje(@RequestParam(value = "projectId") Long projectId) {
		return CommonResponse.success(service.fetchSjzcje(projectId));
	}

	@PostMapping(value = "getContractByCondition")
	@ResponseBody
	public CommonResponse<List<ContractVO>> getContractByCondition(@RequestBody List<Long> enquiryPriceBillIds) {
		LambdaUpdateWrapper<ContractEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
		lambdaUpdateWrapper.in(ContractEntity::getEnquiryPriceBillId, enquiryPriceBillIds);
		lambdaUpdateWrapper.orderByDesc(ContractEntity::getSignDate);
		List<ContractEntity> list = service.list(lambdaUpdateWrapper);
		return CommonResponse.success(BeanMapper.mapList(list, ContractVO.class));
	}

	@GetMapping(value = "getSettleVO")
	public CommonResponse<SettleVO> getSettleVO(@RequestParam(value = "settleId") Long settleId) {
		return CommonResponse.success(settleService.queryDetail(settleId, true));
	}


	@PostMapping(value = "getContractList")
	public CommonResponse<IPage<ContractVO>> getContractList(@RequestBody QueryParam param) {
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("orgName");
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("customerName");
		fuzzyFields.add("employeeName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		IPage<ContractEntity> page = service.queryPage(param, false);
		IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));
		return CommonResponse.success("查询列表数据成功！", pageData);
	}

}
